/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.filechooser;

import java.util.Collection;
import java.util.List;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.IDisplayParent;
import org.eclipse.scout.rt.client.ui.basic.filechooser.FileChooserEvent;
import org.eclipse.scout.rt.client.ui.basic.filechooser.FileChooserListener;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooserUIFacade;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.DisplayParentResolver;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.job.IBlockingCondition;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;

public class FileChooser
implements IFileChooser {
    private final IFileChooserUIFacade m_uiFacade;
    private final FastListenerList<FileChooserListener> m_listenerList = new FastListenerList();
    private final List<String> m_fileExtensions;
    private final boolean m_multiSelect;
    private List<BinaryResource> m_files;
    private final IBlockingCondition m_blockingCondition;
    private long m_maximumUploadSize;
    private IDisplayParent m_displayParent;

    public FileChooser() {
        this(null, false);
    }

    public FileChooser(boolean multiSelect) {
        this(null, multiSelect);
    }

    public FileChooser(Collection<String> fileExtensions) {
        this(fileExtensions, false);
    }

    public FileChooser(Collection<String> fileExtensions, boolean multiSelect) {
        this.m_uiFacade = new P_UIFacade();
        this.m_blockingCondition = Jobs.newBlockingCondition((boolean)false);
        this.m_fileExtensions = CollectionUtility.arrayListWithoutNullElements(fileExtensions);
        this.m_multiSelect = multiSelect;
        this.m_maximumUploadSize = 0x3200000L;
        this.m_displayParent = ((DisplayParentResolver)BEANS.get(DisplayParentResolver.class)).resolve(this);
    }

    @Override
    public IFileChooserUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public IDisplayParent getDisplayParent() {
        return this.m_displayParent;
    }

    @Override
    public void setDisplayParent(IDisplayParent displayParent) {
        Assertions.assertFalse((boolean)ClientSessionProvider.currentSession().getDesktop().isShowing(this), (String)"Property 'displayParent' cannot be changed because FileChooser is already showing [fileChooser={}]", (Object[])new Object[]{this});
        if (displayParent == null) {
            displayParent = ((DisplayParentResolver)BEANS.get(DisplayParentResolver.class)).resolve(this);
        }
        this.m_displayParent = (IDisplayParent)Assertions.assertNotNull((Object)displayParent, (String)"'displayParent' must not be null", (Object[])new Object[0]);
    }

    @Override
    public IFastListenerList<FileChooserListener> fileChooserListeners() {
        return this.m_listenerList;
    }

    @Override
    public List<String> getFileExtensions() {
        return CollectionUtility.arrayList(this.m_fileExtensions);
    }

    @Override
    public boolean isMultiSelect() {
        return this.m_multiSelect;
    }

    @Override
    public void setMaximumUploadSize(long maximumUploadSize) {
        this.m_maximumUploadSize = maximumUploadSize;
    }

    @Override
    public long getMaximumUploadSize() {
        return this.m_maximumUploadSize;
    }

    @Override
    public List<BinaryResource> startChooser() {
        this.m_files = null;
        this.m_blockingCondition.setBlocking(true);
        IDesktop desktop = ClientSessionProvider.currentSession().getDesktop();
        desktop.showFileChooser(this);
        try {
            this.waitFor();
        }
        finally {
            desktop.hideFileChooser(this);
            this.fireClosed();
        }
        return this.getFiles();
    }

    private void waitFor() {
        this.m_blockingCondition.waitFor(new String[]{"ui.interaction.required"});
    }

    @Override
    public void setFiles(List<BinaryResource> result) {
        this.m_files = CollectionUtility.arrayListWithoutNullElements(result);
        this.m_blockingCondition.setBlocking(false);
    }

    @Override
    public void doClose() {
        this.setFiles(null);
    }

    @Override
    public List<BinaryResource> getFiles() {
        return CollectionUtility.arrayList(this.m_files);
    }

    protected void fireClosed() {
        this.fireFileChooserEvent(new FileChooserEvent(this, 900));
    }

    protected void fireFileChooserEvent(FileChooserEvent e) {
        this.fileChooserListeners().list().forEach(listener -> listener.fileChooserChanged(e));
    }

    protected class P_UIFacade
    implements IFileChooserUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void setResultFromUI(List<BinaryResource> files) {
            FileChooser.this.setFiles(files);
        }
    }
}

