/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;

public abstract class AbstractTableRowBuilder<T> {
    public ITableRow createTableRow(ILookupRow<T> dataRow) {
        ITableRow tableRow = this.createEmptyTableRow();
        tableRow.setEnabled(dataRow.isEnabled());
        Cell cell = tableRow.getCellForUpdate(1);
        if (dataRow.getTooltipText() != null) {
            cell.setTooltipText(dataRow.getTooltipText());
        }
        if (dataRow.getIconId() != null) {
            cell.setIconId(dataRow.getIconId());
        }
        if (dataRow.getBackgroundColor() != null) {
            cell.setBackgroundColor(dataRow.getBackgroundColor());
        }
        if (dataRow.getForegroundColor() != null) {
            cell.setForegroundColor(dataRow.getForegroundColor());
        }
        if (dataRow.getFont() != null) {
            cell.setFont(dataRow.getFont());
        }
        tableRow.setStatusNonchanged();
        return tableRow;
    }

    public ITableRow createRow() {
        return this.createEmptyTableRow();
    }

    public ITableRow createRow(Object rowValues) {
        if (!rowValues.getClass().isArray()) {
            throw new IllegalArgumentException("argument must be an array value []");
        }
        ITableRow row = this.createEmptyTableRow();
        int c = 0;
        int nc = Array.getLength(rowValues);
        while (c < nc) {
            row.setCellValue(c, Array.get(rowValues, c));
            ++c;
        }
        return row;
    }

    public List<ITableRow> createRowsByArray(Object dataArray) {
        return this.createRowsByArray(dataArray, 1);
    }

    public List<ITableRow> createRowsByArray(Object dataArray, int rowStatus) {
        if (dataArray == null) {
            dataArray = new Object[]{};
        }
        if (dataArray instanceof Collection) {
            dataArray = ((Collection)dataArray).toArray();
        }
        if (!dataArray.getClass().isArray()) {
            throw new IllegalArgumentException("argument must be a matrix value [][]");
        }
        int rowCount = Array.getLength(dataArray);
        ArrayList<ITableRow> rows = new ArrayList<ITableRow>(rowCount);
        int r = 0;
        while (r < rowCount) {
            rows.add(this.createRow(new Object[]{Array.get(dataArray, r)}));
            ++r;
        }
        return rows;
    }

    public List<ITableRow> createRowsByMatrix(Object dataMatrixOrReference) {
        return this.createRowsByMatrix(dataMatrixOrReference, 1);
    }

    public List<ITableRow> createRowsByMatrix(Object dataMatrixOrReference, int rowStatus) {
        Object[][] dataMatrix;
        boolean isRef;
        if (dataMatrixOrReference instanceof AtomicReference) {
            isRef = true;
            dataMatrix = ((AtomicReference)dataMatrixOrReference).get();
        } else {
            isRef = false;
            dataMatrix = dataMatrixOrReference;
        }
        if (dataMatrix == null) {
            dataMatrix = new Object[0][0];
        }
        if (!dataMatrix.getClass().isArray()) {
            throw new IllegalArgumentException("argument must be a matrix value [][]");
        }
        int rowCount = Array.getLength(dataMatrix);
        ArrayList<ITableRow> rows = new ArrayList<ITableRow>(rowCount);
        if (isRef) {
            Object[] refData = new Object[rowCount];
            int r = 0;
            while (r < rowCount) {
                refData[r] = Array.get(dataMatrix, r);
                ++r;
            }
            dataMatrix = null;
            ((AtomicReference)dataMatrixOrReference).set(null);
            dataMatrix = null;
            r = 0;
            while (r < rowCount) {
                ITableRow row = this.createRow(refData[r]);
                row.setStatus(rowStatus);
                rows.add(row);
                refData[r] = null;
                ++r;
            }
        } else {
            int r = 0;
            while (r < rowCount) {
                ITableRow row = this.createRow(Array.get(dataMatrix, r));
                row.setStatus(rowStatus);
                rows.add(row);
                ++r;
            }
        }
        return rows;
    }

    public List<ITableRow> createRowsByCodes(Collection<? extends ICode<?>> codes) {
        ArrayList<ITableRow> result = new ArrayList<ITableRow>(codes.size());
        for (ICode<?> code : codes) {
            ITableRow row = this.createRow(new Object[]{code.getId(), code.getText()});
            row.setIconId(code.getIconId());
            row.setBackgroundColor(code.getBackgroundColor());
            row.setForegroundColor(code.getForegroundColor());
            row.setFont(code.getFont());
            row.setCssClass(code.getCssClass());
            result.add(row);
        }
        return result;
    }

    protected abstract ITableRow createEmptyTableRow();
}

