/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.client.dto.ColumnData;
import org.eclipse.scout.rt.client.ui.basic.table.ColumnSet;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRowDataMapper;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Replace;
import org.eclipse.scout.rt.platform.reflect.FastPropertyDescriptor;
import org.eclipse.scout.rt.platform.reflect.IPropertyFilter;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.BeanUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData;
import org.eclipse.scout.rt.shared.data.form.fields.tablefield.TableRowDataPropertyFilter;
import org.eclipse.scout.rt.shared.extension.IInternalExtensionRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRowDataMapper
implements ITableRowDataMapper {
    private static final Logger LOG = LoggerFactory.getLogger(TableRowDataMapper.class);
    private final Map<IColumn, FastPropertyDescriptor> m_propertyDescriptorByColumn;
    private final ColumnSet m_columnSet;
    private final Set<IColumn<?>> m_ignoredColumns;

    public TableRowDataMapper(Class<? extends AbstractTableRowData> rowType, ColumnSet columnSet) {
        Assertions.assertNotNull(rowType);
        Assertions.assertNotNull((Object)columnSet);
        this.m_columnSet = columnSet;
        IPropertyFilter filter = this.createPropertyFilter();
        LinkedList props = new LinkedList();
        Collections.addAll(props, BeanUtility.getFastPropertyDescriptors(rowType, AbstractTableRowData.class, (IPropertyFilter)filter));
        Set contributions = ((IInternalExtensionRegistry)BEANS.get(IInternalExtensionRegistry.class)).getContributionsFor(rowType);
        for (Class contribution : contributions) {
            Collections.addAll(props, BeanUtility.getFastPropertyDescriptors((Class)contribution, Object.class, (IPropertyFilter)filter));
        }
        this.m_propertyDescriptorByColumn = new HashMap<IColumn, FastPropertyDescriptor>(props.size());
        for (FastPropertyDescriptor rowDataPropertyDesc : props) {
            IColumn column = this.findColumn(columnSet, rowDataPropertyDesc);
            if (column != null) {
                this.m_propertyDescriptorByColumn.put(column, rowDataPropertyDesc);
                continue;
            }
            LOG.debug("No column found for property [{}#{}]", (Object)rowDataPropertyDesc.getBeanClass().getName(), (Object)rowDataPropertyDesc.getName());
        }
        HashSet ignoredColumns = null;
        for (IColumn<?> col : columnSet.getColumns()) {
            if (!this.isColumnIgnored(col)) continue;
            if (ignoredColumns == null) {
                ignoredColumns = new HashSet();
            }
            ignoredColumns.add(col);
        }
        this.m_ignoredColumns = ignoredColumns != null ? ignoredColumns : CollectionUtility.hashSet((Object[])new IColumn[0]);
    }

    protected IPropertyFilter createPropertyFilter() {
        return new TableRowDataPropertyFilter();
    }

    protected IColumn findColumn(ColumnSet columnset, FastPropertyDescriptor rowDataPropertyDesc) {
        String columnId = this.capitalize(rowDataPropertyDesc.getName());
        return columnset.getColumnById(columnId);
    }

    protected boolean isColumnIgnored(IColumn<?> column) {
        Class<?> c = column.getClass();
        ColumnData a = null;
        while (((a = c.getAnnotation(ColumnData.class)) == null || a.value() == ColumnData.SdkColumnCommand.IGNORE) && c.isAnnotationPresent(Replace.class)) {
            c = c.getSuperclass();
        }
        return a != null && a.value() == ColumnData.SdkColumnCommand.IGNORE;
    }

    private String capitalize(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    @Override
    public void importTableRowData(ITableRow row, AbstractTableRowData rowData) {
        for (IColumn<?> column : this.m_columnSet.getColumns()) {
            if (this.m_ignoredColumns.contains(column)) continue;
            Object value = this.getValue(column, rowData);
            column.importValue(row, value);
        }
        row.setStatus(rowData.getRowState());
        this.importCustomValues(row, rowData);
    }

    public void importCustomValues(ITableRow row, AbstractTableRowData rowData) {
        if (rowData.getCustomValues() == null) {
            return;
        }
        HashMap customValuesCopy = new HashMap(rowData.getCustomValues());
        for (IColumn<?> iColumn : this.m_columnSet.getColumns()) {
            customValuesCopy.remove(iColumn.getColumnId());
        }
        for (Map.Entry entry : customValuesCopy.entrySet()) {
            row.setCustomValue((String)entry.getKey(), entry.getValue());
        }
    }

    private Object getValue(IColumn<?> column, AbstractTableRowData rowData) {
        Object value = null;
        FastPropertyDescriptor propertyDesc = this.m_propertyDescriptorByColumn.get(column);
        if (propertyDesc != null) {
            try {
                Method columnReadMethod = propertyDesc.getReadMethod();
                Object dto = this.getDataContainer(rowData, columnReadMethod.getDeclaringClass());
                value = columnReadMethod.invoke(dto, new Object[0]);
            }
            catch (Exception e) {
                LOG.warn("Error reading row data property for column [{}]", (Object)column.getClass().getName(), (Object)e);
            }
        } else {
            value = rowData.getCustomValue(column.getColumnId());
        }
        return value;
    }

    @Override
    public void exportTableRowData(ITableRow row, AbstractTableRowData rowData) {
        for (IColumn<?> column : this.m_columnSet.getColumns()) {
            if (this.m_ignoredColumns.contains(column)) continue;
            Object value = column.getValue(row);
            FastPropertyDescriptor propertyDesc = this.m_propertyDescriptorByColumn.get(column);
            if (propertyDesc != null) {
                try {
                    Method columnWriteMethod = propertyDesc.getWriteMethod();
                    Object dto = this.getDataContainer(rowData, columnWriteMethod.getDeclaringClass());
                    columnWriteMethod.invoke(dto, value);
                }
                catch (Exception t) {
                    LOG.warn("Error writing row data property for column [{}]", (Object)column.getClass().getName(), (Object)t);
                }
                continue;
            }
            rowData.setCustomValue(column.getColumnId(), value);
        }
        rowData.setRowState(row.getStatus());
        this.exportCustomValues(row, rowData);
    }

    public void exportCustomValues(ITableRow row, AbstractTableRowData rowData) {
        Set<Map.Entry<String, Object>> entries = row.getCustomValues().entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            rowData.setCustomValue(entry.getKey(), entry.getValue());
        }
    }

    protected Object getDataContainer(AbstractTableRowData rowData, Class<?> dataOwnerClass) {
        if (dataOwnerClass.isAssignableFrom(rowData.getClass())) {
            return rowData;
        }
        return rowData.getContribution(dataOwnerClass);
    }

    @Override
    public boolean acceptExport(ITableRow row) {
        return true;
    }

    @Override
    public boolean acceptImport(AbstractTableRowData rowData) {
        return true;
    }
}

