/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRowTileMapping;
import org.eclipse.scout.rt.client.ui.basic.table.ITableTileGridMediator;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.tile.TileGridLayoutConfig;
import org.eclipse.scout.rt.platform.reflect.AbstractPropertyObserver;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public class TableTileGridMediator
extends AbstractPropertyObserver
implements ITableTileGridMediator,
TableListener {
    protected ITable m_table;

    public TableTileGridMediator(ITable table) {
        this(table, true);
    }

    public TableTileGridMediator(ITable table, boolean callInitializer) {
        this.m_table = table;
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected final void callInitializer() {
        this.initConfig();
    }

    protected void initConfig() {
        this.m_table.addPropertyChangeListener("tileMode", this::onTileModeChange);
        this.m_table.addTableListener(this, new Integer[0]);
        this.setExclusiveExpand(this.getConfiguredExclusiveExpand());
        this.setGridColumnCount(this.getConfiguredGridColumnCount());
        this.setWithPlaceholders(this.getConfiguredWithPlaceholders());
        this.setTileGridLayoutConfig(this.getConfiguredLayoutConfig());
    }

    protected boolean getConfiguredExclusiveExpand() {
        return false;
    }

    protected int getConfiguredGridColumnCount() {
        return 6;
    }

    protected boolean getConfiguredWithPlaceholders() {
        return false;
    }

    protected TileGridLayoutConfig getConfiguredLayoutConfig() {
        return new TileGridLayoutConfig();
    }

    @Override
    public void tableChanged(TableEvent e) {
        if (this.m_table.isTileMode()) {
            ArrayList tileMappings = CollectionUtility.arrayList(this.getTileMappings());
            switch (e.getType()) {
                case 1: {
                    this.setTileMappings(new ArrayList<ITableRowTileMapping>());
                    this.setTileMappings(tileMappings);
                    break;
                }
                case 100: {
                    tileMappings.addAll(this.m_table.createTiles(this.filterTopLevelTableRows(e.getRows())));
                    this.setTileMappings(tileMappings);
                    break;
                }
                case 102: {
                    Predicate<ITableRowTileMapping> p = m -> e.getRows().contains(m.getTableRow());
                    tileMappings.stream().filter(p).forEach(m -> m.getTile().dispose());
                    tileMappings.removeIf(p);
                    this.setTileMappings(tileMappings);
                    break;
                }
                case 105: {
                    tileMappings.forEach(tm -> tm.getTile().dispose());
                    this.setTileMappings(new ArrayList<ITableRowTileMapping>());
                }
            }
        }
    }

    public void onTileModeChange(PropertyChangeEvent evt) {
        if (this.m_table.isTileMode()) {
            this.loadTiles(this.m_table.getRows());
        }
        ClientUIPreferences.getInstance().setTableTileMode(this.m_table, this.m_table.isTileMode());
    }

    protected void loadTiles(List<ITableRow> rows) {
        this.setTileMappings(this.m_table.createTiles(this.filterTopLevelTableRows(rows)));
    }

    protected List<ITableRow> filterTopLevelTableRows(List<ITableRow> rows) {
        return rows.stream().filter(r -> r.getParentRow() == null).collect(Collectors.toList());
    }

    @Override
    public List<ITableRowTileMapping> getTileMappings() {
        return (List)this.propertySupport.getProperty("tileMappings");
    }

    @Override
    public void setTileMappings(List<ITableRowTileMapping> tiles) {
        this.propertySupport.setProperty("tileMappings", tiles);
    }

    @Override
    public boolean isExclusiveExpand() {
        return this.propertySupport.getPropertyBool("exclusiveExpand");
    }

    @Override
    public void setExclusiveExpand(boolean exclusiveExpand) {
        this.propertySupport.setPropertyBool("exclusiveExpand", exclusiveExpand);
    }

    @Override
    public void setGridColumnCount(int gridColumnCount) {
        this.propertySupport.setPropertyInt("gridColumnCount", gridColumnCount);
    }

    @Override
    public int getGridColumnCount() {
        return this.propertySupport.getPropertyInt("gridColumnCount");
    }

    @Override
    public void setWithPlaceholders(boolean withPlaceholders) {
        this.propertySupport.setPropertyBool("withPlaceholders", withPlaceholders);
    }

    @Override
    public boolean isWithPlaceholders() {
        return this.propertySupport.getPropertyBool("withPlaceholders");
    }

    @Override
    public void setTileGridLayoutConfig(TileGridLayoutConfig layoutConfig) {
        this.propertySupport.setProperty("tileGridLayoutConfig", (Object)layoutConfig);
    }

    @Override
    public TileGridLayoutConfig getTileGridLayoutConfig() {
        return (TileGridLayoutConfig)this.propertySupport.getProperty("tileGridLayoutConfig");
    }
}

