/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.ColumnChains;
import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.IColumnExtension;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.ColumnSet;
import org.eclipse.scout.rt.client.ui.basic.table.HeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.IHeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRowCustomValueContributor;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.userfilter.TableUserFilterManager;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.ParsingFailedStatus;
import org.eclipse.scout.rt.client.ui.form.fields.ValidationFailedStatus;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.Replace;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.holders.IHolder;
import org.eclipse.scout.rt.platform.reflect.AbstractPropertyObserver;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.status.IMultiStatus;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;
import org.eclipse.scout.rt.security.ACCESS;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.data.basic.NamedBitMaskHelper;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="ebe15e4d-017b-4ac0-9a5a-2c9e07c8ad6f")
public abstract class AbstractColumn<VALUE>
extends AbstractPropertyObserver
implements IColumn<VALUE>,
IExtensibleObject {
    private static final String DISPLAYABLE = "DISPLAYABLE";
    private static final String INITIALIZED = "INITIALIZED";
    private static final String PRIMARY_KEY = "PRIMARY_KEY";
    private static final String PARENT_KEY = "PARENT_KEY";
    private static final String SUMMARY = "SUMMARY";
    private static final String INITIALLY_VISIBLE = "INITIALLY_VISIBLE";
    private static final String INITIALLY_GROUPED = "INITIALLY_GROUPED";
    private static final String INITIALLY_SORTED_ASC = "INITIALLY_SORTED_ASC";
    private static final String INITIALLY_ALWAYS_INCLUDE_SORT_AT_BEGIN = "INITIALLY_ALWWAYS_INCLUDE_SORT_AT_BEGIN";
    private static final String INITIALLY_ALWWAYS_INCLUDE_SORT_AT_END = "INITIALLY_ALWWAYS_INCLUDE_SORT_AT_END";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractColumn.class);
    private static final NamedBitMaskHelper VISIBLE_BIT_HELPER = new NamedBitMaskHelper(new String[]{"VISIBLE", "VISIBLE_GRANTED", "DISPLAYABLE"});
    private static final NamedBitMaskHelper FLAGS_BIT_HELPER = new NamedBitMaskHelper(new String[]{"INITIALIZED", "PRIMARY_KEY", "SUMMARY", "INITIALLY_VISIBLE", "INITIALLY_GROUPED", "INITIALLY_SORTED_ASC", "INITIALLY_ALWWAYS_INCLUDE_SORT_AT_BEGIN", "INITIALLY_ALWWAYS_INCLUDE_SORT_AT_END"});
    private static final NamedBitMaskHelper FLAGS2_BIT_HELPER = new NamedBitMaskHelper(new String[]{"PARENT_KEY"});
    private ITable m_table;
    private byte m_visible;
    private byte m_flags;
    private byte m_flags2;
    private int m_initialWidth;
    private int m_initialSortIndex;
    private final ObjectExtensions<AbstractColumn<VALUE>, IColumnExtension<VALUE, ? extends AbstractColumn<VALUE>>> m_objectExtensions;
    private final HeaderCell m_headerCell = new HeaderCell();

    public AbstractColumn() {
        this(true);
    }

    public AbstractColumn(boolean callInitializer) {
        this.m_visible = (byte)-1;
        this.m_objectExtensions = new ObjectExtensions((Object)this, false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected final void callInitializer() {
        if (!this.isInitialized()) {
            this.interceptInitConfig();
            this.m_flags = FLAGS_BIT_HELPER.setBit(INITIALIZED, this.m_flags);
        }
    }

    protected boolean isInitialized() {
        return FLAGS_BIT_HELPER.isBitSet(INITIALIZED, this.m_flags);
    }

    protected Map<String, Object> getPropertiesMap() {
        return this.propertySupport.getPropertiesMap();
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=10.0)
    protected boolean getConfiguredVisible() {
        return true;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=20.0)
    protected String getConfiguredHeaderText() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=30.0)
    protected String getConfiguredHeaderTooltipText() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=35.0)
    protected boolean getConfiguredHeaderTooltipHtmlEnabled() {
        return false;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=40.0)
    protected String getConfiguredHeaderIconId() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=110.0)
    protected String getConfiguredHeaderCssClass() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=110.0)
    protected boolean getConfiguredHeaderHtmlEnabled() {
        return false;
    }

    @ConfigProperty(value="COLOR")
    @Order(value=40.0)
    protected String getConfiguredHeaderForegroundColor() {
        return null;
    }

    @ConfigProperty(value="COLOR")
    @Order(value=50.0)
    protected String getConfiguredHeaderBackgroundColor() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=60.0)
    protected String getConfiguredHeaderFont() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=70.0)
    protected int getConfiguredWidth() {
        return 60;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=72.0)
    protected int getConfiguredMinWidth() {
        return 60;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=75.0)
    protected boolean getConfiguredFixedWidth() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=78.0)
    protected boolean getConfiguredFixedPosition() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=80.0)
    protected boolean getConfiguredDisplayable() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=90.0)
    protected boolean getConfiguredPrimaryKey() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=91.0)
    protected boolean getConfiguredParentKey() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=95.0)
    protected boolean getConfiguredEditable() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    protected boolean getConfiguredSummary() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=105.0)
    protected String getConfiguredCssClass() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=105.0)
    protected boolean getConfiguredHtmlEnabled() {
        return false;
    }

    @ConfigProperty(value="COLOR")
    @Order(value=110.0)
    protected String getConfiguredForegroundColor() {
        return null;
    }

    @ConfigProperty(value="COLOR")
    @Order(value=120.0)
    protected String getConfiguredBackgroundColor() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=130.0)
    protected String getConfiguredFont() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=135.0)
    protected boolean getConfiguredGrouped() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=140.0)
    protected int getConfiguredSortIndex() {
        return -1;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=145.0)
    protected double getConfiguredViewOrder() {
        return 9.876543212345678E16;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=150.0)
    protected boolean getConfiguredSortAscending() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=160.0)
    protected boolean getConfiguredAlwaysIncludeSortAtBegin() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=170.0)
    protected boolean getConfiguredAlwaysIncludeSortAtEnd() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=180.0)
    protected int getConfiguredHorizontalAlignment() {
        return -1;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=190.0)
    protected boolean getConfiguredAutoOptimizeWidth() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=195.0)
    protected int getConfiguredAutoOptimizeMaxWidth() {
        return -1;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=210.0)
    protected boolean getConfiguredMandatory() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=220.0)
    protected boolean getConfiguredUiSortPossible() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=230.0)
    protected boolean getConfiguredNodeColumnCandidate() {
        return true;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitColumn() {
    }

    @ConfigOperation
    @Order(value=15.0)
    protected void execDisposeColumn() {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected VALUE execParseValue(ITableRow row, Object rawValue) {
        return this.parseValueInternal(row, rawValue);
    }

    @ConfigOperation
    @Order(value=30.0)
    protected VALUE execValidateValue(ITableRow row, VALUE rawValue) {
        return rawValue;
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execDecorateCell(Cell cell, ITableRow row) {
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execDecorateHeaderCell(HeaderCell cell) {
    }

    @ConfigOperation
    @Order(value=61.0)
    protected IFormField execPrepareEdit(ITableRow row) {
        IFormField f = this.prepareEditInternal(row);
        if (f != null) {
            f.setLabelVisible(false);
            f.setFieldStyle("classic");
            this.cellValueToEditor(row, f);
            f.markSaved();
        }
        return f;
    }

    @ConfigOperation
    @Order(value=62.0)
    protected void execCompleteEdit(ITableRow row, IFormField editingField) {
        this.editorValueToCell(row, editingField);
    }

    protected void editorValueToCell(ITableRow row, IFormField editorField) {
        if (!(editorField instanceof IValueField)) {
            throw new ProcessingException("Expected a value field.", new Object[0]);
        }
        IValueField valueField = (IValueField)editorField;
        LOG.debug("complete edit: [value={}, text={}, status={}]", new Object[]{valueField.getValue(), valueField.getDisplayText(), valueField.getErrorStatus()});
        String cellAction = "";
        Cell cell = row.getCellForUpdate(this);
        if (!this.contentEquals(cell, valueField)) {
            cell.removeErrorStatus(ValidationFailedStatus.class);
            cell.removeErrorStatus(ParsingFailedStatus.class);
            if (valueField.getErrorStatus() == null) {
                this.parseValueAndSet(row, valueField.getValue(), true);
                cellAction = "parseAndSetValue";
            } else {
                cell.setText(valueField.getDisplayText());
                cell.addErrorStatuses(valueField.getErrorStatus().getChildren());
                cellAction = "setText/addErrorStatuses";
            }
        }
        LOG.debug("cell updated: [value={}, text={}, status={}, cellAction={}]", new Object[]{cell.getValue(), cell.getText(), cell.getErrorStatus(), cellAction});
    }

    protected void cellValueToEditor(ITableRow row, IFormField editorField) {
        ICell cell = row.getCell(this);
        IMultiStatus status = cell.getErrorStatus();
        if (status == null || status.isOK()) {
            this.cellValueToEditField(cell.getValue(), editorField);
        } else {
            this.cellTextToEditField(cell.getText(), editorField);
        }
    }

    protected void cellValueToEditField(VALUE cellValue, IFormField editorField) {
        if (!(editorField instanceof IValueField)) {
            throw new ProcessingException("Expected a value field.", new Object[0]);
        }
        IValueField field = (IValueField)editorField;
        field.setValue(cellValue);
    }

    protected void cellTextToEditField(String cellText, IFormField editorField) {
        if (!(editorField instanceof IValueField)) {
            throw new ProcessingException("Expected a value field.", new Object[0]);
        }
        IValueField field = (IValueField)editorField;
        field.parseAndSetValue(cellText);
    }

    protected VALUE editFieldToCellValue(IFormField editField) {
        if (!(editField instanceof IValueField)) {
            throw new ProcessingException("Expected a value field.", new Object[0]);
        }
        return (VALUE)((IHolder)editField).getValue();
    }

    private boolean contentEquals(Cell cell, IValueField<VALUE> field) {
        return ObjectUtility.equals((Object)cell.getText(), (Object)field.getDisplayText()) && ObjectUtility.equals((Object)cell.getValue(), this.editFieldToCellValue(field)) && ObjectUtility.equals((Object)cell.getErrorStatus(), (Object)field.getErrorStatus());
    }

    protected void applyValueInternal(ITableRow row, VALUE newValue) {
        if (!this.getTable().isSortEnabled()) {
            this.setValue(row, newValue);
        } else {
            try {
                this.getTable().setSortEnabled(false);
                this.setValue(row, newValue);
            }
            finally {
                this.getTable().setSortEnabled(true);
            }
        }
    }

    public final List<? extends IColumnExtension<VALUE, ? extends AbstractColumn<VALUE>>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    protected IColumnExtension<VALUE, ? extends AbstractColumn<VALUE>> createLocalExtension() {
        return new LocalColumnExtension(this);
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), this::initConfig);
    }

    protected void initConfig() {
        this.setAutoOptimizeWidth(this.getConfiguredAutoOptimizeWidth());
        this.m_headerCell.setText(this.getConfiguredHeaderText());
        if (this.getConfiguredHeaderTooltipText() != null) {
            this.m_headerCell.setTooltipText(this.getConfiguredHeaderTooltipText());
        }
        this.m_headerCell.setTooltipHtmlEnabled(this.getConfiguredHeaderTooltipHtmlEnabled());
        this.m_headerCell.setIconId(this.getConfiguredHeaderIconId());
        this.m_headerCell.setCssClass(this.getConfiguredHeaderCssClass());
        this.m_headerCell.setHtmlEnabled(this.getConfiguredHeaderHtmlEnabled());
        if (this.getConfiguredHeaderForegroundColor() != null) {
            this.m_headerCell.setForegroundColor(this.getConfiguredHeaderForegroundColor());
        }
        if (this.getConfiguredHeaderBackgroundColor() != null) {
            this.m_headerCell.setBackgroundColor(this.getConfiguredHeaderBackgroundColor());
        }
        if (this.getConfiguredHeaderFont() != null) {
            this.m_headerCell.setFont(FontSpec.parse((String)this.getConfiguredHeaderFont()));
        }
        this.m_headerCell.setHorizontalAlignment(this.getConfiguredHorizontalAlignment());
        this.setHorizontalAlignment(this.getConfiguredHorizontalAlignment());
        this.setDisplayable(this.getConfiguredDisplayable());
        this.setVisible(this.getConfiguredVisible());
        this.setInitialWidth(this.getConfiguredWidth());
        this.setInitialVisible(this.getConfiguredVisible());
        this.setInitialSortIndex(this.getConfiguredSortIndex());
        this.setInitialSortAscending(this.getConfiguredSortAscending());
        this.setInitialAlwaysIncludeSortAtBegin(this.getConfiguredAlwaysIncludeSortAtBegin());
        this.setInitialAlwaysIncludeSortAtEnd(this.getConfiguredAlwaysIncludeSortAtEnd());
        this.setInitialGrouped(this.getConfiguredGrouped());
        this.setOrder(this.calculateViewOrder());
        this.setWidth(this.getConfiguredWidth());
        this.setMinWidth(this.getConfiguredMinWidth());
        this.setAutoOptimizeMaxWidth(this.getConfiguredAutoOptimizeMaxWidth());
        this.setFixedWidth(this.getConfiguredFixedWidth());
        this.setFixedPosition(this.getConfiguredFixedPosition());
        this.m_flags = FLAGS_BIT_HELPER.changeBit(PRIMARY_KEY, this.getConfiguredPrimaryKey(), this.m_flags);
        this.m_flags2 = FLAGS2_BIT_HELPER.changeBit(PARENT_KEY, this.getConfiguredParentKey(), this.m_flags);
        this.m_flags = FLAGS_BIT_HELPER.changeBit(SUMMARY, this.getConfiguredSummary(), this.m_flags);
        this.setEditable(this.getConfiguredEditable());
        this.setMandatory(this.getConfiguredMandatory());
        this.setVisibleColumnIndexHint(-1);
        this.setCssClass(this.getConfiguredCssClass());
        if (this.getConfiguredForegroundColor() != null) {
            this.setForegroundColor(this.getConfiguredForegroundColor());
        }
        if (this.getConfiguredBackgroundColor() != null) {
            this.setBackgroundColor(this.getConfiguredBackgroundColor());
        }
        if (this.getConfiguredFont() != null) {
            this.setFont(FontSpec.parse((String)this.getConfiguredFont()));
        }
        this.setHtmlEnabled(this.getConfiguredHtmlEnabled());
        this.setUiSortPossible(this.getConfiguredUiSortPossible());
        this.setNodeColumnCandidate(this.getConfiguredNodeColumnCandidate());
    }

    protected double calculateViewOrder() {
        double viewOrder = this.getConfiguredViewOrder();
        Class<?> cls = this.getClass();
        if (viewOrder == 9.876543212345678E16) {
            while (cls != null && IColumn.class.isAssignableFrom(cls)) {
                if (cls.isAnnotationPresent(Order.class)) {
                    Order order = cls.getAnnotation(Order.class);
                    return order.value();
                }
                cls = cls.getSuperclass();
            }
        }
        return viewOrder;
    }

    @Override
    public void initColumn() {
        if (this.getTable() != null && this.getTable().isHeaderEnabled()) {
            ClientUIPreferences env = ClientUIPreferences.getInstance();
            this.setVisible(env.getTableColumnVisible(this, this.isVisible("VISIBLE")));
            if (!this.isFixedWidth()) {
                this.setWidth(env.getTableColumnWidth(this, this.getWidth()));
            }
            this.setVisibleColumnIndexHint(env.getTableColumnViewIndex(this, this.getVisibleColumnIndexHint()));
        }
        this.interceptInitColumn();
    }

    @Override
    public void disposeColumn() {
        this.interceptDisposeColumn();
    }

    @Override
    public void initCell(ITableRow row) {
        Cell cell = row.getCellForUpdate(this);
        if (this.getForegroundColor() != null) {
            cell.setForegroundColor(this.getForegroundColor());
        }
        if (this.getBackgroundColor() != null) {
            cell.setBackgroundColor(this.getBackgroundColor());
        }
        if (this.getFont() != null) {
            cell.setFont(this.getFont());
        }
        if (this.getCssClass() != null) {
            cell.setCssClass(this.getCssClass());
        }
        cell.setHorizontalAlignment(this.getHorizontalAlignment());
        cell.setEditable(this.isEditable());
        cell.setHtmlEnabled(this.isHtmlEnabled());
        cell.setMandatory(this.isMandatory());
    }

    protected void reinitCells() {
        if (this.getTable() == null) {
            return;
        }
        for (ITableRow row : this.getTable().getRows()) {
            this.initCell(row);
        }
    }

    @Override
    public void setMandatory(boolean mandatory) {
        boolean changed = this.propertySupport.setPropertyBool("mandatory", mandatory);
        if (changed && this.isInitialized()) {
            this.reinitCells();
        }
    }

    @Override
    public boolean isMandatory() {
        return this.propertySupport.getPropertyBool("mandatory");
    }

    @Override
    public boolean isUiSortPossible() {
        return this.propertySupport.getPropertyBool("uiSortPossible");
    }

    @Override
    public void setUiSortPossible(boolean uiSortPossible) {
        this.propertySupport.setPropertyBool("uiSortPossible", uiSortPossible);
    }

    @Override
    public boolean isInitialVisible() {
        return FLAGS_BIT_HELPER.isBitSet(INITIALLY_VISIBLE, this.m_flags);
    }

    @Override
    public void setInitialVisible(boolean b) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(INITIALLY_VISIBLE, b, this.m_flags);
    }

    @Override
    public boolean isInitialGrouped() {
        return FLAGS_BIT_HELPER.isBitSet(INITIALLY_GROUPED, this.m_flags);
    }

    @Override
    public void setInitialGrouped(boolean b) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(INITIALLY_GROUPED, b, this.m_flags);
    }

    @Override
    public int getInitialSortIndex() {
        return this.m_initialSortIndex;
    }

    @Override
    public void setInitialSortIndex(int i) {
        this.m_initialSortIndex = i;
    }

    @Override
    public boolean isInitialSortAscending() {
        return FLAGS_BIT_HELPER.isBitSet(INITIALLY_SORTED_ASC, this.m_flags);
    }

    @Override
    public void setInitialSortAscending(boolean b) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(INITIALLY_SORTED_ASC, b, this.m_flags);
    }

    @Override
    public boolean isInitialAlwaysIncludeSortAtBegin() {
        return FLAGS_BIT_HELPER.isBitSet(INITIALLY_ALWAYS_INCLUDE_SORT_AT_BEGIN, this.m_flags);
    }

    @Override
    public void setInitialAlwaysIncludeSortAtBegin(boolean b) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(INITIALLY_ALWAYS_INCLUDE_SORT_AT_BEGIN, b, this.m_flags);
    }

    @Override
    public boolean isInitialAlwaysIncludeSortAtEnd() {
        return FLAGS_BIT_HELPER.isBitSet(INITIALLY_ALWWAYS_INCLUDE_SORT_AT_END, this.m_flags);
    }

    @Override
    public void setInitialAlwaysIncludeSortAtEnd(boolean b) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(INITIALLY_ALWWAYS_INCLUDE_SORT_AT_END, b, this.m_flags);
    }

    @Override
    public void setVisiblePermission(Permission p) {
        boolean b = true;
        if (p != null) {
            b = ACCESS.check((Permission)p);
        }
        this.setVisibleGranted(b);
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    public void setTableInternal(ITable table) {
        this.m_table = table;
    }

    @Override
    public int getColumnIndex() {
        return this.m_headerCell.getColumnIndex();
    }

    @Override
    public String getColumnId() {
        Class<?> c = this.getClass();
        while (c.isAnnotationPresent(Replace.class)) {
            c = c.getSuperclass();
        }
        String s = c.getSimpleName();
        if (s.endsWith("Column")) {
            s = s.replaceAll("Column$", "");
        }
        return s;
    }

    public String classId() {
        String simpleClassId = ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass(), (boolean)false);
        if (this.getTable() != null) {
            return String.valueOf(simpleClassId) + "_" + this.getTable().classId();
        }
        return simpleClassId;
    }

    @Override
    public VALUE getValue(ITableRow r) {
        return this.getValueInternal(r);
    }

    protected VALUE getValueInternal(ITableRow r) {
        return (VALUE)(r != null ? r.getCellValue(this.getColumnIndex()) : null);
    }

    @Override
    public VALUE getValue(int rowIndex) {
        return this.getValue(this.getTable().getRow(rowIndex));
    }

    @Override
    public void setValue(int rowIndex, VALUE rawValue) {
        this.setValue(this.getTable().getRow(rowIndex), rawValue);
    }

    @Override
    public void setValue(ITableRow r, VALUE value) {
        this.setValue(r, value, false);
    }

    protected void setValue(ITableRow r, VALUE value, boolean updateValidDisplayText) {
        try {
            Cell cell = r.getCellForUpdate(this);
            cell.removeErrorStatus(ValidationFailedStatus.class);
            VALUE newValue = this.validateValue(r, value);
            if (!cell.hasError()) {
                r.setCellValue(this.getColumnIndex(), newValue);
                if (this instanceof ITableRowCustomValueContributor) {
                    ((ITableRowCustomValueContributor)((Object)this)).enrichCustomValues(r, r.getCustomValues());
                }
            }
            this.ensureVisibileIfInvalid(r);
            if (updateValidDisplayText) {
                this.updateDisplayText(r, newValue);
            }
        }
        catch (ProcessingException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error setting column value ", (Throwable)e);
            }
            Cell cell = r.getCellForUpdate(this);
            cell.addErrorStatus(new ValidationFailedStatus<VALUE>(e, value));
            this.updateDisplayText(r, value);
        }
    }

    @Override
    public void fill(VALUE rawValue) {
        for (ITableRow row : this.getTable().getRows()) {
            this.setValue(row, rawValue);
        }
    }

    @Override
    public Class<VALUE> getDataType() {
        return TypeCastUtility.getGenericsParameterClass(this.getClass(), IColumn.class);
    }

    @Override
    public List<VALUE> getValues() {
        int rowCount = this.m_table.getRowCount();
        ArrayList<VALUE> values = new ArrayList<VALUE>(rowCount);
        int i = 0;
        while (i < rowCount) {
            values.add(this.getValue(this.m_table.getRow(i)));
            ++i;
        }
        return values;
    }

    @Override
    public List<VALUE> getValues(boolean includeDeleted) {
        ArrayList<VALUE> values = new ArrayList<VALUE>();
        for (ITableRow row : this.m_table.getRows()) {
            if (!includeDeleted && row.getStatus() == 3) continue;
            values.add(this.getValue(row));
        }
        return values;
    }

    @Override
    public List<VALUE> getValues(Collection<? extends ITableRow> rows) {
        ArrayList<VALUE> values = new ArrayList<VALUE>(rows.size());
        for (ITableRow iTableRow : rows) {
            values.add(this.getValue(iTableRow));
        }
        return values;
    }

    @Override
    public List<VALUE> getSelectedValues() {
        List<ITableRow> selectedRows = this.m_table.getSelectedRows();
        ArrayList<VALUE> values = new ArrayList<VALUE>(selectedRows.size());
        for (ITableRow row : selectedRows) {
            values.add(this.getValue(row));
        }
        return values;
    }

    @Override
    public VALUE getSelectedValue() {
        ITableRow row = this.m_table.getSelectedRow();
        if (row != null) {
            return this.getValue(row);
        }
        return null;
    }

    @Override
    public String getDisplayText(ITableRow r) {
        return r.getCell(this.getColumnIndex()).getText();
    }

    @Override
    public List<String> getDisplayTexts() {
        ArrayList<String> values = new ArrayList<String>(this.m_table.getRowCount());
        int i = 0;
        while (i < this.m_table.getRowCount()) {
            values.add(this.getDisplayText(this.m_table.getRow(i)));
            ++i;
        }
        return values;
    }

    @Override
    public String getSelectedDisplayText() {
        ITableRow row = this.m_table.getSelectedRow();
        if (row != null) {
            return this.getDisplayText(row);
        }
        return null;
    }

    @Override
    public List<String> getSelectedDisplayTexts() {
        List<ITableRow> selectedRows = this.m_table.getSelectedRows();
        ArrayList<String> values = new ArrayList<String>(selectedRows.size());
        for (ITableRow row : selectedRows) {
            values.add(this.getDisplayText(row));
        }
        return values;
    }

    @Override
    public List<VALUE> getInsertedValues() {
        List<ITableRow> insertedRows = this.m_table.getInsertedRows();
        ArrayList<VALUE> values = new ArrayList<VALUE>(insertedRows.size());
        for (ITableRow row : insertedRows) {
            values.add(this.getValue(row));
        }
        return values;
    }

    @Override
    public List<VALUE> getUpdatedValues() {
        List<ITableRow> updatedRows = this.m_table.getUpdatedRows();
        ArrayList<VALUE> values = new ArrayList<VALUE>(updatedRows.size());
        for (ITableRow row : updatedRows) {
            values.add(this.getValue(row));
        }
        return values;
    }

    @Override
    public List<VALUE> getDeletedValues() {
        List<ITableRow> deletedRows = this.m_table.getDeletedRows();
        ArrayList<VALUE> values = new ArrayList<VALUE>(deletedRows.size());
        for (ITableRow row : deletedRows) {
            values.add(this.getValue(row));
        }
        return values;
    }

    @Override
    public List<VALUE> getNotDeletedValues() {
        List<ITableRow> notDeletedRows = this.m_table.getNotDeletedRows();
        ArrayList<VALUE> values = new ArrayList<VALUE>(notDeletedRows.size());
        for (ITableRow row : notDeletedRows) {
            values.add(this.getValue(row));
        }
        return values;
    }

    @Override
    public List<ITableRow> findRows(Collection<? extends VALUE> values) {
        if (values != null) {
            ArrayList<ITableRow> foundRows = new ArrayList<ITableRow>();
            int i = 0;
            while (i < this.m_table.getRowCount()) {
                ITableRow row = this.m_table.getRow(i);
                if (ObjectUtility.isOneOf(this.getValue(row), values)) {
                    foundRows.add(row);
                }
                ++i;
            }
            return foundRows;
        }
        return CollectionUtility.emptyArrayList();
    }

    @Override
    public List<ITableRow> findRows(VALUE value) {
        ArrayList<ITableRow> foundRows = new ArrayList<ITableRow>();
        int i = 0;
        while (i < this.m_table.getRowCount()) {
            ITableRow row = this.m_table.getRow(i);
            if (ObjectUtility.equals(value, this.getValue(row))) {
                foundRows.add(row);
            }
            ++i;
        }
        return foundRows;
    }

    @Override
    public ITableRow findRow(VALUE value) {
        int i = 0;
        int ni = this.m_table.getRowCount();
        while (i < ni) {
            ITableRow row = this.m_table.getRow(i);
            if (ObjectUtility.equals(value, this.getValue(row))) {
                return row;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean contains(VALUE value) {
        int i = 0;
        int ni = this.m_table.getRowCount();
        while (i < ni) {
            ITableRow row = this.m_table.getRow(i);
            if (ObjectUtility.equals(value, this.getValue(row))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean containsDuplicateValues() {
        return new HashSet<VALUE>(this.getValues()).size() < this.getValues().size();
    }

    @Override
    public boolean isEmpty() {
        if (this.m_table != null) {
            int i = 0;
            int ni = this.m_table.getRowCount();
            while (i < ni) {
                VALUE value = this.getValue(this.m_table.getRow(i));
                if (value != null) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void setColumnIndexInternal(int index) {
        this.m_headerCell.setColumnIndexInternal(index);
    }

    @Override
    public boolean isSortActive() {
        return this.getHeaderCell().isSortActive();
    }

    @Override
    public boolean isSortAscending() {
        return this.getHeaderCell().isSortAscending();
    }

    @Override
    public boolean isSortPermanent() {
        return this.getHeaderCell().isSortPermanent();
    }

    @Override
    public boolean isGroupingActive() {
        return this.getHeaderCell().isGroupingActive();
    }

    @Override
    public int getSortIndex() {
        ColumnSet cs;
        ITable table = this.getTable();
        if (table != null && (cs = table.getColumnSet()) != null) {
            return cs.getSortColumnIndex(this);
        }
        return -1;
    }

    @Override
    public boolean isColumnFilterActive() {
        TableUserFilterManager m;
        ITable table = this.getTable();
        if (table != null && (m = table.getUserFilterManager()) != null) {
            return m.getFilter(this.getColumnId()) != null;
        }
        return false;
    }

    @Override
    public int compareTableRows(ITableRow r1, ITableRow r2) {
        VALUE o1 = this.getValue(r1);
        VALUE o2 = this.getValue(r2);
        int c = o1 == null && o2 == null ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : (o1 instanceof Comparable && o2 instanceof Comparable ? ((Comparable)o1).compareTo(o2) : StringUtility.compareIgnoreCase((String)o1.toString(), (String)o2.toString()))));
        return c;
    }

    public void refreshValues() {
        if (this.isInitialized() && this.getTable() != null) {
            List<ITableRow> rows = this.getTable().getRows();
            for (ITableRow row : rows) {
                this.setValue(row, this.getValue(row));
            }
            this.updateDisplayTexts();
            this.decorateCells();
        }
    }

    @Override
    public void importValue(ITableRow row, Object value) {
        row.getCellForUpdate(this).setValue(value);
    }

    public final void parseValueAndSet(ITableRow row, Object rawValue, boolean updateDisplayText) {
        try {
            this.setValue(row, this.interceptParseValue(row, rawValue), updateDisplayText);
        }
        catch (ProcessingException e) {
            row.getCellForUpdate(this).addErrorStatus(new ParsingFailedStatus(e, StringUtility.emptyIfNull((Object)rawValue)));
        }
    }

    @Override
    public final void parseValueAndSet(ITableRow row, Object rawValue) {
        try {
            this.setValue(row, this.interceptParseValue(row, rawValue));
        }
        catch (ProcessingException e) {
            row.getCellForUpdate(this).addErrorStatus(new ParsingFailedStatus(e, StringUtility.emptyIfNull((Object)rawValue)));
        }
    }

    @Override
    public final VALUE parseValue(ITableRow row, Object rawValue) {
        VALUE parsedValue = this.interceptParseValue(row, rawValue);
        return this.validateValue(row, parsedValue);
    }

    protected VALUE parseValueInternal(ITableRow row, Object rawValue) {
        return (VALUE)TypeCastUtility.castValue((Object)rawValue, this.getDataType());
    }

    @Override
    public VALUE validateValue(ITableRow row, VALUE rawValue) {
        VALUE vinternal = this.validateValueInternal(row, rawValue);
        VALUE validatedValue = this.interceptValidateValue(row, vinternal);
        return validatedValue;
    }

    protected VALUE validateValueInternal(ITableRow row, VALUE rawValue) {
        return rawValue;
    }

    @Override
    public final IFormField prepareEdit(ITableRow row) {
        ITable table = this.getTable();
        if (table == null || !this.isCellEditable(row)) {
            return null;
        }
        IFormField f = this.interceptPrepareEdit(row);
        if (f != null) {
            f.setLabelVisible(false);
            GridData gd = f.getGridDataHints();
            gd.weightY = 1.0;
            f.setGridDataHints(gd);
        }
        return f;
    }

    protected IFormField prepareEditInternal(ITableRow row) {
        IValueField<VALUE> f = this.getDefaultEditor();
        this.mapEditorFieldProperties(f);
        return f;
    }

    protected void mapEditorFieldProperties(IFormField f) {
        Assertions.assertNotNull((Object)f);
        f.setBackgroundColor(this.getBackgroundColor());
        f.setForegroundColor(this.getForegroundColor());
        f.setFont(this.getFont());
        f.setMandatory(this.isMandatory());
        this.mapGridDataToField(f);
    }

    protected void mapGridDataToField(IFormField f) {
        GridData gd = f.getGridDataHints();
        gd.horizontalAlignment = this.getHorizontalAlignment();
        f.setGridDataHints(gd);
    }

    protected final IValueField<VALUE> getDefaultEditor() {
        return this.createDefaultEditor();
    }

    protected IValueField<VALUE> createDefaultEditor() {
        return new AbstractValueField<VALUE>(){};
    }

    @Override
    public final void completeEdit(ITableRow row, IFormField editingField) {
        ITable table = this.getTable();
        if (table == null || !table.isCellEditable(row, this)) {
            return;
        }
        this.interceptCompleteEdit(row, editingField);
    }

    protected void decorateCells() {
        if (this.getTable() != null) {
            this.decorateCells(this.getTable().getRows());
        }
    }

    @Override
    public void decorateCells(List<ITableRow> rows) {
        for (ITableRow row : rows) {
            this.decorateCell(row);
        }
    }

    @Override
    public void decorateCell(ITableRow row) {
        Cell cell = row.getCellForUpdate(this.getColumnIndex());
        this.decorateCellInternal(cell, row);
        try {
            this.interceptDecorateCell(cell, row);
        }
        catch (RuntimeException e) {
            LOG.warn("Exception decorating cell", (Throwable)e);
        }
    }

    protected void decorateCellInternal(Cell cell, ITableRow row) {
    }

    protected void updateDisplayTexts() {
        if (this.getTable() != null) {
            this.updateDisplayTexts(this.getTable().getRows());
        }
    }

    @Override
    public void updateDisplayTexts(List<ITableRow> rows) {
        for (ITableRow row : (List)Assertions.assertNotNull(rows)) {
            this.updateDisplayText(row, row.getCellForUpdate(this));
        }
    }

    @Override
    public void updateDisplayText(ITableRow row, Cell cell) {
        this.updateDisplayText(row, cell, cell.getValue());
    }

    public void updateDisplayText(ITableRow row, VALUE value) {
        Cell cell = row.getCellForUpdate(this);
        this.updateDisplayText(row, cell, value);
    }

    private void updateDisplayText(ITableRow row, Cell cell, VALUE value) {
        cell.setText(this.formatValueInternal(row, value));
    }

    protected String formatValueInternal(ITableRow row, VALUE value) {
        return null;
    }

    @Override
    public void decorateHeaderCell() {
        HeaderCell cell = this.m_headerCell;
        this.decorateHeaderCellInternal(cell);
        try {
            this.interceptDecorateHeaderCell(cell);
            if (this.getTable() != null && this.getTable().getColumnSet() != null) {
                this.getTable().getColumnSet().updateColumn(this);
            }
        }
        catch (Exception e) {
            LOG.warn("Error decorating header", (Throwable)e);
        }
    }

    protected void decorateHeaderCellInternal(HeaderCell cell) {
    }

    @Override
    public IHeaderCell getHeaderCell() {
        return this.m_headerCell;
    }

    @Override
    public int getVisibleColumnIndexHint() {
        return this.propertySupport.getPropertyInt("viewColumnIndexHint");
    }

    @Override
    public void setVisibleColumnIndexHint(int index) {
        int oldIndex = this.getVisibleColumnIndexHint();
        if (oldIndex != index) {
            this.propertySupport.setPropertyInt("viewColumnIndexHint", index);
        }
    }

    @Override
    public int getInitialWidth() {
        return this.m_initialWidth;
    }

    @Override
    public void setInitialWidth(int w) {
        this.m_initialWidth = w;
    }

    public double getOrder() {
        return this.propertySupport.getPropertyDouble("order");
    }

    public void setOrder(double order) {
        this.propertySupport.setPropertyDouble("order", order);
    }

    @Override
    public int getWidth() {
        return this.propertySupport.getPropertyInt("width");
    }

    @Override
    public void setWidth(int w) {
        this.propertySupport.setPropertyInt("width", w);
    }

    @Override
    public void setWidthInternal(int w) {
        this.propertySupport.setPropertyNoFire("width", (Object)w);
    }

    @Override
    public int getMinWidth() {
        return this.propertySupport.getPropertyInt("minWidth");
    }

    @Override
    public void setMinWidth(int w) {
        this.propertySupport.setPropertyInt("minWidth", w);
    }

    @Override
    public boolean isFixedWidth() {
        return this.propertySupport.getPropertyBool("fixedWidth");
    }

    @Override
    public void setFixedWidth(boolean fixedWidth) {
        this.propertySupport.setPropertyBool("fixedWidth", fixedWidth);
    }

    @Override
    public boolean isFixedPosition() {
        return this.propertySupport.getPropertyBool("fixedPosition");
    }

    @Override
    public void setFixedPosition(boolean fixedPosition) {
        this.propertySupport.setPropertyBool("fixedPosition", fixedPosition);
    }

    @Override
    public void setHorizontalAlignment(int hAglin) {
        boolean changed = this.propertySupport.setPropertyInt("horizontalAlignment", hAglin);
        if (changed && this.isInitialized()) {
            this.reinitCells();
        }
    }

    @Override
    public int getHorizontalAlignment() {
        return this.propertySupport.getPropertyInt("horizontalAlignment");
    }

    @Override
    public boolean isDisplayable() {
        return this.isVisible(DISPLAYABLE);
    }

    @Override
    public void setDisplayable(boolean displayable) {
        boolean old = this.isDisplayable();
        if (old == displayable) {
            return;
        }
        this.setVisible(displayable, DISPLAYABLE);
        this.propertySupport.firePropertyChange("displayable", old, displayable);
    }

    @Override
    public boolean isVisibleGranted() {
        return this.isVisible("VISIBLE_GRANTED");
    }

    @Override
    public void setVisibleGranted(boolean visible) {
        this.setVisible(visible, "VISIBLE_GRANTED");
    }

    @Override
    public boolean isVisible() {
        return this.propertySupport.getPropertyBool("visible");
    }

    @Override
    public void setVisible(boolean b) {
        this.setVisible(b, "VISIBLE");
    }

    public void setVisible(boolean visible, String dimension) {
        this.m_visible = VISIBLE_BIT_HELPER.changeBit(dimension, visible, this.m_visible);
        this.calculateVisible();
    }

    public boolean isVisible(String dimension) {
        return VISIBLE_BIT_HELPER.isBitSet(dimension, this.m_visible);
    }

    private void calculateVisible() {
        this.propertySupport.setPropertyBool("visible", NamedBitMaskHelper.allBitsSet((byte)this.m_visible));
    }

    @Override
    public boolean isPrimaryKey() {
        return FLAGS_BIT_HELPER.isBitSet(PRIMARY_KEY, this.m_flags);
    }

    @Override
    public boolean isParentKey() {
        return FLAGS2_BIT_HELPER.isBitSet(PARENT_KEY, this.m_flags2);
    }

    @Override
    public boolean isSummary() {
        return FLAGS_BIT_HELPER.isBitSet(SUMMARY, this.m_flags);
    }

    @Override
    public boolean isEditable() {
        return this.propertySupport.getPropertyBool("editable");
    }

    @Override
    public void setEditable(boolean b) {
        boolean changed = this.propertySupport.setPropertyBool("editable", b);
        if (changed && this.isInitialized()) {
            this.reinitCells();
        }
    }

    @Override
    public boolean isCellEditable(ITableRow row) {
        return row.getCell(this).isEditable();
    }

    @Override
    public String getCssClass() {
        return this.propertySupport.getPropertyString("cssClass");
    }

    @Override
    public void setCssClass(String cssClass) {
        boolean changed = this.propertySupport.setPropertyString("cssClass", cssClass);
        if (changed && this.isInitialized()) {
            this.reinitCells();
        }
    }

    @Override
    public String getForegroundColor() {
        return (String)this.propertySupport.getProperty("foregroundColor");
    }

    @Override
    public void setForegroundColor(String c) {
        boolean changed = this.propertySupport.setProperty("foregroundColor", (Object)c);
        if (changed && this.isInitialized()) {
            this.reinitCells();
        }
    }

    @Override
    public String getBackgroundColor() {
        return (String)this.propertySupport.getProperty("backgroundColor");
    }

    @Override
    public void setBackgroundColor(String c) {
        boolean changed = this.propertySupport.setProperty("backgroundColor", (Object)c);
        if (changed && this.isInitialized()) {
            this.reinitCells();
        }
    }

    @Override
    public FontSpec getFont() {
        return (FontSpec)this.propertySupport.getProperty("font");
    }

    @Override
    public void setFont(FontSpec f) {
        boolean changed = this.propertySupport.setProperty("font", (Object)f);
        if (changed && this.isInitialized()) {
            this.reinitCells();
        }
    }

    @Override
    public boolean isAutoOptimizeWidth() {
        return this.propertySupport.getPropertyBool("autoOptimizeWidth");
    }

    @Override
    public void setAutoOptimizeWidth(boolean optimize) {
        this.propertySupport.setPropertyBool("autoOptimizeWidth", optimize);
    }

    @Override
    public int getAutoOptimizeMaxWidth() {
        return this.propertySupport.getPropertyInt("autoOptimizeMaxWidth");
    }

    @Override
    public void setAutoOptimizeMaxWidth(int w) {
        this.propertySupport.setPropertyInt("autoOptimizeMaxWidth", w);
    }

    @Override
    public void setHtmlEnabled(boolean enabled) {
        boolean changed = this.propertySupport.setProperty("htmlEnabled", (Object)enabled);
        if (changed && this.isInitialized()) {
            this.reinitCells();
        }
    }

    @Override
    public boolean isHtmlEnabled() {
        return (Boolean)this.propertySupport.getProperty("htmlEnabled");
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.getHeaderCell().getText() + " width=" + this.getWidth() + (this.isPrimaryKey() ? " primaryKey" : "") + (this.isSummary() ? " summary" : "") + " viewIndexHint=" + this.getVisibleColumnIndexHint() + "]";
    }

    @Override
    public void ensureVisibileIfInvalid(ITableRow row) {
        ICell cell = row.getCell(this);
        if (!cell.isContentValid() && this.isDisplayable() && !this.isVisible()) {
            this.setVisible(true);
        }
    }

    @Override
    public boolean isContentValid(ITableRow row) {
        return ((ITableRow)Assertions.assertNotNull((Object)row)).getCell(this).isContentValid();
    }

    @Override
    public boolean isRemovable() {
        return this.getTable().getTableOrganizer().isColumnRemovable(this);
    }

    @Override
    public boolean isModifiable() {
        return this.getTable().getTableOrganizer().isColumnModifiable(this);
    }

    @Override
    public boolean isNodeColumnCandidate() {
        return this.propertySupport.getPropertyBool("nodeColumnCandidate");
    }

    @Override
    public void setNodeColumnCandidate(boolean nodeColumnCandidate) {
        this.propertySupport.setPropertyBool("nodeColumnCandidate", nodeColumnCandidate);
    }

    protected final void interceptCompleteEdit(ITableRow row, IFormField editingField) {
        List<IColumnExtension<VALUE, AbstractColumn<VALUE>>> extensions = this.getAllExtensions();
        ColumnChains.ColumnCompleteEditChain<VALUE> chain = new ColumnChains.ColumnCompleteEditChain<VALUE>(extensions);
        chain.execCompleteEdit(row, editingField);
    }

    protected final void interceptInitColumn() {
        List<IColumnExtension<VALUE, AbstractColumn<VALUE>>> extensions = this.getAllExtensions();
        ColumnChains.ColumnInitColumnChain<VALUE> chain = new ColumnChains.ColumnInitColumnChain<VALUE>(extensions);
        chain.execInitColumn();
    }

    protected final VALUE interceptParseValue(ITableRow row, Object rawValue) {
        List<IColumnExtension<VALUE, AbstractColumn<VALUE>>> extensions = this.getAllExtensions();
        ColumnChains.ColumnParseValueChain<VALUE> chain = new ColumnChains.ColumnParseValueChain<VALUE>(extensions);
        return chain.execParseValue(row, rawValue);
    }

    protected final VALUE interceptValidateValue(ITableRow row, VALUE rawValue) {
        List<IColumnExtension<VALUE, AbstractColumn<VALUE>>> extensions = this.getAllExtensions();
        ColumnChains.ColumnValidateValueChain<VALUE> chain = new ColumnChains.ColumnValidateValueChain<VALUE>(extensions);
        return chain.execValidateValue(row, rawValue);
    }

    protected final IFormField interceptPrepareEdit(ITableRow row) {
        List<IColumnExtension<VALUE, AbstractColumn<VALUE>>> extensions = this.getAllExtensions();
        ColumnChains.ColumnPrepareEditChain<VALUE> chain = new ColumnChains.ColumnPrepareEditChain<VALUE>(extensions);
        return chain.execPrepareEdit(row);
    }

    protected final void interceptDecorateHeaderCell(HeaderCell cell) {
        List<IColumnExtension<VALUE, AbstractColumn<VALUE>>> extensions = this.getAllExtensions();
        ColumnChains.ColumnDecorateHeaderCellChain<VALUE> chain = new ColumnChains.ColumnDecorateHeaderCellChain<VALUE>(extensions);
        chain.execDecorateHeaderCell(cell);
    }

    protected final void interceptDecorateCell(Cell cell, ITableRow row) {
        List<IColumnExtension<VALUE, AbstractColumn<VALUE>>> extensions = this.getAllExtensions();
        ColumnChains.ColumnDecorateCellChain<VALUE> chain = new ColumnChains.ColumnDecorateCellChain<VALUE>(extensions);
        chain.execDecorateCell(cell, row);
    }

    protected final void interceptDisposeColumn() {
        List<IColumnExtension<VALUE, AbstractColumn<VALUE>>> extensions = this.getAllExtensions();
        ColumnChains.ColumnDisposeColumnChain<VALUE> chain = new ColumnChains.ColumnDisposeColumnChain<VALUE>(extensions);
        chain.execDisposeColumn();
    }

    protected static class LocalColumnExtension<VALUE, OWNER extends AbstractColumn<VALUE>>
    extends AbstractExtension<OWNER>
    implements IColumnExtension<VALUE, OWNER> {
        public LocalColumnExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execCompleteEdit(ColumnChains.ColumnCompleteEditChain<VALUE> chain, ITableRow row, IFormField editingField) {
            ((AbstractColumn)this.getOwner()).execCompleteEdit(row, editingField);
        }

        @Override
        public void execInitColumn(ColumnChains.ColumnInitColumnChain<VALUE> chain) {
            ((AbstractColumn)this.getOwner()).execInitColumn();
        }

        @Override
        public VALUE execParseValue(ColumnChains.ColumnParseValueChain<VALUE> chain, ITableRow row, Object rawValue) {
            return ((AbstractColumn)this.getOwner()).execParseValue(row, rawValue);
        }

        @Override
        public VALUE execValidateValue(ColumnChains.ColumnValidateValueChain<VALUE> chain, ITableRow row, VALUE rawValue) {
            return ((AbstractColumn)this.getOwner()).execValidateValue(row, rawValue);
        }

        @Override
        public IFormField execPrepareEdit(ColumnChains.ColumnPrepareEditChain<VALUE> chain, ITableRow row) {
            return ((AbstractColumn)this.getOwner()).execPrepareEdit(row);
        }

        @Override
        public void execDecorateHeaderCell(ColumnChains.ColumnDecorateHeaderCellChain<VALUE> chain, HeaderCell cell) {
            ((AbstractColumn)this.getOwner()).execDecorateHeaderCell(cell);
        }

        @Override
        public void execDecorateCell(ColumnChains.ColumnDecorateCellChain<VALUE> chain, Cell cell, ITableRow row) {
            ((AbstractColumn)this.getOwner()).execDecorateCell(cell, row);
        }

        @Override
        public void execDisposeColumn(ColumnChains.ColumnDisposeColumnChain<VALUE> chain) {
            ((AbstractColumn)this.getOwner()).execDisposeColumn();
        }
    }
}

