/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.IIntegerColumnExtension;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractNumberColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IIntegerColumn;
import org.eclipse.scout.rt.client.ui.form.fields.integerfield.AbstractIntegerField;
import org.eclipse.scout.rt.client.ui.form.fields.integerfield.IIntegerField;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ProcessingException;

@ClassId(value="5ac66db0-da85-454a-bec5-8cffa2d2abef")
public abstract class AbstractIntegerColumn
extends AbstractNumberColumn<Integer>
implements IIntegerColumn {
    public AbstractIntegerColumn() {
        this(true);
    }

    public AbstractIntegerColumn(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected int getConfiguredHorizontalAlignment() {
        return 1;
    }

    @Override
    @ConfigProperty(value="INTEGER")
    @Order(value=160.0)
    protected Integer getConfiguredMaxValue() {
        return null;
    }

    @Override
    @ConfigProperty(value="INTEGER")
    @Order(value=170.0)
    protected Integer getConfiguredMinValue() {
        return null;
    }

    @Override
    protected Integer parseValueInternal(ITableRow row, Object rawValue) {
        Integer validValue = null;
        if (rawValue == null) {
            validValue = null;
        } else if (rawValue instanceof Integer) {
            validValue = (Integer)rawValue;
        } else if (rawValue instanceof Number) {
            validValue = ((Number)rawValue).intValue();
        } else {
            throw new ProcessingException("invalid Integer value in column '" + this.getClass().getSimpleName() + "': " + rawValue + " class=" + rawValue.getClass(), new Object[0]);
        }
        return validValue;
    }

    protected IIntegerField createDefaultEditor() {
        return new AbstractIntegerField(){};
    }

    @Override
    protected IIntegerColumnExtension<? extends AbstractIntegerColumn> createLocalExtension() {
        return new LocalIntegerColumnExtension<AbstractIntegerColumn>(this);
    }

    protected static class LocalIntegerColumnExtension<OWNER extends AbstractIntegerColumn>
    extends AbstractNumberColumn.LocalNumberColumnExtension<Integer, OWNER>
    implements IIntegerColumnExtension<OWNER> {
        public LocalIntegerColumnExtension(OWNER owner) {
            super(owner);
        }
    }
}

