/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.ILongColumnExtension;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractNumberColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ILongColumn;
import org.eclipse.scout.rt.client.ui.form.fields.longfield.AbstractLongField;
import org.eclipse.scout.rt.client.ui.form.fields.longfield.ILongField;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ProcessingException;

@ClassId(value="97d8375f-84fa-4673-876f-9b274f218cce")
public abstract class AbstractLongColumn
extends AbstractNumberColumn<Long>
implements ILongColumn {
    public AbstractLongColumn() {
        this(true);
    }

    public AbstractLongColumn(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    @ConfigProperty(value="LONG")
    @Order(value=160.0)
    protected Long getConfiguredMaxValue() {
        return null;
    }

    @Override
    @ConfigProperty(value="LONG")
    @Order(value=170.0)
    protected Long getConfiguredMinValue() {
        return null;
    }

    @Override
    protected Long parseValueInternal(ITableRow row, Object rawValue) {
        Long validValue = null;
        if (rawValue == null) {
            validValue = null;
        } else if (rawValue instanceof Long) {
            validValue = (Long)rawValue;
        } else if (rawValue instanceof Number) {
            validValue = ((Number)rawValue).longValue();
        } else {
            throw new ProcessingException("invalid Long value in column '" + this.getClass().getSimpleName() + "': " + rawValue + " class=" + rawValue.getClass(), new Object[0]);
        }
        return validValue;
    }

    protected ILongField createDefaultEditor() {
        return new AbstractLongField(){};
    }

    @Override
    protected ILongColumnExtension<? extends AbstractLongColumn> createLocalExtension() {
        return new LocalLongColumnExtension<AbstractLongColumn>(this);
    }

    protected static class LocalLongColumnExtension<OWNER extends AbstractLongColumn>
    extends AbstractNumberColumn.LocalNumberColumnExtension<Long, OWNER>
    implements ILongColumnExtension<OWNER> {
        public LocalLongColumnExtension(OWNER owner) {
            super(owner);
        }
    }
}

