/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.IStringColumnExtension;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IStringColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.StringUtility;

@ClassId(value="e564abbc-5f57-4ccc-a50c-003c408df519")
public abstract class AbstractStringColumn
extends AbstractColumn<String>
implements IStringColumn {
    public AbstractStringColumn() {
        this(true);
    }

    public AbstractStringColumn(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=130.0)
    protected int getConfiguredMaxLength() {
        return 4000;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=140.0)
    protected boolean getConfiguredInputMasked() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=150.0)
    protected String getConfiguredDisplayFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=160.0)
    protected boolean getConfiguredTextWrap() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=170.0)
    protected String getConfiguredFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=180.0)
    protected boolean getConfiguredSelectAllOnEdit() {
        return true;
    }

    @Override
    protected boolean getConfiguredUiSortPossible() {
        return true;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setInputMasked(this.getConfiguredInputMasked());
        this.setDisplayFormat(this.getConfiguredDisplayFormat());
        this.setMaxLength(this.getConfiguredMaxLength());
        this.setTextWrap(this.getConfiguredTextWrap());
    }

    @Override
    public void setInputMasked(boolean b) {
        this.propertySupport.setPropertyBool("inputMasked", b);
    }

    @Override
    public boolean isInputMasked() {
        return this.propertySupport.getPropertyBool("inputMasked");
    }

    @Override
    public void setDisplayFormat(String s) {
        this.propertySupport.setPropertyString("format", s);
    }

    @Override
    public String getDisplayFormat() {
        return this.propertySupport.getPropertyString("format");
    }

    @Override
    public void setTextWrap(boolean b) {
        this.propertySupport.setPropertyBool("wrapText", b);
    }

    @Override
    public boolean isTextWrap() {
        return this.propertySupport.getPropertyBool("wrapText");
    }

    @Override
    public void setMaxLength(int len) {
        if (len > 0) {
            this.propertySupport.setPropertyInt("maxLength", len);
        }
        this.refreshValues();
    }

    @Override
    public int getMaxLength() {
        int len = this.propertySupport.getPropertyInt("maxLength");
        if (len <= 0) {
            len = 200;
        }
        return len;
    }

    @Override
    public boolean isEmpty() {
        ITable table = this.getTable();
        if (table != null) {
            int i = 0;
            int ni = table.getRowCount();
            while (i < ni) {
                String value = (String)this.getValue(table.getRow(i));
                if (value != null && !value.isEmpty()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    protected String parseValueInternal(ITableRow row, Object rawValue) {
        String validValue = null;
        validValue = rawValue == null ? null : (rawValue instanceof String ? (String)rawValue : rawValue.toString());
        return validValue;
    }

    @Override
    protected String validateValueInternal(ITableRow row, String rawValue) {
        String value = super.validateValueInternal(row, rawValue);
        if (value != null && value.length() > this.getMaxLength()) {
            value = value.substring(0, this.getMaxLength());
        }
        return StringUtility.nullIfEmpty((Object)value);
    }

    @Override
    protected IFormField prepareEditInternal(ITableRow row) {
        IValueField f = this.getDefaultEditor();
        this.mapEditorFieldProperties((IStringField)f);
        return f;
    }

    protected IStringField createDefaultEditor() {
        return new AbstractStringField(){};
    }

    protected void mapEditorFieldProperties(IStringField f) {
        super.mapEditorFieldProperties(f);
        f.setInputMasked(this.isInputMasked());
        f.setFormat(this.getDisplayFormat());
        f.setMaxLength(this.getMaxLength());
        boolean multi = this.getTable() != null ? this.getTable().isMultilineText() : this.isTextWrap();
        f.setMultilineText(multi);
        f.setWrapText(this.isTextWrap());
        f.setWrapText(true);
    }

    @Override
    protected String formatValueInternal(ITableRow row, String value) {
        String format = this.getDisplayFormat();
        if (format != null && value != null) {
            if ("a".equals(format)) {
                return value.toLowerCase();
            }
            if ("A".equals(format)) {
                return value.toUpperCase();
            }
        }
        return StringUtility.emptyIfNull((Object)value);
    }

    @Override
    public int compareTableRows(ITableRow r1, ITableRow r2) {
        String s1 = (String)this.getValue(r1);
        String s2 = (String)this.getValue(r2);
        return StringUtility.compareIgnoreCase((String)s1, (String)s2);
    }

    protected IStringColumnExtension<? extends AbstractStringColumn> createLocalExtension() {
        return new LocalStringColumnExtension<AbstractStringColumn>(this);
    }

    protected static class LocalStringColumnExtension<OWNER extends AbstractStringColumn>
    extends AbstractColumn.LocalColumnExtension<String, OWNER>
    implements IStringColumnExtension<OWNER> {
        public LocalStringColumnExtension(OWNER owner) {
            super(owner);
        }
    }
}

