/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.controls;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.client.extension.ui.action.IActionExtension;
import org.eclipse.scout.rt.client.extension.ui.basic.table.controls.FormTableControlChains;
import org.eclipse.scout.rt.client.extension.ui.basic.table.controls.IFormTableControlExtension;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.AbstractAction;
import org.eclipse.scout.rt.client.ui.basic.table.controls.AbstractTableControl;
import org.eclipse.scout.rt.client.ui.basic.table.controls.IFormTableControl;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@ClassId(value="ee0673b2-f19b-4fa6-be96-a1f373edfc52")
public abstract class AbstractFormTableControl
extends AbstractTableControl
implements IFormTableControl {
    public AbstractFormTableControl() {
        this(true);
    }

    public AbstractFormTableControl(boolean callInitializer) {
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @ConfigProperty(value="FORM")
    @Order(value=90.0)
    protected Class<? extends IForm> getConfiguredForm() {
        return null;
    }

    @ConfigOperation
    @Order(value=120.0)
    protected void execInitForm() {
    }

    protected IForm createForm() {
        if (this.getConfiguredForm() == null) {
            return null;
        }
        try {
            return this.getConfiguredForm().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)new ProcessingException("error creating instance of class '" + this.getConfiguredForm().getName() + "'.", new Object[]{e}));
            return null;
        }
    }

    protected void startForm() {
        this.getForm().start();
    }

    @Override
    public void setForm(IForm form) {
        this.propertySupport.setProperty("form", (Object)form);
    }

    @Override
    public final IForm getForm() {
        return (IForm)this.propertySupport.getProperty("form");
    }

    @Override
    protected void execSelectionChanged(boolean selected) {
        super.execSelectionChanged(selected);
        this.ensureFormCreated();
        this.ensureFormStarted();
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), Collections.singletonList(this.getForm())});
    }

    public void ensureFormCreated() {
        if (this.getForm() != null) {
            return;
        }
        IForm form = this.createForm();
        if (form != null) {
            form.addFormListener(e -> {
                if (e.getType() == 3010) {
                    this.setSelected(false);
                    this.setForm(null);
                }
            });
            this.setForm(form);
            this.decorateForm();
            this.interceptInitForm();
        }
    }

    public void ensureFormStarted() {
        if (this.getForm() == null || !this.getForm().isFormStartable()) {
            return;
        }
        this.startForm();
    }

    public void decorateForm() {
        this.getForm().setShowOnStart(false);
    }

    @Override
    protected IActionExtension<? extends AbstractAction> createLocalExtension() {
        return new LocalTableControlExtension<AbstractFormTableControl>(this);
    }

    protected final void interceptInitForm() {
        List<? extends IActionExtension<? extends AbstractAction>> extensions = this.getAllExtensions();
        FormTableControlChains.TableControlInitFormChain chain = new FormTableControlChains.TableControlInitFormChain(extensions);
        chain.execInitForm();
    }

    @Override
    protected void disposeChildren(List<? extends IWidget> widgetsToDispose) {
        widgetsToDispose.remove(this.getForm());
        super.disposeChildren(widgetsToDispose);
    }

    @Override
    protected void initChildren(List<? extends IWidget> widgets) {
        widgets.remove(this.getForm());
        super.initChildren(widgets);
    }

    @Override
    public void disposeActionInternal() {
        IForm form = this.getForm();
        if (form != null && !form.isFormClosed()) {
            form.doClose();
        }
        super.disposeActionInternal();
    }

    protected static class LocalTableControlExtension<OWNER extends AbstractFormTableControl>
    extends AbstractAction.LocalActionExtension<OWNER>
    implements IFormTableControlExtension<OWNER> {
        public LocalTableControlExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execInitForm(FormTableControlChains.TableControlInitFormChain chain) {
            ((AbstractFormTableControl)this.getOwner()).execInitForm();
        }
    }
}

