/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.userfilter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.userfilter.IUserFilterState;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.serialization.SerializationUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableUserFilterManager {
    private static final Logger LOG = LoggerFactory.getLogger(TableUserFilterManager.class);
    private final Map<Object, IUserFilterState> m_filterMap = new HashMap<Object, IUserFilterState>();
    private final AbstractTable m_table;

    public TableUserFilterManager(AbstractTable table) {
        this.m_table = table;
    }

    public void addFilter(IUserFilterState filter) {
        this.m_filterMap.put(filter.createKey(), filter);
        this.fireFilterAdded(filter);
        LOG.debug("Filter added {}", (Object)filter);
    }

    public void removeFilter(IUserFilterState filter) {
        this.removeFilterByKey(filter.createKey());
    }

    public void removeFilterByKey(Object key) {
        IUserFilterState filter = this.m_filterMap.remove(key);
        this.fireFilterRemoved(filter);
        LOG.debug("Filter removed {}", (Object)filter);
    }

    public void reset() {
        for (IUserFilterState filter : new ArrayList<IUserFilterState>(this.m_filterMap.values())) {
            this.removeFilter(filter);
        }
    }

    public boolean isEmpty() {
        return this.m_filterMap.isEmpty();
    }

    public IUserFilterState getFilter(Object key) {
        return this.m_filterMap.get(key);
    }

    public Collection<IUserFilterState> getFilters() {
        return Collections.unmodifiableCollection(this.m_filterMap.values());
    }

    public List<String> getDisplayTexts() {
        ArrayList<String> list = new ArrayList<String>();
        for (IUserFilterState filter : this.m_filterMap.values()) {
            list.add(filter.getDisplayText());
        }
        return list;
    }

    private void fireFilterAdded(IUserFilterState filter) {
        TableEvent event = new TableEvent(this.m_table, 900);
        event.setUserFilter(filter);
        this.m_table.fireTableEventInternal(event);
    }

    private void fireFilterRemoved(IUserFilterState filter) {
        TableEvent event = new TableEvent(this.m_table, 910);
        event.setUserFilter(filter);
        this.m_table.fireTableEventInternal(event);
    }

    public byte[] getSerializedData() {
        byte[] data = null;
        try {
            ArrayList<IUserFilterState> filterStates = new ArrayList<IUserFilterState>(this.m_filterMap.values());
            data = SerializationUtility.createObjectSerializer().serialize(filterStates);
        }
        catch (Exception t) {
            throw new ProcessingException("Failed creating user filter data.", new Object[]{t});
        }
        return data;
    }

    public void setSerializedData(byte[] data) {
        try {
            this.reset();
            Collection filterStates = (Collection)SerializationUtility.createObjectSerializer().deserialize(data, null);
            for (IUserFilterState filterState : filterStates) {
                boolean success = filterState.notifyDeserialized(this.m_table);
                if (success) {
                    this.addFilter(filterState);
                    continue;
                }
                LOG.info("User filter state of table '{}' cannot be deserialized because the column could not be found. Ignoring element.", (Object)this.m_table.getClass().getName());
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ProcessingException("Failed reading user filter data.", new Object[]{e});
        }
    }
}

