/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public abstract class AbstractTreeNodeBuilder<LOOKUP_ROW_TYPE> {
    protected abstract ITreeNode createEmptyTreeNode();

    public ITreeNode createTreeNode(LOOKUP_ROW_TYPE primaryKey, String text, int nodeStatus, boolean markChildrenLoaded) {
        return this.createTreeNode((ILookupRow<LOOKUP_ROW_TYPE>)new LookupRow(primaryKey, text), nodeStatus, markChildrenLoaded);
    }

    public List<ITreeNode> createTreeNodes(List<? extends ILookupRow<LOOKUP_ROW_TYPE>> lookupRows, int nodeStatus, boolean markChildrenLoaded) {
        ArrayList<ITreeNode> rootNodes = new ArrayList<ITreeNode>();
        HashMap<Object, ITreeNode> nodeMap = new HashMap<Object, ITreeNode>();
        HashMap<Object, ArrayList> parentChildMap = new HashMap<Object, ArrayList>();
        if (lookupRows != null) {
            for (ILookupRow iLookupRow : lookupRows) {
                ITreeNode node = this.createTreeNode(iLookupRow, nodeStatus, markChildrenLoaded);
                nodeMap.put(node.getPrimaryKey(), node);
                if (iLookupRow.getParentKey() != null) {
                    List list = parentChildMap.computeIfAbsent(iLookupRow.getParentKey(), k -> new ArrayList());
                    list.add(node);
                    continue;
                }
                rootNodes.add(node);
            }
        }
        for (Map.Entry entry : parentChildMap.entrySet()) {
            Object parentKey = entry.getKey();
            ITreeNode parentNode = (ITreeNode)nodeMap.get(parentKey);
            if (parentNode instanceof AbstractTreeNode) {
                ((AbstractTreeNode)parentNode).addChildNodesInternal(parentNode.getChildNodeCount(), (List)entry.getValue(), true);
                continue;
            }
            rootNodes.addAll((Collection)entry.getValue());
        }
        return rootNodes;
    }

    public ITreeNode createTreeNode(ILookupRow<LOOKUP_ROW_TYPE> lookupRow, int nodeStatus, boolean markChildrenLoaded) {
        ITreeNode treeNode = this.createEmptyTreeNode();
        treeNode.setPrimaryKey(lookupRow.getKey());
        treeNode.setEnabled(lookupRow.isEnabled(), "ENABLED");
        treeNode.setStatusInternal(nodeStatus);
        if (markChildrenLoaded) {
            treeNode.setChildrenLoaded(markChildrenLoaded);
        }
        Cell cell = treeNode.getCellForUpdate();
        cell.setValue(lookupRow);
        cell.setText(lookupRow.getText());
        cell.setTooltipText(lookupRow.getTooltipText());
        if (cell.getIconId() == null) {
            cell.setIconId(lookupRow.getIconId());
        }
        cell.setCssClass(lookupRow.getCssClass());
        cell.setBackgroundColor(lookupRow.getBackgroundColor());
        cell.setForegroundColor(lookupRow.getForegroundColor());
        cell.setFont(lookupRow.getFont());
        if (!lookupRow.isActive()) {
            if (cell.getFont() == null) {
                cell.setFont(FontSpec.parse((String)"italic"));
            }
            cell.setText(String.valueOf(lookupRow.getText()) + " (" + TEXTS.get((String)"InactiveState") + ")");
        }
        return treeNode;
    }
}

