/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.tree;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.IModelEvent;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeUtility;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeEvent
extends EventObject
implements IModelEvent {
    private static final Logger LOG = LoggerFactory.getLogger(TreeEvent.class);
    public static final int TYPE_NODES_INSERTED = 10;
    public static final int TYPE_NODES_UPDATED = 20;
    public static final int TYPE_NODE_FILTER_CHANGED = 400;
    public static final int TYPE_NODES_DELETED = 30;
    public static final int TYPE_ALL_CHILD_NODES_DELETED = 31;
    public static final int TYPE_BEFORE_NODES_SELECTED = 35;
    public static final int TYPE_NODES_SELECTED = 40;
    public static final int TYPE_CHILD_NODE_ORDER_CHANGED = 50;
    public static final int TYPE_NODE_EXPANDED = 100;
    public static final int TYPE_NODE_COLLAPSED = 101;
    public static final int TYPE_NODE_EXPANDED_RECURSIVE = 102;
    public static final int TYPE_NODE_COLLAPSED_RECURSIVE = 103;
    public static final int TYPE_NODE_ACTION = 705;
    public static final int TYPE_NODES_DRAG_REQUEST = 730;
    public static final int TYPE_DRAG_FINISHED = 735;
    public static final int TYPE_NODE_DROP_ACTION = 740;
    public static final int TYPE_NODE_REQUEST_FOCUS = 200;
    public static final int TYPE_NODE_ENSURE_VISIBLE = 300;
    public static final int TYPE_REQUEST_FOCUS = 800;
    public static final int TYPE_NODE_CLICK = 820;
    public static final int TYPE_SCROLL_TO_SELECTION = 830;
    public static final int TYPE_NODE_CHANGED = 850;
    public static final int TYPE_NODE_DROP_TARGET_CHANGED = 860;
    public static final int TYPE_NODES_CHECKED = 870;
    private final int m_type;
    private ITreeNode m_commonParentNode;
    private Collection<? extends ITreeNode> m_nodes;
    private Collection<? extends ITreeNode> m_deselectedNodes;
    private Collection<? extends ITreeNode> m_newSelectedNodes;
    private List<IMenu> m_popupMenus;
    private boolean m_consumed;
    private TransferObject m_dragObject;
    private TransferObject m_dropObject;

    public TreeEvent(ITree source, int type) {
        super(source);
        this.m_type = type;
    }

    public TreeEvent(ITree source, int type, ITreeNode node) {
        super(source);
        this.m_type = type;
        if (node != null) {
            this.m_nodes = CollectionUtility.hashSet((Object)node);
        }
        this.m_commonParentNode = TreeUtility.calculateCommonParentNode(this.m_nodes);
    }

    public TreeEvent(ITree source, int type, Collection<? extends ITreeNode> nodes) {
        super(source);
        this.m_type = type;
        if (nodes != null) {
            this.m_nodes = nodes;
        }
        this.m_commonParentNode = TreeUtility.calculateCommonParentNode(this.m_nodes);
    }

    public TreeEvent(ITree source, int type, ITreeNode parentNode, Collection<? extends ITreeNode> childNodes) {
        super(source);
        this.m_type = type;
        if (childNodes != null) {
            this.m_nodes = childNodes;
        }
        this.m_commonParentNode = parentNode;
        if (this.m_commonParentNode == null) {
            this.m_commonParentNode = TreeUtility.calculateCommonParentNode(this.m_nodes);
        }
    }

    public ITree getTree() {
        return (ITree)this.getSource();
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    public ITreeNode getCommonParentNode() {
        return this.m_commonParentNode;
    }

    public ITreeNode getDeselectedNode() {
        return (ITreeNode)CollectionUtility.firstElement(this.m_deselectedNodes);
    }

    public Collection<ITreeNode> getDeselectedNodes() {
        return CollectionUtility.arrayList(this.m_deselectedNodes);
    }

    protected void setDeselectedNodes(Collection<ITreeNode> deselectedNodes) {
        this.m_deselectedNodes = deselectedNodes;
    }

    public ITreeNode getNewSelectedNode() {
        return (ITreeNode)CollectionUtility.firstElement(this.m_newSelectedNodes);
    }

    public Collection<ITreeNode> getNewSelectedNodes() {
        return CollectionUtility.arrayList(this.m_newSelectedNodes);
    }

    protected void setNewSelectedNodes(Collection<ITreeNode> newSelectedNodes) {
        this.m_newSelectedNodes = newSelectedNodes;
    }

    public ITreeNode getNode() {
        return (ITreeNode)CollectionUtility.firstElement(this.m_nodes);
    }

    public Collection<ITreeNode> getNodes() {
        return CollectionUtility.arrayList(this.m_nodes);
    }

    protected Set<ITreeNode> getNodesSet() {
        return CollectionUtility.hashSet(this.m_nodes);
    }

    protected void setNodes(Collection<ITreeNode> nodes) {
        this.m_nodes = nodes;
        if (this.getType() != 31) {
            this.m_commonParentNode = TreeUtility.calculateCommonParentNode(nodes);
        }
    }

    protected boolean removeNodes(Set<ITreeNode> nodesToRemove, Set<ITreeNode> removedNodesCollector) {
        if (CollectionUtility.isEmpty(nodesToRemove) || CollectionUtility.isEmpty(this.m_nodes)) {
            return false;
        }
        boolean removed = false;
        Iterator<? extends ITreeNode> it = this.m_nodes.iterator();
        while (it.hasNext()) {
            ITreeNode node = it.next();
            if (!nodesToRemove.contains(node) && !nodesToRemove.contains(this.m_commonParentNode)) continue;
            it.remove();
            removed = true;
            if (removedNodesCollector == null) continue;
            removedNodesCollector.add(node);
        }
        return removed;
    }

    public boolean hasNodes() {
        return this.m_nodes == null ? false : !this.m_nodes.isEmpty();
    }

    public int getNodeCount() {
        return this.m_nodes == null ? 0 : this.m_nodes.size();
    }

    public boolean containsNode(ITreeNode nodeToFind) {
        if (CollectionUtility.isEmpty(this.m_nodes)) {
            return false;
        }
        for (ITreeNode iTreeNode : this.m_nodes) {
            if (!ObjectUtility.equals((Object)iTreeNode, (Object)nodeToFind)) continue;
            return true;
        }
        return false;
    }

    public ITreeNode getChildNode() {
        return this.getNode();
    }

    public Collection<ITreeNode> getChildNodes() {
        return this.getNodes();
    }

    public void addPopupMenu(IMenu menu) {
        if (menu != null) {
            if (this.m_popupMenus == null) {
                this.m_popupMenus = new ArrayList<IMenu>();
            }
            this.m_popupMenus.add(menu);
        }
    }

    public void addPopupMenus(List<IMenu> menus) {
        if (menus != null) {
            if (this.m_popupMenus == null) {
                this.m_popupMenus = new ArrayList<IMenu>();
            }
            this.m_popupMenus.addAll(menus);
        }
    }

    public List<IMenu> getPopupMenus() {
        return CollectionUtility.arrayList(this.m_popupMenus);
    }

    public int getPopupMenuCount() {
        if (this.m_popupMenus != null) {
            return this.m_popupMenus.size();
        }
        return 0;
    }

    public TransferObject getDragObject() {
        return this.m_dragObject;
    }

    public void setDragObject(TransferObject t) {
        this.m_dragObject = t;
    }

    public TransferObject getDropObject() {
        return this.m_dropObject;
    }

    protected void setDropObject(TransferObject t) {
        this.m_dropObject = t;
    }

    public boolean isConsumed() {
        return this.m_consumed;
    }

    public void consume() {
        this.m_consumed = true;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName()).append("[");
        buf.append(this.getTypeName());
        if (this.getCommonParentNode() != null) {
            buf.append(" CPN=").append(this.getCommonParentNode());
        }
        if (CollectionUtility.hasElements(this.m_nodes) && this.getTree() != null) {
            buf.append(" ");
            if (this.m_nodes.size() == 1) {
                buf.append("\"").append(CollectionUtility.firstElement(this.m_nodes)).append("\"");
            } else {
                buf.append("{");
                Iterator<? extends ITreeNode> nodeIt = this.m_nodes.iterator();
                buf.append("\"").append(nodeIt.next()).append("\"");
                while (nodeIt.hasNext()) {
                    buf.append(",").append("\"").append(nodeIt.next()).append("\"");
                }
                buf.append("}");
            }
        }
        buf.append("]");
        return buf.toString();
    }

    private String getTypeName() {
        try {
            Field[] f;
            Field[] fieldArray = f = this.getClass().getDeclaredFields();
            int n = f.length;
            int n2 = 0;
            while (n2 < n) {
                Field aF = fieldArray[n2];
                if (Modifier.isPublic(aF.getModifiers()) && Modifier.isStatic(aF.getModifiers()) && aF.getName().startsWith("TYPE_") && ((Number)aF.get(null)).intValue() == this.m_type) {
                    return aF.getName();
                }
                ++n2;
            }
        }
        catch (IllegalAccessException e) {
            LOG.error("Error Reading fields", (Throwable)e);
        }
        return "#" + this.m_type;
    }
}

