/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop;

import java.net.URI;
import java.util.Objects;

public class BrowserHistoryEntry {
    private final String m_title;
    private final URI m_path;
    private final String m_deepLinkPath;
    private final boolean m_pathVisible;

    public BrowserHistoryEntry(URI path, String title, String deepLinkPath, boolean pathVisible) {
        this.m_path = path;
        this.m_title = title;
        this.m_deepLinkPath = deepLinkPath;
        this.m_pathVisible = pathVisible;
    }

    public String getTitle() {
        return this.m_title;
    }

    public String getPath() {
        if (this.m_path == null) {
            return null;
        }
        return this.m_path.toString();
    }

    public String getDeepLinkPath() {
        return this.m_deepLinkPath;
    }

    public boolean isPathVisible() {
        return this.m_pathVisible;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrowserHistoryEntry that = (BrowserHistoryEntry)o;
        return this.m_pathVisible == that.m_pathVisible && this.m_title.equals(that.m_title) && this.m_path.equals(that.m_path) && this.m_deepLinkPath.equals(that.m_deepLinkPath);
    }

    public int hashCode() {
        return Objects.hash(this.m_title, this.m_path, this.m_deepLinkPath, this.m_pathVisible);
    }
}

