/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.EventObject;
import org.eclipse.scout.rt.client.ui.IModelEvent;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.IOpenUriAction;
import org.eclipse.scout.rt.client.ui.desktop.notification.IDesktopNotification;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.platform.resource.BinaryResource;

public class DesktopEvent
extends EventObject
implements IModelEvent {
    public static final int TYPE_DESKTOP_CLOSED = 100;
    public static final int TYPE_OUTLINE_CHANGED = 200;
    public static final int TYPE_OUTLINE_CONTENT_ACTIVATE = 210;
    public static final int TYPE_FORM_SHOW = 600;
    public static final int TYPE_FORM_HIDE = 610;
    public static final int TYPE_FORM_ACTIVATE = 620;
    public static final int TYPE_MESSAGE_BOX_SHOW = 700;
    public static final int TYPE_MESSAGE_BOX_HIDE = 710;
    public static final int TYPE_FILE_CHOOSER_SHOW = 910;
    public static final int TYPE_FILE_CHOOSER_HIDE = 915;
    public static final int TYPE_OPEN_URI = 920;
    public static final int TYPE_NOTIFICATION_ADDED = 1040;
    public static final int TYPE_NOTIFICATION_REMOVED = 1050;
    public static final int TYPE_RELOAD_GUI = 1060;
    public static final int TYPE_REQUEST_GEOLOCATION = 110;
    private final int m_type;
    private IOutline m_outline;
    private IForm m_form;
    private IForm m_activeForm;
    private IMessageBox m_messageBox;
    private IFileChooser m_fileChooser;
    private String m_uri;
    private IOpenUriAction m_openUriAction;
    private BinaryResource m_binaryResource;
    private IDesktopNotification m_notification;

    public DesktopEvent(IDesktop source, int type) {
        super(source);
        this.m_type = type;
    }

    public DesktopEvent(IDesktop source, int type, IForm form) {
        this(source, type);
        this.m_form = form;
    }

    public DesktopEvent(IDesktop source, int type, IMessageBox messageBox) {
        this(source, type);
        this.m_messageBox = messageBox;
    }

    public DesktopEvent(IDesktop source, int type, IOutline outline) {
        this(source, type);
        this.m_outline = outline;
    }

    public DesktopEvent(IDesktop source, int type, IFileChooser fc) {
        this(source, type);
        this.m_fileChooser = fc;
    }

    public DesktopEvent(IDesktop source, int type, String uri, IOpenUriAction openUriAction) {
        this(source, type);
        this.m_uri = uri;
        this.m_openUriAction = openUriAction;
    }

    public DesktopEvent(IDesktop source, int type, BinaryResource res, IOpenUriAction openUriAction) {
        this(source, type);
        this.m_binaryResource = res;
        this.m_openUriAction = openUriAction;
    }

    public DesktopEvent(IDesktop source, int type, IDesktopNotification notification) {
        super(source);
        this.m_type = type;
        this.m_notification = notification;
    }

    public IDesktop getDesktop() {
        return (IDesktop)this.getSource();
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    public IForm getForm() {
        return this.m_form;
    }

    public ISearchForm getSearchForm() {
        return (ISearchForm)this.m_form;
    }

    public IForm getDetailForm() {
        return this.m_form;
    }

    public IFileChooser getFileChooser() {
        return this.m_fileChooser;
    }

    public String getUri() {
        return this.m_uri;
    }

    public IOpenUriAction getOpenUriAction() {
        return this.m_openUriAction;
    }

    public BinaryResource getBinaryResource() {
        return this.m_binaryResource;
    }

    public IMessageBox getMessageBox() {
        return this.m_messageBox;
    }

    public IOutline getOutline() {
        return this.m_outline;
    }

    public IForm getActiveForm() {
        return this.m_activeForm;
    }

    public void setActiveForm(IForm activeForm) {
        this.m_activeForm = activeForm;
    }

    public IDesktopNotification getNotification() {
        return this.m_notification;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName()).append("[");
        try {
            Field[] f;
            Field[] fieldArray = f = this.getClass().getDeclaredFields();
            int n = f.length;
            int n2 = 0;
            while (n2 < n) {
                Field aF = fieldArray[n2];
                if (Modifier.isPublic(aF.getModifiers()) && Modifier.isStatic(aF.getModifiers()) && aF.getName().startsWith("TYPE_") && ((Number)aF.get(null)).intValue() == this.m_type) {
                    buf.append(aF.getName());
                    break;
                }
                ++n2;
            }
        }
        catch (Exception t) {
            buf.append("#").append(this.m_type);
        }
        if (this.m_form != null) {
            buf.append(" ").append(this.m_form.getTitle());
        }
        if (this.m_messageBox != null) {
            buf.append(" ").append(this.m_messageBox.getHeader());
        }
        if (this.m_outline != null) {
            buf.append(" ").append(this.m_outline.getRootNode().getCell().toPlainText());
        }
        buf.append("]");
        return buf.toString();
    }
}

