/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop;

import java.util.List;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.IDisplayParent;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.index.AbstractMultiValueIndex;
import org.eclipse.scout.rt.platform.index.IIndex;
import org.eclipse.scout.rt.platform.index.IndexedStore;

@Bean
public class FileChooserStore
extends IndexedStore<IFileChooser> {
    private final P_DisplayParentIndex m_displayParentIndex = (P_DisplayParentIndex)this.registerIndex((IIndex)new P_DisplayParentIndex());
    private final P_ApplicationModalIndex m_applicationModalIndex = (P_ApplicationModalIndex)this.registerIndex((IIndex)new P_ApplicationModalIndex());

    public List<IFileChooser> getByDisplayParent(IDisplayParent displayParent) {
        return this.m_displayParentIndex.get(displayParent);
    }

    public boolean containsApplicationModalFileChoosers() {
        return !this.getApplicationModalFileChoosers().isEmpty();
    }

    public List<IFileChooser> getApplicationModalFileChoosers() {
        return this.m_applicationModalIndex.get(Boolean.TRUE);
    }

    private class P_ApplicationModalIndex
    extends AbstractMultiValueIndex<Boolean, IFileChooser> {
        private P_ApplicationModalIndex() {
        }

        protected Boolean calculateIndexFor(IFileChooser fileChooser) {
            if (fileChooser.getDisplayParent() == ClientSessionProvider.currentSession().getDesktop()) {
                return true;
            }
            return false;
        }
    }

    private class P_DisplayParentIndex
    extends AbstractMultiValueIndex<IDisplayParent, IFileChooser> {
        private P_DisplayParentIndex() {
        }

        protected IDisplayParent calculateIndexFor(IFileChooser fileChooser) {
            return fileChooser.getDisplayParent();
        }
    }
}

