/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.eclipse.scout.rt.client.ui.Coordinates;
import org.eclipse.scout.rt.client.ui.IDisplayParent;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.IStyleable;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenuOwner;
import org.eclipse.scout.rt.client.ui.action.view.IViewButton;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.desktop.BrowserHistoryEntry;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListeners;
import org.eclipse.scout.rt.client.ui.desktop.IDesktopUIFacade;
import org.eclipse.scout.rt.client.ui.desktop.IOpenUriAction;
import org.eclipse.scout.rt.client.ui.desktop.bench.layout.BenchLayoutData;
import org.eclipse.scout.rt.client.ui.desktop.datachange.DataChangeEvent;
import org.eclipse.scout.rt.client.ui.desktop.datachange.IDataChangeListener;
import org.eclipse.scout.rt.client.ui.desktop.datachange.IDataChangeManager;
import org.eclipse.scout.rt.client.ui.desktop.notification.IDesktopNotification;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormHandler;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.platform.context.PropertyMap;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;

public interface IDesktop
extends IWidget,
IDisplayParent,
IStyleable,
IContextMenuOwner {
    public static final ThreadLocal<IDesktop> CURRENT = new ThreadLocal();
    public static final String PROP_TITLE = "title";
    public static final String PROP_LOGO_ID = "logoId";
    public static final String PROP_STATUS = "status";
    public static final String PROP_KEY_STROKES = "keyStrokes";
    public static final String PROP_OPENED = "opened";
    public static final String PROP_GUI_AVAILABLE = "guiAvailable";
    public static final String PROP_GEOLOCATION_SERVICE_AVAILABLE = "geolocationServiceAvailable";
    public static final String PROP_SELECT_VIEW_TABS_KEY_STROKES_ENABLED = "selectViewTabsKeyStrokesEnabled";
    public static final String PROP_SELECT_VIEW_TABS_KEY_STROKE_MODIFIER = "selectViewTabsKeyStrokeModifier";
    public static final String PROP_CACHE_SPLITTER_POSITION = "cacheSplitterPosition";
    public static final String PROP_DISPLAY_STYLE = "displayStyle";
    public static final String PROP_ACTIVE_FORM = "activeForm";
    public static final String PROP_THEME = "theme";
    public static final String PROP_BROWSER_HISTORY_ENTRY = "browserHistoryEntry";
    public static final String PROP_NAVIGATION_VISIBLE = "navigationVisible";
    public static final String PROP_NAVIGATION_HANDLE_VISIBLE = "navigationHandleVisible";
    public static final String PROP_HEADER_VISIBLE = "headerVisible";
    public static final String PROP_IN_BACKGROUND = "inBackground";
    public static final String PROP_BENCH_VISIBLE = "benchVisible";
    public static final String PROP_BENCH_LAYOUT_DATA = "benchLayoutData";
    public static final String PROP_LOGO_ACTION_ENABLED = "logoActionEnabled";
    public static final String PROP_STARTUP_REQUEST_PARAMS = "startupRequestParams";
    public static final String STARTUP_REQUEST_PARAM_URL = "url";
    public static final String PROP_DENSE = "dense";
    public static final String DISPLAY_STYLE_DEFAULT = "default";
    public static final String DISPLAY_STYLE_BENCH = "bench";
    public static final String DISPLAY_STYLE_COMPACT = "compact";

    public <T extends IForm> T findForm(Class<T> var1);

    public <T extends IForm> List<T> findForms(Class<T> var1);

    public <T extends IOutline> T findOutline(Class<T> var1);

    public <T extends IAction> T findAction(Class<T> var1);

    public <T extends IViewButton> T findViewButton(Class<T> var1);

    public List<IForm> getSimilarForms(IForm var1);

    public void ensureViewStackVisible();

    public void activateForm(IForm var1);

    public void activateOutline(IOutline var1);

    public void activateFirstPage();

    public boolean isShowing(IForm var1);

    public boolean isOpened();

    public List<IForm> getForms(IDisplayParent var1);

    public List<IForm> getViews();

    public List<IForm> getViews(IDisplayParent var1);

    public Collection<IForm> getSelectedViews(IDisplayParent var1);

    public <F extends IForm, H extends IFormHandler> List<F> findAllOpenViews(Class<? extends F> var1, Class<? extends H> var2, Object var3);

    public <F extends IForm, H extends IFormHandler> F findOpenView(Class<? extends F> var1, Class<? extends H> var2, Object var3);

    public List<IForm> getDialogs();

    public List<IForm> getDialogs(IDisplayParent var1, boolean var2);

    public List<IForm> getUnsavedForms();

    public void showForm(IForm var1);

    public void hideForm(IForm var1);

    public boolean isShowing(IMessageBox var1);

    public List<IMessageBox> getMessageBoxes();

    public List<IDesktopNotification> getNotifications();

    public List<IMessageBox> getMessageBoxes(IDisplayParent var1);

    public void showMessageBox(IMessageBox var1);

    public void hideMessageBox(IMessageBox var1);

    public List<IOutline> getAvailableOutlines();

    public void setAvailableOutlines(List<? extends IOutline> var1);

    public Set<IKeyStroke> getKeyStrokes();

    public void setKeyStrokes(Collection<? extends IKeyStroke> var1);

    public void addKeyStrokes(IKeyStroke ... var1);

    public void removeKeyStrokes(IKeyStroke ... var1);

    public IOutline getOutline();

    public void setOutline(Class<? extends IOutline> var1);

    public void refreshPages(List<Class<? extends IPage<?>>> var1);

    public void refreshPages(Class<?> ... var1);

    public void addPropertyChangeListener(PropertyChangeListener var1);

    public void removePropertyChangeListener(PropertyChangeListener var1);

    public void addPropertyChangeListener(String var1, PropertyChangeListener var2);

    public void removePropertyChangeListener(String var1, PropertyChangeListener var2);

    public DesktopListeners desktopListeners();

    default public void addDesktopListener(DesktopListener listener, Integer ... eventTypes) {
        this.desktopListeners().add(listener, false, eventTypes);
    }

    default public void removeDesktopListener(DesktopListener listener, Integer ... eventTypes) {
        this.desktopListeners().remove(listener, eventTypes);
    }

    default public void addUIDesktopListener(DesktopListener listener, Integer ... eventTypes) {
        this.desktopListeners().addLastCalled(listener, false, eventTypes);
    }

    public IDataChangeManager dataChangeListeners();

    public IDataChangeManager dataChangeDesktopInForegroundListeners();

    default public void addDataChangeListener(IDataChangeListener listener, Object ... dataTypes) {
        this.dataChangeListeners().add(listener, false, dataTypes);
    }

    default public void addDataChangeDesktopInForegroundListener(IDataChangeListener listener, Object ... dataTypes) {
        this.dataChangeDesktopInForegroundListeners().add(listener, false, dataTypes);
    }

    default public void removeDataChangeListener(IDataChangeListener listener, Object ... dataTypes) {
        this.dataChangeListeners().remove(listener, dataTypes);
        this.dataChangeDesktopInForegroundListeners().remove(listener, dataTypes);
    }

    public void dataChanged(Object ... var1);

    public void fireDataChangeEvent(DataChangeEvent var1);

    public void setDataChanging(boolean var1);

    public boolean isDataChanging();

    public void afterTablePageLoaded(IPageWithTable<?> var1);

    public void releaseUnusedPages();

    public List<IAction> getActions();

    public <T extends IViewButton> T getViewButton(Class<? extends T> var1);

    public List<IViewButton> getViewButtons();

    public IForm getPageDetailForm();

    public void setPageDetailForm(IForm var1);

    public ITable getPageDetailTable();

    public void setPageDetailTable(ITable var1);

    public IForm getPageSearchForm();

    public void setPageSearchForm(IForm var1);

    public String getTitle();

    public void setTitle(String var1);

    public boolean isSelectViewTabsKeyStrokesEnabled();

    public void setSelectViewTabsKeyStrokesEnabled(boolean var1);

    public String getSelectViewTabsKeyStrokeModifier();

    public void setSelectViewTabsKeyStrokeModifier(String var1);

    public boolean isAutoPrefixWildcardForTextSearch();

    public void setAutoPrefixWildcardForTextSearch(boolean var1);

    public boolean isCacheSplitterPosition();

    public void setCacheSplitterPosition(boolean var1);

    public void addNotification(IDesktopNotification var1);

    public void removeNotification(IDesktopNotification var1);

    public boolean isShowing(IFileChooser var1);

    public List<IFileChooser> getFileChoosers();

    public List<IFileChooser> getFileChoosers(IDisplayParent var1);

    public void showFileChooser(IFileChooser var1);

    public void hideFileChooser(IFileChooser var1);

    public void openUri(String var1, IOpenUriAction var2);

    public void openUri(BinaryResource var1);

    public void openUri(BinaryResource var1, IOpenUriAction var2);

    public void doLogoAction();

    public void activateBookmark(Bookmark var1);

    public void activateBookmark(Bookmark var1, boolean var2);

    public Bookmark createBookmark();

    public Bookmark createBookmark(IPage<?> var1);

    public void closeInternal();

    public IDesktopUIFacade getUIFacade();

    public boolean isGuiAvailable();

    public void reloadGui();

    public boolean doBeforeClosingInternal();

    public IForm getActiveForm();

    public Collection<Object> getAddOns();

    public <T> T getAddOn(Class<T> var1);

    public void addAddOn(Object var1);

    public void removeAddOn(Object var1);

    public boolean isOutlineChanging();

    public String getDisplayStyle();

    public void setDisplayStyle(String var1);

    public String getLogoId();

    public void setLogoId(String var1);

    public String getTheme();

    public void setTheme(String var1);

    public BrowserHistoryEntry getBrowserHistoryEntry();

    public void setBrowserHistoryEntry(BrowserHistoryEntry var1);

    public void setNavigationVisible(boolean var1);

    public boolean isNavigationVisible();

    public void setNavigationHandleVisible(boolean var1);

    public boolean isNavigationHandleVisible();

    public void setBenchVisible(boolean var1);

    public boolean isBenchVisible();

    public BenchLayoutData getBenchLayoutData();

    public void setBenchLayoutData(BenchLayoutData var1);

    public void setHeaderVisible(boolean var1);

    public boolean isHeaderVisible();

    public boolean isInBackground();

    public IEventHistory<DesktopEvent> getEventHistory();

    public boolean isGeolocationServiceAvailable();

    public void setGeolocationServiceAvailable(boolean var1);

    public Future<Coordinates> requestGeolocation();

    public void setLogoActionEnabled(boolean var1);

    public boolean isLogoActionEnabled();

    public PropertyMap getStartupRequestParams();

    public <VALUE> VALUE getStartupRequestParam(String var1);

    public String getStartupUrl();

    public boolean cancelForms(Set<IForm> var1);

    public boolean cancelForms(Set<IForm> var1, boolean var2);

    public void closeForms(Set<IForm> var1);

    public void setDense(boolean var1);

    public boolean isDense();
}

