/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.bookmark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.eclipse.scout.rt.client.services.common.bookmark.IBookmarkService;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkFolder;
import org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkVisitor;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

@ClassId(value="786fb2d7-5d48-4239-b267-bec20cca8a88")
public class KeyStrokeLookupCall
extends LocalLookupCall<String> {
    private static final long serialVersionUID = 1L;
    private String m_currentKeyStroke;

    public String getCurrentKeyStroke() {
        return this.m_currentKeyStroke;
    }

    public void setCurrentKeyStroke(String s) {
        this.m_currentKeyStroke = s;
    }

    protected List<ILookupRow<String>> execCreateLookupRows() {
        final HashMap<String, Integer> keyStrokesUpper = new HashMap<String, Integer>();
        int i = 1;
        while (i <= 12) {
            keyStrokesUpper.put("SHIFT-F" + i, i);
            ++i;
        }
        IBookmarkService service = (IBookmarkService)BEANS.get(IBookmarkService.class);
        IBookmarkVisitor v = new IBookmarkVisitor(){

            public boolean visitFolder(List<BookmarkFolder> path) {
                return true;
            }

            public boolean visitBookmark(List<BookmarkFolder> path, Bookmark b) {
                String keyStroke = b.getKeyStroke();
                if (!(keyStroke == null || KeyStrokeLookupCall.this.m_currentKeyStroke != null && KeyStrokeLookupCall.this.m_currentKeyStroke.equalsIgnoreCase(keyStroke))) {
                    keyStrokesUpper.remove(keyStroke.toUpperCase(Locale.ENGLISH));
                }
                return true;
            }
        };
        service.getBookmarkData().getGlobalBookmarks().visit(v);
        service.getBookmarkData().getUserBookmarks().visit(v);
        TreeSet availableNumbers = new TreeSet(keyStrokesUpper.values());
        ArrayList<ILookupRow<String>> resultList = new ArrayList<ILookupRow<String>>();
        for (Integer i2 : availableNumbers) {
            String key = "Shift-F" + i2;
            String text = "Shift-F" + i2;
            LookupRow row = new LookupRow((Object)key, text);
            resultList.add((ILookupRow<String>)row);
        }
        return resultList;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.m_currentKeyStroke == null ? 0 : this.m_currentKeyStroke.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        KeyStrokeLookupCall other = (KeyStrokeLookupCall)((Object)obj);
        return !(this.m_currentKeyStroke == null ? other.m_currentKeyStroke != null : !this.m_currentKeyStroke.equals(other.m_currentKeyStroke));
    }
}

