/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.bookmark.view;

import java.security.Permission;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.client.services.common.bookmark.BookmarkClientNotificationHandler;
import org.eclipse.scout.rt.client.services.common.bookmark.BookmarkServiceListener;
import org.eclipse.scout.rt.client.services.common.bookmark.IBookmarkService;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNodeFilter;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.AbstractBookmarkTreeField;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.BookmarkForm;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.IBookmarkForm;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractLinkButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.AbstractTabBox;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.notification.INotificationListener;
import org.eclipse.scout.rt.shared.security.CreateUserBookmarkPermission;
import org.eclipse.scout.rt.shared.security.DeleteUserBookmarkPermission;
import org.eclipse.scout.rt.shared.security.UpdateUserBookmarkPermission;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkChangedClientNotification;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="f75ab95f-f827-431b-b5e9-53c71b5eb965")
public class BookmarkViewForm
extends AbstractForm {
    private static final Logger LOG = LoggerFactory.getLogger(BookmarkViewForm.class);

    @ConfigProperty(value="FORM")
    @Order(value=10.0)
    protected Class<? extends IBookmarkForm> getConfiguredBookmarkForm() {
        return BookmarkForm.class;
    }

    @Override
    protected String getConfiguredTitle() {
        return TEXTS.get((String)"Bookmarks");
    }

    public void startView() {
        this.startInternal(new ViewHandler());
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.TabBox.BookmarksBox getBookmarksBox() {
        return this.getFieldByClass(MainBox.TabBox.BookmarksBox.class);
    }

    public MainBox.TabBox.BookmarksBox.UserBookmarkTreeField getUserBookmarkTreeField() {
        return this.getFieldByClass(MainBox.TabBox.BookmarksBox.UserBookmarkTreeField.class);
    }

    public MainBox.TabBox.BookmarksBox.UserBookmarkSearchField getUserBookmarkSearchField() {
        return this.getFieldByClass(MainBox.TabBox.BookmarksBox.UserBookmarkSearchField.class);
    }

    public MainBox.TabBox.BookmarksBox.AddBookmarksLinkButton getAddBookmarksLinkButton() {
        return this.getFieldByClass(MainBox.TabBox.BookmarksBox.AddBookmarksLinkButton.class);
    }

    public MainBox.TabBox.BookmarksBox.SetStartPageLinkButton getSetStartPageLinkButton() {
        return this.getFieldByClass(MainBox.TabBox.BookmarksBox.SetStartPageLinkButton.class);
    }

    public MainBox.TabBox.BookmarksBox.ClearStartPageLinkButton getClearStartPageLinkButton() {
        return this.getFieldByClass(MainBox.TabBox.BookmarksBox.ClearStartPageLinkButton.class);
    }

    private void refreshFormState() {
        IBookmarkService bmService = (IBookmarkService)BEANS.get(IBookmarkService.class);
        this.getUserBookmarkTreeField().setBookmarkRootFolder(bmService.getBookmarkData().getUserBookmarks());
        this.getUserBookmarkTreeField().populateTree();
    }

    @Order(value=10.0)
    @ClassId(value="6cba98a1-570b-4cca-b85b-3a2408fccf1d")
    public class MainBox
    extends AbstractGroupBox {

        @Order(value=10.0)
        @ClassId(value="80d03507-9df7-448f-ba2f-4d35613d03cc")
        public class TabBox
        extends AbstractTabBox {

            @Order(value=10.0)
            @ClassId(value="549d76a2-9231-412f-8635-aedc0e2b801a")
            public class BookmarksBox
            extends AbstractGroupBox {
                @Override
                protected String getConfiguredLabel() {
                    return TEXTS.get((String)"Bookmarks");
                }

                @Override
                protected int getConfiguredGridColumnCount() {
                    return 1;
                }

                @Order(value=100.0)
                @ClassId(value="10b52ed7-ce47-48ae-a45b-927c1e49fa55")
                public class AddBookmarksLinkButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"BookmarksAddMenu");
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execInitField() {
                        this.setVisiblePermission((Permission)new CreateUserBookmarkPermission());
                    }

                    @Override
                    protected void execClickAction() {
                        int kind = 1;
                        Bookmark b = ClientSessionProvider.currentSession().getDesktop().createBookmark();
                        if (b != null) {
                            b.setKind(kind);
                            IBookmarkForm form = null;
                            if (BookmarkViewForm.this.getConfiguredBookmarkForm() != null) {
                                try {
                                    form = BookmarkViewForm.this.getConfiguredBookmarkForm().getConstructor(new Class[0]).newInstance(new Object[0]);
                                }
                                catch (Exception e) {
                                    ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)new ProcessingException("error creating instance of class '" + BookmarkViewForm.this.getConfiguredBookmarkForm().getName() + "'.", new Object[]{e}));
                                }
                            }
                            if (form == null) {
                                form = new BookmarkForm();
                            }
                            form.setBookmarkRootFolder(BookmarkViewForm.this.getUserBookmarkTreeField().getBookmarkRootFolder());
                            form.setBookmark(b);
                            if (form.getBookmarkRootFolder() != form.getBookmarkRootFolder()) {
                                form.setFolder(form.getBookmarkRootFolder());
                            }
                            form.startNew();
                            form.waitFor();
                            if (form.isFormStored()) {
                                b.setTitle(b.getTitle());
                                b.setKeyStroke(b.getKeyStroke());
                                b.setOrder(b.getOrder());
                                BookmarkFolder folder = form.getFolder();
                                if (folder == null) {
                                    folder = form.getBookmarkRootFolder();
                                }
                                folder.getBookmarks().add(b);
                                IBookmarkService service = (IBookmarkService)BEANS.get(IBookmarkService.class);
                                service.storeBookmarks();
                            }
                        }
                    }
                }

                @Order(value=120.0)
                @ClassId(value="3fdab4a7-3f4f-4cae-96bd-31b0d7cd77c5")
                public class ClearStartPageLinkButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"BookmarksStartPageMenuClear");
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execInitField() {
                        this.setVisiblePermission((Permission)new CreateUserBookmarkPermission());
                    }

                    @Override
                    protected void execClickAction() {
                        IBookmarkService service = (IBookmarkService)BEANS.get(IBookmarkService.class);
                        service.deleteStartBookmark();
                        service.storeBookmarks();
                    }
                }

                @Order(value=110.0)
                @ClassId(value="c055e650-5f0e-458c-a4f9-10ecf37e78d0")
                public class SetStartPageLinkButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"BookmarksStartPageMenuSet");
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execInitField() {
                        this.setVisiblePermission((Permission)new CreateUserBookmarkPermission());
                    }

                    @Override
                    protected void execClickAction() {
                        IBookmarkService service = (IBookmarkService)BEANS.get(IBookmarkService.class);
                        service.setStartBookmark();
                        service.storeBookmarks();
                    }
                }

                @Order(value=20.0)
                @ClassId(value="23af2442-38f6-4c74-a590-2180c39cff15")
                public class UserBookmarkSearchField
                extends AbstractStringField
                implements ITreeNodeFilter {
                    private Pattern m_lowercaseFilterPattern;

                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"FilterBookmarkTree");
                    }

                    @Override
                    protected String getConfiguredTooltipText() {
                        return TEXTS.get((String)"SmartFindLabel");
                    }

                    @Override
                    protected boolean getConfiguredLabelVisible() {
                        return false;
                    }

                    @Override
                    protected byte getConfiguredLabelPosition() {
                        return 2;
                    }

                    @Override
                    protected boolean getConfiguredUpdateDisplayTextOnModify() {
                        return true;
                    }

                    @Override
                    protected void execChangedDisplayText() {
                        String s = StringUtility.emptyIfNull((Object)this.getDisplayText()).trim();
                        if (!s.isEmpty()) {
                            if (!s.endsWith("*")) {
                                s = String.valueOf(s) + "*";
                            }
                            this.m_lowercaseFilterPattern = Pattern.compile(StringUtility.toRegExPattern((String)s.toLowerCase()));
                            BookmarkViewForm.this.getUserBookmarkTreeField().getTree().addNodeFilter(this);
                        } else {
                            BookmarkViewForm.this.getUserBookmarkTreeField().getTree().removeNodeFilter(this);
                        }
                    }

                    @Override
                    public boolean accept(ITreeNode node, int level) {
                        String text = node.getCell().toPlainText();
                        return text == null || this.m_lowercaseFilterPattern == null || this.m_lowercaseFilterPattern.matcher(text.toLowerCase()).matches();
                    }
                }

                @Order(value=20.0)
                @ClassId(value="abaae7ed-f148-4368-94ac-e53710b25b24")
                public class UserBookmarkTreeField
                extends AbstractBookmarkTreeField {
                    @Override
                    protected int getConfiguredGridW() {
                        return 1;
                    }

                    @Override
                    protected int getConfiguredGridH() {
                        return 10;
                    }

                    @Override
                    protected Permission getDeletePermission() {
                        return new DeleteUserBookmarkPermission();
                    }

                    @Override
                    protected Permission getUpdatePermission() {
                        return new UpdateUserBookmarkPermission();
                    }
                }
            }
        }
    }

    public class ViewHandler
    extends AbstractFormHandler {
        private final INotificationListener<BookmarkChangedClientNotification> m_cncListener = notification -> {
            try {
                ((IBookmarkService)BEANS.get(IBookmarkService.class)).loadBookmarks();
            }
            catch (RuntimeException | PlatformError e) {
                LOG.error("Could not reload bookmarks.", e);
            }
        };
        private final BookmarkServiceListener m_bmListener = e -> {
            switch (e.getType()) {
                case 10: {
                    BookmarkViewForm.this.refreshFormState();
                }
            }
        };

        @Override
        protected void execLoad() {
            BookmarkClientNotificationHandler bookmarkClientNotificationHandler = (BookmarkClientNotificationHandler)BEANS.get(BookmarkClientNotificationHandler.class);
            bookmarkClientNotificationHandler.addListener(this.m_cncListener);
            IBookmarkService bmService = (IBookmarkService)BEANS.get(IBookmarkService.class);
            if (bmService != null) {
                bmService.removeBookmarkServiceListener(this.m_bmListener);
                bmService.addBookmarkServiceListener(this.m_bmListener);
                bmService.loadBookmarks();
            }
        }

        @Override
        protected void execFinally() {
            IBookmarkService bmService = (IBookmarkService)BEANS.get(IBookmarkService.class);
            if (bmService != null) {
                bmService.removeBookmarkServiceListener(this.m_bmListener);
            }
            BookmarkClientNotificationHandler bookmarkClientNotificationHandler = (BookmarkClientNotificationHandler)BEANS.get(BookmarkClientNotificationHandler.class);
            bookmarkClientNotificationHandler.removeListener(this.m_cncListener);
        }
    }
}

