/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.notification;

import java.util.function.Consumer;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.notification.IDesktopNotification;
import org.eclipse.scout.rt.client.ui.desktop.notification.IDesktopNotificationUIFacade;
import org.eclipse.scout.rt.client.ui.notification.Notification;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.status.Status;

@ClassId(value="cd82392d-609d-44c2-ac41-87fca7a78646")
public class DesktopNotification
extends Notification
implements IDesktopNotification {
    private final long m_duration;
    private final boolean m_closable;
    private final boolean m_htmlEnabled;
    private final Consumer<String> m_appLinkConsumer;
    private final IDesktopNotificationUIFacade m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());

    public DesktopNotification(String text) {
        this((IStatus)new Status(text, 256));
    }

    public DesktopNotification(IStatus status) {
        this(status, DEFAULT_DURATION, true);
    }

    public DesktopNotification(IStatus status, long duration, boolean closable) {
        this(status, duration, closable, false, null);
    }

    public DesktopNotification(IStatus status, long duration, boolean closable, boolean htmlEnabled, Consumer<String> appLinkConsumer) {
        super(status);
        this.m_duration = duration;
        this.m_closable = closable;
        this.m_htmlEnabled = htmlEnabled;
        this.m_appLinkConsumer = appLinkConsumer;
    }

    @Override
    public long getDuration() {
        return this.m_duration;
    }

    @Override
    public boolean isClosable() {
        return this.m_closable;
    }

    @Override
    public boolean isHtmlEnabled() {
        return this.m_htmlEnabled;
    }

    @Override
    public IDesktopNotificationUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    protected class P_UIFacade
    implements IDesktopNotificationUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void fireClosedFromUI() {
            IDesktop.CURRENT.get().getUIFacade().removedNotificationFromUI(DesktopNotification.this);
        }

        @Override
        public void fireAppLinkActionFromUI(String ref) {
            if (DesktopNotification.this.m_appLinkConsumer != null) {
                DesktopNotification.this.m_appLinkConsumer.accept(ref);
            }
        }
    }
}

