/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline;

import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.scout.rt.client.extension.ui.desktop.outline.IOutlineTableFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.desktop.outline.OutlineTableFieldChains;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutlineTableField;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.AbstractTableField;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.classid.ClassId;

@ClassId(value="f0770b37-8113-4476-a486-73ceabfdef90")
public abstract class AbstractOutlineTableField
extends AbstractTableField<ITable>
implements IOutlineTableField {
    private DesktopListener m_desktopListener;
    private PropertyChangeListener m_tablePropertyListener;

    public AbstractOutlineTableField() {
        this(true);
    }

    public AbstractOutlineTableField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected boolean getConfiguredLabelVisible() {
        return false;
    }

    @ConfigOperation
    @Order(value=1000.0)
    protected void execTableTitleChanged() {
        if (this.getTable() != null) {
            this.setLabel(this.getTable().getTitle());
        } else {
            this.setLabel(null);
        }
    }

    @Override
    protected void execInitField() {
        this.m_tablePropertyListener = e -> {
            if (e.getPropertyName().equals("title")) {
                this.interceptTableTitleChanged();
            }
        };
    }

    @Override
    protected void execDisposeField() {
        super.execDisposeField();
        ClientSessionProvider.currentSession().getDesktop().removeDesktopListener(this.m_desktopListener, new Integer[0]);
        this.m_desktopListener = null;
    }

    public void installTable(ITable table) {
        if (this.getTable() == table) {
            return;
        }
        if (this.getTable() != null) {
            this.getTable().removePropertyChangeListener(this.m_tablePropertyListener);
        }
        this.setTable(table, true);
        if (this.getTable() != null) {
            this.getTable().addPropertyChangeListener(this.m_tablePropertyListener);
        }
        this.interceptTableTitleChanged();
    }

    protected final void interceptTableTitleChanged() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        OutlineTableFieldChains.OutlineTableFieldTableTitleChangedChain chain = new OutlineTableFieldChains.OutlineTableFieldTableTitleChangedChain(extensions);
        chain.execTableTitleChanged();
    }

    @Override
    protected IOutlineTableFieldExtension<? extends AbstractOutlineTableField> createLocalExtension() {
        return new LocalOutlineTableFieldExtension<AbstractOutlineTableField>(this);
    }

    protected static class LocalOutlineTableFieldExtension<OWNER extends AbstractOutlineTableField>
    extends AbstractTableField.LocalTableFieldExtension<ITable, OWNER>
    implements IOutlineTableFieldExtension<OWNER> {
        public LocalOutlineTableFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execTableTitleChanged(OutlineTableFieldChains.OutlineTableFieldTableTitleChangedChain chain) {
            ((AbstractOutlineTableField)this.getOwner()).execTableTitleChanged();
        }
    }
}

