/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline;

import java.beans.PropertyChangeListener;
import org.eclipse.scout.rt.client.extension.ui.desktop.outline.IOutlineTreeFieldExtension;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutlineTreeField;
import org.eclipse.scout.rt.client.ui.form.fields.treefield.AbstractTreeField;
import org.eclipse.scout.rt.platform.classid.ClassId;

@ClassId(value="b04fef69-6bd2-409f-b37e-ea9e941d362d")
public abstract class AbstractOutlineTreeField
extends AbstractTreeField
implements IOutlineTreeField {
    private DesktopListener m_desktopListener;
    private PropertyChangeListener m_treePropertyListener;

    public AbstractOutlineTreeField() {
        this(true);
    }

    public AbstractOutlineTreeField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected boolean getConfiguredLabelVisible() {
        return false;
    }

    @Override
    protected void execInitField() {
        this.m_desktopListener = e -> {
            switch (e.getType()) {
                case 200: {
                    this.installOutline(e.getOutline());
                }
            }
        };
        this.m_treePropertyListener = e -> {
            if (e.getPropertyName().equals("title")) {
                this.setLabel((String)e.getNewValue());
            }
        };
        IDesktop desktop = ClientSessionProvider.currentSession().getDesktop();
        desktop.addDesktopListener(this.m_desktopListener, new Integer[0]);
        this.installOutline(desktop.getOutline());
    }

    @Override
    protected void execDisposeField() {
        ClientSessionProvider.currentSession().getDesktop().removeDesktopListener(this.m_desktopListener, new Integer[0]);
        this.m_desktopListener = null;
    }

    private void installOutline(IOutline outline) {
        if (this.getTree() == outline) {
            return;
        }
        if (this.getTree() != null) {
            this.getTree().removePropertyChangeListener(this.m_treePropertyListener);
            this.setLabel(null);
        }
        this.setTree(outline, true);
        if (this.getTree() != null) {
            this.getTree().addPropertyChangeListener(this.m_treePropertyListener);
            this.setLabel(this.getTree().getTitle());
        }
    }

    @Override
    protected IOutlineTreeFieldExtension<? extends AbstractOutlineTreeField> createLocalExtension() {
        return new LocalOutlineTreeFieldExtension<AbstractOutlineTreeField>(this);
    }

    protected static class LocalOutlineTreeFieldExtension<OWNER extends AbstractOutlineTreeField>
    extends AbstractTreeField.LocalTreeFieldExtension<OWNER>
    implements IOutlineTreeFieldExtension<OWNER> {
        public LocalOutlineTreeFieldExtension(OWNER owner) {
            super(owner);
        }
    }
}

