/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline.pages;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.scout.rt.client.extension.ui.basic.tree.ITreeNodeExtension;
import org.eclipse.scout.rt.client.extension.ui.desktop.outline.pages.IPageWithNodesExtension;
import org.eclipse.scout.rt.client.extension.ui.desktop.outline.pages.PageWithNodesChains;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TreeMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.root.IFormFieldContextMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.outline.MenuWrapper;
import org.eclipse.scout.rt.client.ui.desktop.outline.OutlineMediator;
import org.eclipse.scout.rt.client.ui.desktop.outline.OutlineMenuWrapper;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.PageReloadHandler;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;

@ClassId(value="d33a8000-e240-4ed4-9a93-44f168ec1ab8")
public abstract class AbstractPageWithNodes
extends AbstractPage<ITable>
implements IPageWithNodes {
    private static final OutlineMenuWrapper.IMenuTypeMapper TREE_MENU_TYPE_MAPPER = menuType -> {
        if (menuType == TreeMenuType.SingleSelection) {
            return TableMenuType.SingleSelection;
        }
        return menuType;
    };
    private List<? extends IMenu> m_pageMenusOfSelection;

    public AbstractPageWithNodes() {
        this(true, null);
    }

    public AbstractPageWithNodes(boolean callInitializer) {
        this(callInitializer, null);
    }

    public AbstractPageWithNodes(String userPreferenceContext) {
        this(true, userPreferenceContext);
    }

    public AbstractPageWithNodes(boolean callInitializer, String userPreferenceContext) {
        super(callInitializer, userPreferenceContext);
    }

    @ConfigOperation
    @Order(value=90.0)
    protected void execCreateChildPages(List<IPage<?>> pageList) {
    }

    protected void createChildPagesInternal(List<IPage<?>> pageList) {
        this.createDisplayParentRunContext().run(() -> this.interceptCreateChildPages(pageList));
    }

    @Override
    protected ITable createTable() {
        P_Table table = null;
        table = new P_Table();
        table.setContainerInternal(this);
        table.addTableListener(e -> {
            OutlineMediator outlineMediator = this.getOutlineMediator();
            if (outlineMediator == null) {
                return;
            }
            switch (e.getType()) {
                case 104: {
                    outlineMediator.mediateTableRowAction(e, this);
                    break;
                }
                case 740: {
                    outlineMediator.mediateTableRowDropAction(e, this);
                    break;
                }
                case 210: {
                    outlineMediator.mediateTableRowFilterChanged(this);
                    break;
                }
                case 103: {
                    this.updateContextMenusForSelection();
                }
            }
        }, new Integer[]{104, 740, 210, 103});
        table.setAutoDiscardOnDelete(true);
        table.setReloadHandler(new PageReloadHandler(this));
        return table;
    }

    @Override
    public void cellChanged(ICell cell, int changedBit) {
        super.cellChanged(cell, changedBit);
        this.updateParentTableRow(cell);
    }

    protected void updateParentTableRow(ICell cell) {
        ITableRow row;
        IPage<?> parent = this.getParentPage();
        if (parent instanceof IPageWithNodes && (row = ((IPageWithNodes)parent).getTableRowFor(this)) != null) {
            row.getCellForUpdate(0).setText(cell.getText());
        }
    }

    @Override
    protected void execPageActivated() {
        super.execPageActivated();
        if (this.getTable() != null && this.getTree() != null) {
            this.getTable().setTitle(this.getTree().getPathText(this));
        }
    }

    @Override
    protected void loadChildrenImpl() {
        ArrayList pageList = new ArrayList();
        this.createChildPagesInternal(pageList);
        ITree tree = this.getTree();
        try {
            if (tree != null) {
                tree.setTreeChanging(true);
            }
            boolean oldSelectionOwned = false;
            int oldSelectionDirectChildIndex = -1;
            ITreeNode oldSelectedNode = null;
            if (tree != null) {
                oldSelectedNode = tree.getSelectedNode();
            }
            String oldSelectedText = null;
            if (oldSelectedNode != null) {
                ITreeNode t = oldSelectedNode;
                while (t != null && t.getParentNode() != null) {
                    if (t.getParentNode() == this) {
                        oldSelectionOwned = true;
                        oldSelectedText = t.getCell().getText();
                        oldSelectionDirectChildIndex = t.getChildNodeIndex();
                        break;
                    }
                    t = t.getParentNode();
                }
            }
            this.setChildrenLoaded(false);
            this.fireBeforeDataLoaded();
            try {
                if (tree != null) {
                    tree.removeAllChildNodes(this);
                    tree.addChildNodes(this, pageList);
                }
            }
            finally {
                this.fireAfterDataLoaded();
            }
            this.setChildrenLoaded(true);
            this.setChildrenDirty(false);
            if (tree != null && oldSelectionOwned && tree.getSelectedNode() == null) {
                if (oldSelectedNode != null && oldSelectedNode.getTree() == tree) {
                    tree.selectNode(oldSelectedNode);
                } else {
                    int index = Math.max(-1, Math.min(oldSelectionDirectChildIndex, this.getChildNodeCount() - 1));
                    if (index >= 0 && index < this.getChildNodeCount() && ObjectUtility.equals((Object)oldSelectedText, (Object)this.getChildNode(index).getCell().getText())) {
                        tree.selectNode(this.getChildNode(index));
                    } else if (index >= 0 && index < this.getChildNodeCount()) {
                        tree.selectNode(this.getChildNode(index));
                    } else {
                        tree.selectNode(this);
                    }
                }
            }
        }
        finally {
            if (tree != null) {
                tree.setTreeChanging(false);
            }
        }
        try {
            this.getTable().setTableChanging(true);
            this.rebuildTableInternal();
            this.setTableStatus(null);
        }
        finally {
            this.getTable().setTableChanging(false);
        }
    }

    @Override
    public void rebuildTableInternal() {
        List<ITreeNode> childNodes = this.getChildNodes();
        try {
            this.getTable().setTableChanging(true);
            this.unlinkAllTableRowWithPage();
            this.getTable().discardAllRows();
            for (ITreeNode childNode : childNodes) {
                TableRow row = new TableRow(this.getTable().getColumnSet());
                this.updateCellFromPageCell(row.getCellForUpdate(0), childNode.getCell());
                ITableRow insertedRow = this.getTable().addRow(row);
                this.linkTableRowWithPage(insertedRow, (IPage)childNode);
            }
        }
        finally {
            this.getTable().setTableChanging(false);
        }
    }

    protected void updateCellFromPageCell(Cell tableRowCell, ICell pageCell) {
        tableRowCell.updateFrom(pageCell);
        tableRowCell.setValue(pageCell.getText());
    }

    protected void updateContextMenusForSelection() {
        ITreeNode node;
        if (this.m_pageMenusOfSelection != null) {
            this.getTable().getContextMenu().removeChildActions(this.m_pageMenusOfSelection);
            this.m_pageMenusOfSelection = null;
        }
        ArrayList<? extends IMenu> pageMenus = new ArrayList<IMenu>();
        List<ITableRow> selectedRows = this.getTable().getSelectedRows();
        if (CollectionUtility.size(selectedRows) == 1 && (node = this.getTreeNodeFor((ITableRow)CollectionUtility.firstElement(selectedRows))) instanceof IPageWithNodes) {
            IPageWithNodes pageWithNodes = (IPageWithNodes)node;
            Predicate<IAction> filter = ActionUtility.createMenuFilterMenuTypes(CollectionUtility.hashSet((Object)TreeMenuType.SingleSelection), false);
            List<IMenu> menus = ActionUtility.getActions(pageWithNodes.getMenus(), filter);
            for (IMenu m : menus) {
                pageMenus.add(MenuWrapper.wrapMenu(m, TREE_MENU_TYPE_MAPPER, filter));
            }
        }
        this.getTable().getContextMenu().addChildActions(pageMenus);
        this.m_pageMenusOfSelection = pageMenus;
    }

    @Override
    protected void decorateDetailForm() {
        super.decorateDetailForm();
        this.enhanceDetailFormWithPageMenus();
    }

    protected void enhanceDetailFormWithPageMenus() {
        if (this.getOutline() == null) {
            return;
        }
        IForm form = this.getDetailForm();
        IFormFieldContextMenu mainBoxContextMenu = form.getRootGroupBox().getContextMenu();
        List menus = mainBoxContextMenu.getChildActions();
        for (IMenu menu : this.getOutline().getMenusForPage(this)) {
            if (menu.getMenuTypes().contains(TreeMenuType.Header) && menu.getMenuTypes().size() == 1) continue;
            menus.add(MenuWrapper.wrapMenuIfNotWrapped(menu));
        }
        if (!CollectionUtility.equalsCollection(menus, mainBoxContextMenu.getChildActions())) {
            mainBoxContextMenu.setChildActions(menus);
        }
    }

    private OutlineMediator getOutlineMediator() {
        if (this.getOutline() == null) {
            return null;
        }
        return this.getOutline().getOutlineMediator();
    }

    protected final void interceptCreateChildPages(List<IPage<?>> pageList) {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        PageWithNodesChains.PageWithNodesCreateChildPagesChain chain = new PageWithNodesChains.PageWithNodesCreateChildPagesChain(extensions);
        chain.execCreateChildPages(pageList);
    }

    @Override
    protected IPageWithNodesExtension<? extends AbstractPageWithNodes> createLocalExtension() {
        return new LocalPageWithNodesExtension<AbstractPageWithNodes>(this);
    }

    protected static class LocalPageWithNodesExtension<OWNER extends AbstractPageWithNodes>
    extends AbstractPage.LocalPageExtension<OWNER>
    implements IPageWithNodesExtension<OWNER> {
        public LocalPageWithNodesExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execCreateChildPages(PageWithNodesChains.PageWithNodesCreateChildPagesChain chain, List<IPage<?>> pageList) {
            ((AbstractPageWithNodes)this.getOwner()).execCreateChildPages(pageList);
        }
    }

    @ClassId(value="d657e4bf-e2eb-44ed-9a9b-898db24ff408")
    private class P_Table
    extends AbstractTable {
        private P_Table() {
        }

        @Override
        protected boolean getConfiguredSortEnabled() {
            return false;
        }

        @Override
        protected boolean getConfiguredAutoResizeColumns() {
            return true;
        }

        @Override
        protected boolean getConfiguredMultiSelect() {
            return false;
        }

        @Override
        protected boolean getConfiguredTableStatusVisible() {
            return true;
        }

        @Override
        protected boolean getConfiguredHeaderVisible() {
            return false;
        }

        @Override
        protected void addHeaderMenus(OrderedCollection<IMenu> menus) {
        }

        public LabelColumn getLabelColumn() {
            return this.getColumnSet().getColumnByClass(LabelColumn.class);
        }

        @Order(value=1.0)
        @ClassId(value="d30cb908-98b8-4b46-ba5f-62354a9eb969")
        public class LabelColumn
        extends AbstractStringColumn {
            @Override
            protected void decorateCellInternal(Cell cell, ITableRow row) {
                IPage page = (IPage)AbstractPageWithNodes.this.getTreeNodeFor(row);
                if (page != null) {
                    page.getCellForUpdate().setText(cell.getText());
                }
            }

            @Override
            protected int getConfiguredWidth() {
                return 200;
            }
        }
    }
}

