/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form;

import org.eclipse.scout.rt.client.context.ClientRunContext;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.IDisplayParent;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.platform.ApplicationScoped;

@ApplicationScoped
public class DisplayParentResolver {
    public IDisplayParent resolve(IForm form) {
        if (form.getDisplayHint() == 20) {
            return ClientSessionProvider.currentSession().getDesktop();
        }
        return this.findClosestDisplayParent();
    }

    public IDisplayParent resolve(IMessageBox messageBox) {
        return this.findClosestDisplayParent();
    }

    public IDisplayParent resolve(IFileChooser fileChooser) {
        return this.findClosestDisplayParent();
    }

    protected IDisplayParent findClosestDisplayParent() {
        IOutline currentOutline;
        ClientRunContext currentRunContext = ClientRunContexts.copyCurrent();
        IForm currentForm = currentRunContext.getForm();
        if (currentForm != null) {
            while (currentForm.getOuterForm() != null) {
                currentForm = currentForm.getOuterForm();
            }
            if (currentForm.isFormStarted()) {
                return currentForm;
            }
        }
        if ((currentOutline = currentRunContext.getOutline()) != null) {
            return currentOutline;
        }
        return currentRunContext.getDesktop();
    }
}

