/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.clipboard;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.scout.rt.client.dto.FormData;
import org.eclipse.scout.rt.client.ui.action.keystroke.AbstractKeyStroke;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCancelButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractOkButton;
import org.eclipse.scout.rt.client.ui.form.fields.clipboardfield.AbstractClipboardField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.labelfield.AbstractLabelField;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.resource.MimeType;
import org.eclipse.scout.rt.platform.text.TEXTS;

@ClassId(value="5aaf757b-4a82-4ffb-bc7e-05f4e5cc1964")
@FormData(sdkCommand=FormData.SdkCommand.IGNORE, defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
public class ClipboardForm
extends AbstractForm {
    private MimeType[] m_mimeTypes;

    public ClipboardForm() {
        this(true);
    }

    protected ClipboardForm(boolean callInitializer) {
        super(callInitializer);
    }

    public MimeType[] getMimeTypes() {
        return this.m_mimeTypes;
    }

    public void setMimeTypes(MimeType ... mimeTypes) {
        this.m_mimeTypes = mimeTypes;
        ArrayList<String> allowedMimeTypesListAsString = new ArrayList<String>();
        if (mimeTypes != null) {
            MimeType[] mimeTypeArray = mimeTypes;
            int n = mimeTypes.length;
            int n2 = 0;
            while (n2 < n) {
                MimeType mimeType = mimeTypeArray[n2];
                allowedMimeTypesListAsString.add(mimeType.getType());
                ++n2;
            }
        }
        this.getClipboardField().setAllowedMimeTypes(allowedMimeTypesListAsString);
    }

    protected void checkOkButtonEnabled() {
        boolean okButtonEnabled = this.getHandler() instanceof CopyHandler || this.getClipboardField().getValue() != null && !((Collection)this.getClipboardField().getValue()).isEmpty();
        this.getOkButton().setEnabled(okButtonEnabled, true, false);
    }

    @Override
    protected String getConfiguredTitle() {
        return TEXTS.get((String)"Clipboard");
    }

    public void startCopy() {
        this.setHandler(new CopyHandler());
        this.start();
    }

    public void startPaste() {
        this.setHandler(new PasteHandler());
        this.start();
    }

    public MainBox.ClipboardLabel getClipboardLabel() {
        return this.getFieldByClass(MainBox.ClipboardLabel.class);
    }

    public MainBox.ClipboardField getClipboardField() {
        return this.getFieldByClass(MainBox.ClipboardField.class);
    }

    public MainBox.OkButton getOkButton() {
        return this.getFieldByClass(MainBox.OkButton.class);
    }

    public MainBox.CancelButton getCancelButton() {
        return this.getFieldByClass(MainBox.CancelButton.class);
    }

    public class CopyHandler
    extends AbstractFormHandler {
        @Override
        protected void execLoad() {
            super.execLoad();
            ClipboardForm.this.getClipboardLabel().setValue(TEXTS.get((String)"CopyToClipboardFromFieldBelow"));
            ClipboardForm.this.getCancelButton().setVisibleGranted(false);
            ClipboardForm.this.checkOkButtonEnabled();
            ClipboardForm.this.getClipboardField().setReadOnly(true);
        }
    }

    @ClassId(value="520d5971-438b-4b81-8ca3-6201f0181b27")
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected int getConfiguredGridColumnCount() {
            return 1;
        }

        @Override
        protected String getConfiguredBorderDecoration() {
            return "empty";
        }

        @Order(value=40.0)
        @ClassId(value="a54fc3fc-ee5a-4351-b82f-3168e96c2f34")
        public class CancelButton
        extends AbstractCancelButton {
        }

        @Order(value=20.0)
        @ClassId(value="5c81521d-f16d-411a-85f1-c349d8b71a28")
        public class ClipboardField
        extends AbstractClipboardField {
            @Override
            protected int getConfiguredHeightInPixel() {
                return 190;
            }

            @Override
            protected int getConfiguredWidthInPixel() {
                return 705;
            }

            @Override
            protected double getConfiguredGridWeightX() {
                return 1.0;
            }

            @Override
            protected double getConfiguredGridWeightY() {
                return 1.0;
            }

            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected boolean getConfiguredStatusVisible() {
                return false;
            }

            @Override
            protected String getConfiguredFieldStyle() {
                return "classic";
            }

            @Override
            protected void execChangedValue() {
                ClipboardForm.this.checkOkButtonEnabled();
            }
        }

        @Order(value=10.0)
        @ClassId(value="7f2f4401-7bc8-45aa-9cf5-e23129aafd44")
        public class ClipboardLabel
        extends AbstractLabelField {
            @Override
            protected String getConfiguredCssClass() {
                return "clipboard-form-label";
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }

            @Override
            protected boolean getConfiguredStatusVisible() {
                return false;
            }

            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Override
            protected boolean getConfiguredWrapText() {
                return true;
            }
        }

        @Order(value=50.0)
        @ClassId(value="18fc9914-495f-4523-b75c-41259de828db")
        public class EscapeKeyStroke
        extends AbstractKeyStroke {
            @Override
            protected String getConfiguredKeyStroke() {
                return "escape";
            }

            @Override
            protected void execAction() {
                ClipboardForm.this.doClose();
            }
        }

        @Order(value=30.0)
        @ClassId(value="818d7930-126e-481e-ac47-b7e8654e8060")
        public class OkButton
        extends AbstractOkButton {
        }
    }

    public class PasteHandler
    extends AbstractFormHandler {
        @Override
        protected void execLoad() {
            super.execLoad();
            ClipboardForm.this.getClipboardLabel().setValue(TEXTS.get((String)"PasteClipboardContentsInFieldBelow"));
            ClipboardForm.this.checkOkButtonEnabled();
        }
    }
}

