/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields;

import java.util.List;
import org.eclipse.scout.rt.client.extension.ui.form.fields.BasicFieldChains;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IBasicFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.IBasicField;
import org.eclipse.scout.rt.client.ui.form.fields.IBasicFieldUIFacade;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

@ClassId(value="d5a72dd8-cb1c-4dea-a568-90d77e65854e")
public abstract class AbstractBasicField<VALUE>
extends AbstractValueField<VALUE>
implements IBasicField<VALUE> {
    protected AbstractBasicField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected IBasicFieldExtension<VALUE, ? extends AbstractBasicField<VALUE>> createLocalExtension() {
        return new LocalBasicFieldExtension(this);
    }

    @ConfigOperation
    @Order(value=225.0)
    protected void execChangedDisplayText() {
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setUpdateDisplayTextOnModify(this.getConfiguredUpdateDisplayTextOnModify());
        this.setUpdateDisplayTextOnModifyDelay(this.getConfiguredUpdateDisplayTextOnModifyDelay());
    }

    @Override
    public void setDisplayText(String s) {
        String oldDisplayText = this.getDisplayText();
        super.setDisplayText(s);
        if (ObjectUtility.notEquals((Object)oldDisplayText, (Object)s)) {
            this.interceptExecChangedDisplayText();
        }
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=315.0)
    protected boolean getConfiguredUpdateDisplayTextOnModify() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=320.0)
    protected int getConfiguredUpdateDisplayTextOnModifyDelay() {
        return 250;
    }

    @Override
    public void setUpdateDisplayTextOnModify(boolean update) {
        this.propertySupport.setPropertyBool("updateDisplayTextOnModify", update);
    }

    @Override
    public boolean isUpdateDisplayTextOnModify() {
        return this.propertySupport.getPropertyBool("updateDisplayTextOnModify");
    }

    @Override
    public void setUpdateDisplayTextOnModifyDelay(int delay) {
        this.propertySupport.setPropertyInt("updateDisplayTextOnModifyDelay", delay);
    }

    @Override
    public int getUpdateDisplayTextOnModifyDelay() {
        return this.propertySupport.getPropertyInt("updateDisplayTextOnModifyDelay");
    }

    protected final void interceptExecChangedDisplayText() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        new BasicFieldChains.BasicFieldExecChangedDisplayTextChain(extensions).execChangedDisplayText();
    }

    protected static class LocalBasicFieldExtension<VALUE_TYPE, OWNER_FIELD extends AbstractBasicField<VALUE_TYPE>>
    extends AbstractValueField.LocalValueFieldExtension<VALUE_TYPE, OWNER_FIELD>
    implements IBasicFieldExtension<VALUE_TYPE, OWNER_FIELD> {
        public LocalBasicFieldExtension(OWNER_FIELD owner) {
            super(owner);
        }

        @Override
        public void execChangedDisplayText(BasicFieldChains.BasicFieldExecChangedDisplayTextChain<VALUE_TYPE> chain) {
            ((AbstractBasicField)this.getOwner()).execChangedDisplayText();
        }
    }

    public class P_UIFacade
    implements IBasicFieldUIFacade {
        @Override
        public void setDisplayTextFromUI(String text) {
            if (!AbstractBasicField.this.isEnabledIncludingParents() || !AbstractBasicField.this.isVisibleIncludingParents()) {
                return;
            }
            AbstractBasicField.this.setDisplayText(text);
        }

        @Override
        public void parseAndSetValueFromUI(String value) {
            if (!AbstractBasicField.this.isEnabledIncludingParents() || !AbstractBasicField.this.isVisibleIncludingParents()) {
                return;
            }
            if (value == null) {
                value = "";
            }
            AbstractBasicField.this.parseAndSetValue(value);
        }
    }
}

