/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.form.FormUtility;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.platform.OrderedComparator;
import org.eclipse.scout.rt.platform.holders.Holder;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;

public final class CompositeFieldUtility {
    private CompositeFieldUtility() {
    }

    public static void addField(IFormField f, ICompositeField compositeField, List<IFormField> fields) {
        Assertions.assertNotNull((Object)f);
        Assertions.assertNotNull((Object)compositeField);
        Assertions.assertNotNull(fields);
        Assertions.assertNull((Object)f.getParentField(), (String)"field is already contained in '{}'.", (Object[])new Object[]{f.getParentField()});
        Assertions.assertTrue((f.getForm() == null || f.getForm() == compositeField.getForm() ? 1 : 0) != 0, (String)"field is part of a different form,  '{}' instead of '{}'", (Object[])new Object[]{f.getForm(), compositeField.getForm()});
        fields.add(f);
        fields.sort((Comparator<IFormField>)new OrderedComparator());
        CompositeFieldUtility.connectFields(f, compositeField);
        if (compositeField.isInitConfigDone()) {
            f.init();
            FormUtility.rebuildFieldGrid(compositeField);
        }
    }

    public static void connectFields(IFormField child, ICompositeField parent) {
        if (parent == null) {
            child.setParentInternal(null);
            return;
        }
        Assertions.assertNull((Object)child.getParentField());
        child.setParentInternal(parent);
        IForm formOfParentField = parent.getForm();
        IForm formOfChildField = child.getForm();
        if (formOfChildField == formOfParentField) {
            return;
        }
        child.setFormInternal(formOfParentField);
    }

    public static void removeField(IFormField f, ICompositeField compositeField, List<IFormField> fields) {
        Assertions.assertNotNull(fields);
        Assertions.assertNotNull((Object)f, (String)"field must not be null", (Object[])new Object[0]);
        boolean removed = fields.remove(f);
        Assertions.assertTrue((boolean)removed, (String)"field is not part of container '{}'.", (Object[])new Object[]{compositeField});
        CompositeFieldUtility.connectFields(f, null);
        if (f.isInitConfigDone()) {
            f.dispose();
        }
    }

    public static void moveFieldTo(IFormField f, ICompositeField oldContainer, ICompositeField newContainer, Map<Class<? extends IFormField>, IFormField> movedFormFieldsByClass) {
        Assertions.assertNotNull((Object)f, (String)"field must not be null", (Object[])new Object[0]);
        Assertions.assertNotNull((Object)oldContainer, (String)"old container must not be null", (Object[])new Object[0]);
        Assertions.assertNotNull((Object)newContainer, (String)"new container must not be null", (Object[])new Object[0]);
        oldContainer.removeField(f);
        newContainer.addField(f);
        movedFormFieldsByClass.put(f.getClass(), f);
    }

    @Deprecated
    public static <T extends IWidget> T getWidgetByClass(IWidget widget, Class<T> classToFind) {
        return widget.getWidgetByClass(classToFind);
    }

    public static <T extends IWidget> TreeVisitResult getWidgetByClassInternal(IWidget widget, Holder<T> result, Class<T> classToFind) {
        if (widget.getClass() == classToFind) {
            result.setValue((Object)((IWidget)classToFind.cast(widget)));
        } else {
            T movedFieldByClass = CompositeFieldUtility.getMovedFieldByClassIfComposite(widget, classToFind);
            if (movedFieldByClass != null) {
                result.setValue(movedFieldByClass);
            }
        }
        return result.getValue() == null ? TreeVisitResult.CONTINUE : TreeVisitResult.TERMINATE;
    }

    private static <T extends IWidget> T getMovedFieldByClassIfComposite(IWidget widget, Class<T> classToFind) {
        if (!(widget instanceof ICompositeField)) {
            return null;
        }
        return CompositeFieldUtility.getMovedFieldByClass((ICompositeField)widget, classToFind);
    }

    private static <T extends IWidget> T getMovedFieldByClass(ICompositeField compositeField, Class<T> formFieldClass) {
        Map<Class<? extends IFormField>, IFormField> movedFields = compositeField.getMovedFields();
        IFormField f = movedFields.get(formFieldClass);
        return (T)((IWidget)formFieldClass.cast(f));
    }

    public static IFormField getFieldById(ICompositeField compositeField, String id) {
        return CompositeFieldUtility.getFieldById(compositeField, id, IFormField.class);
    }

    public static <T extends IFormField> T getFieldById(ICompositeField compositeField, String id, Class<T> type) {
        T movedField = CompositeFieldUtility.getMovedFieldById(compositeField, id, type);
        if (movedField != null) {
            return movedField;
        }
        Holder found = new Holder(type);
        Function<IFormField, TreeVisitResult> v = field -> {
            Object movedFieldById;
            if (type.isAssignableFrom(field.getClass()) && field.getFieldId().equals(id)) {
                found.setValue((Object)((IFormField)type.cast(field)));
            } else if (field instanceof ICompositeField && (movedFieldById = CompositeFieldUtility.getMovedFieldById((ICompositeField)field, id, type)) != null) {
                found.setValue(movedFieldById);
            }
            return found.getValue() == null ? TreeVisitResult.CONTINUE : TreeVisitResult.TERMINATE;
        };
        compositeField.visit(v, IFormField.class);
        return (T)((IFormField)found.getValue());
    }

    private static <T extends IFormField> T getMovedFieldById(ICompositeField compositeField, String id, Class<T> type) {
        Collection<IFormField> movedFields = compositeField.getMovedFields().values();
        for (IFormField f : movedFields) {
            if (!type.isAssignableFrom(f.getClass()) || !f.getFieldId().equals(id)) continue;
            return (T)((IFormField)type.cast(f));
        }
        return null;
    }
}

