/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields;

import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValidateContentDescriptor;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.client.ui.form.fields.wrappedform.IWrappedFormField;
import org.eclipse.scout.rt.platform.status.IStatus;

public class ValidateFormFieldDescriptor
implements IValidateContentDescriptor {
    private final IFormField m_field;
    private final IStatus m_errorStatus;

    public ValidateFormFieldDescriptor(IFormField field) {
        this.m_field = field;
        this.m_errorStatus = field.getErrorStatus();
    }

    @Override
    public String getDisplayText() {
        return this.m_field.getFullyQualifiedLabel(": ");
    }

    @Override
    public IStatus getErrorStatus() {
        return this.m_errorStatus;
    }

    @Override
    public void activateProblemLocation() {
        IGroupBox groupBox = this.m_field.getParentGroupBox();
        IForm form = this.m_field.getForm();
        while (groupBox != null) {
            IWrappedFormField outerFormField;
            ITabBox t;
            if (groupBox.getParentField() instanceof ITabBox && (t = (ITabBox)groupBox.getParentField()).getSelectedTab() != groupBox) {
                t.setSelectedTab(groupBox);
            }
            if ((groupBox = groupBox.getParentGroupBox()) != null || (outerFormField = form.getOuterFormField()) == null) continue;
            groupBox = outerFormField.getParentGroupBox();
            form = outerFormField.getForm();
        }
        this.m_field.requestFocus();
    }
}

