/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.button;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.action.tree.MoveActionNodesHandler;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.button.ButtonChains;
import org.eclipse.scout.rt.client.extension.ui.form.fields.button.IButtonExtension;
import org.eclipse.scout.rt.client.res.AttachmentSupport;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.FormFieldContextMenu;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.ButtonEvent;
import org.eclipse.scout.rt.client.ui.form.fields.button.ButtonListener;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButtonUIFacade;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;
import org.eclipse.scout.rt.platform.util.concurrent.OptimisticLock;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;

@ClassId(value="998788cf-df0f-480b-bd5a-5037805610c9")
public abstract class AbstractButton
extends AbstractFormField
implements IButton {
    private final FastListenerList<ButtonListener> m_listenerList = new FastListenerList();
    private final IButtonUIFacade m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
    private final OptimisticLock m_uiFacadeSetSelectedLock = new OptimisticLock();
    private int m_systemType;
    private int m_displayStyle;
    private boolean m_processButton;
    private AttachmentSupport m_attachmentSupport = (AttachmentSupport)BEANS.get(AttachmentSupport.class);

    public AbstractButton() {
        this(true);
    }

    public AbstractButton(boolean callInitializer) {
        super(false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @ConfigProperty(value="BUTTON_SYSTEM_TYPE")
    @Order(value=200.0)
    protected int getConfiguredSystemType() {
        return 0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=220.0)
    protected boolean getConfiguredProcessButton() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=225.0)
    protected Boolean getConfiguredDefaultButton() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=230.0)
    protected String getConfiguredKeyStroke() {
        return null;
    }

    @Order(value=240.0)
    protected Class<? extends IFormField> getConfiguredKeyStrokeScopeClass() {
        return null;
    }

    @ConfigProperty(value="BUTTON_DISPLAY_STYLE")
    @Order(value=210.0)
    protected int getConfiguredDisplayStyle() {
        return 0;
    }

    @Override
    protected boolean getConfiguredFillHorizontal() {
        return false;
    }

    @Override
    protected boolean getConfiguredGridUseUiWidth() {
        return false;
    }

    @Override
    protected boolean getConfiguredGridUseUiHeight() {
        return false;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=190.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @Override
    protected boolean getConfiguredStatusVisible() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=200.0)
    protected boolean getConfiguredPreventDoubleClick() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=210.0)
    protected boolean getConfiguredStackable() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=220.0)
    protected boolean getConfiguredShrinkable() {
        return false;
    }

    @ConfigOperation
    @Order(value=190.0)
    protected void execClickAction() {
    }

    @ConfigOperation
    @Order(value=210.0)
    protected void execSelectionChanged(boolean selection) {
    }

    protected List<Class<? extends IMenu>> getDeclaredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List menuClasses = ConfigurationUtility.filterClasses((Class[])dca, IMenu.class);
        List a = ConfigurationUtility.removeReplacedClasses((List)menuClasses);
        return a;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        int systemType = this.getConfiguredSystemType();
        this.setSystemType(systemType);
        this.setInheritAccessibility(this.getConfiguredInheritAccessibility() && systemType != 1 && systemType != 2);
        this.setDisplayStyleInternal(this.getConfiguredDisplayStyle());
        this.setProcessButton(this.getConfiguredProcessButton());
        this.setDefaultButton(this.getConfiguredDefaultButton());
        this.setIconId(this.getConfiguredIconId());
        this.setKeyStroke(this.getConfiguredKeyStroke());
        this.setKeyStrokeScopeClass(this.getConfiguredKeyStrokeScopeClass());
        this.setPreventDoubleClick(this.getConfiguredPreventDoubleClick());
        this.setStackable(this.getConfiguredStackable());
        this.setShrinkable(this.getConfiguredShrinkable());
        List<Class<? extends IMenu>> declaredMenus = this.getDeclaredMenus();
        List contributedMenus = this.m_contributionHolder.getContributionsByClass(IMenu.class);
        OrderedCollection menus = new OrderedCollection();
        for (Class<? extends IMenu> menuClazz : declaredMenus) {
            IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, menuClazz);
            menus.addOrdered((IOrdered)menu);
        }
        menus.addAllOrdered((Collection)contributedMenus);
        this.injectMenusInternal((OrderedCollection<IMenu>)menus);
        new MoveActionNodesHandler(menus).moveModelObjects();
        this.setContextMenu(new FormFieldContextMenu<AbstractButton>(this, menus.getOrderedList()));
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), this.getMenus()});
    }

    protected void injectMenusInternal(OrderedCollection<IMenu> menus) {
    }

    @Override
    public String getIconId() {
        return this.propertySupport.getPropertyString("iconId");
    }

    @Override
    public void setIconId(String iconId) {
        this.propertySupport.setPropertyString("iconId", iconId);
    }

    private Class<? extends IFormField> getKeyStrokeScopeClass() {
        return (Class)this.propertySupport.getProperty("keyStrokeScopeClass");
    }

    @Override
    public IFormField getKeyStrokeScope() {
        if (this.getKeyStrokeScopeClass() != null) {
            return this.getForm().getFieldByClass(this.getKeyStrokeScopeClass());
        }
        return null;
    }

    private void setKeyStrokeScopeClass(Class<? extends IFormField> scope) {
        this.propertySupport.setProperty("keyStrokeScopeClass", scope);
    }

    @Override
    public String getKeyStroke() {
        return this.propertySupport.getPropertyString("keyStroke");
    }

    @Override
    public void setKeyStroke(String keyStroke) {
        this.propertySupport.setPropertyString("keyStroke", keyStroke);
    }

    @Override
    public int getSystemType() {
        return this.m_systemType;
    }

    @Override
    public void setSystemType(int systemType) {
        this.m_systemType = systemType;
    }

    @Override
    public boolean isProcessButton() {
        return this.m_processButton;
    }

    @Override
    public void setProcessButton(boolean on) {
        this.m_processButton = on;
    }

    @Override
    public Boolean getDefaultButton() {
        return (Boolean)this.propertySupport.getProperty("defaultButton");
    }

    @Override
    public void setDefaultButton(Boolean defaultButton) {
        this.propertySupport.setProperty("defaultButton", (Object)defaultButton);
    }

    @Override
    public List<IMenu> getMenus() {
        return this.getContextMenu().getChildActions();
    }

    protected void setContextMenu(IContextMenu contextMenu) {
        this.propertySupport.setProperty("contextMenu", (Object)contextMenu);
    }

    @Override
    public <T extends IMenu> T getMenuByClass(Class<T> menuType) {
        return MenuUtility.getMenuByClass(this, menuType);
    }

    @Override
    public IContextMenu getContextMenu() {
        return (IContextMenu)this.propertySupport.getProperty("contextMenu");
    }

    @Override
    public void doClick() {
        if (this.isEnabled() && this.isVisible()) {
            this.fireButtonClicked();
            this.interceptClickAction();
        }
    }

    @Override
    public boolean isSelected() {
        return this.propertySupport.getPropertyBool("selected");
    }

    @Override
    public void setSelected(boolean b) {
        boolean changed = this.propertySupport.setPropertyBool("selected", b);
        if (changed) {
            try {
                this.interceptSelectionChanged(b);
            }
            catch (RuntimeException | PlatformError e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(e);
            }
        }
    }

    @Override
    public boolean isPreventDoubleClick() {
        return this.propertySupport.getPropertyBool("preventDoubleClick");
    }

    @Override
    public void setPreventDoubleClick(boolean preventDoubleClick) {
        this.propertySupport.setPropertyBool("preventDoubleClick", preventDoubleClick);
    }

    @Override
    public boolean isStackable() {
        return this.propertySupport.getPropertyBool("stackable");
    }

    @Override
    public void setStackable(boolean stackable) {
        this.propertySupport.setPropertyBool("stackable", stackable);
    }

    @Override
    public boolean isShrinkable() {
        return this.propertySupport.getPropertyBool("shrinkable");
    }

    @Override
    public void setShrinkable(boolean shrinkable) {
        this.propertySupport.setPropertyBool("shrinkable", shrinkable);
    }

    @Override
    public void requestPopup() {
        this.fireRequestPopup();
    }

    @Override
    public int getDisplayStyle() {
        return this.m_displayStyle;
    }

    @Override
    public void setDisplayStyleInternal(int i) {
        this.m_displayStyle = i;
    }

    @Override
    public IButtonUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public IFastListenerList<ButtonListener> buttonListeners() {
        return this.m_listenerList;
    }

    private void fireButtonClicked() {
        this.fireButtonEvent(new ButtonEvent(this, 1));
    }

    private void fireRequestPopup() {
        this.fireButtonEvent(new ButtonEvent(this, 4));
    }

    private void fireButtonEvent(ButtonEvent e) {
        this.buttonListeners().list().forEach(listener -> listener.buttonChanged(e));
    }

    @Override
    public void setView(boolean visible, boolean enabled) {
        this.setVisible(visible);
        this.setEnabled(enabled);
    }

    @Override
    public Set<BinaryResource> getAttachments() {
        return this.m_attachmentSupport.getAttachments();
    }

    @Override
    public BinaryResource getAttachment(String filename) {
        return this.m_attachmentSupport.getAttachment(filename);
    }

    @Override
    public void setAttachments(Collection<? extends BinaryResource> attachments) {
        this.m_attachmentSupport.setAttachments(attachments);
    }

    protected final void interceptSelectionChanged(boolean selection) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ButtonChains.ButtonSelectionChangedChain chain = new ButtonChains.ButtonSelectionChangedChain(extensions);
        chain.execSelectionChanged(selection);
    }

    protected final void interceptClickAction() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ButtonChains.ButtonClickActionChain chain = new ButtonChains.ButtonClickActionChain(extensions);
        chain.execClickAction();
    }

    protected IButtonExtension<? extends AbstractButton> createLocalExtension() {
        return new LocalButtonExtension<AbstractButton>(this);
    }

    protected static class LocalButtonExtension<OWNER extends AbstractButton>
    extends AbstractFormField.LocalFormFieldExtension<OWNER>
    implements IButtonExtension<OWNER> {
        public LocalButtonExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execSelectionChanged(ButtonChains.ButtonSelectionChangedChain chain, boolean selection) {
            ((AbstractButton)this.getOwner()).execSelectionChanged(selection);
        }

        @Override
        public void execClickAction(ButtonChains.ButtonClickActionChain chain) {
            ((AbstractButton)this.getOwner()).execClickAction();
        }
    }

    protected class P_UIFacade
    implements IButtonUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void fireButtonClickFromUI() {
            if (AbstractButton.this.isEnabledIncludingParents() && AbstractButton.this.isVisibleIncludingParents()) {
                AbstractButton.this.doClick();
            }
        }

        @Override
        public void setSelectedFromUI(boolean b) {
            if (AbstractButton.this.isEnabled() && AbstractButton.this.isVisible() && AbstractButton.this.m_uiFacadeSetSelectedLock.acquire()) {
                try {
                    AbstractButton.this.setSelected(b);
                }
                finally {
                    AbstractButton.this.m_uiFacadeSetSelectedLock.release();
                }
            }
        }
    }
}

