/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="d7a38deb-3d92-4bf2-853c-d3fda0219b7f")
public class DataModelAggregationLookupCall
extends LocalLookupCall<Integer> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DataModelAggregationLookupCall.class);
    private IDataModelAttribute m_attribute;
    private List<ILookupRow<Integer>> m_lookupRows;

    public void setAttribute(IDataModelAttribute attribute) {
        if (this.m_attribute != attribute) {
            this.m_attribute = attribute;
            try {
                this.updateLookupRows();
            }
            catch (Exception t) {
                LOG.error("Failed updating aggregation lookup rows for attribute {}", (Object)attribute);
                this.m_lookupRows = CollectionUtility.emptyArrayList();
            }
        }
    }

    public IDataModelAttribute getAttribute() {
        return this.m_attribute;
    }

    protected void updateLookupRows() {
        ArrayList<ILookupRow<Integer>> result = new ArrayList<ILookupRow<Integer>>();
        int[] ags = null;
        if (this.m_attribute != null) {
            if (this.m_attribute.getType() != 17) {
                result.add((ILookupRow<Integer>)new LookupRow((Object)0, this.m_attribute.getText()));
            }
            if ((ags = this.m_attribute.getAggregationTypes()) != null && ags.length > 0) {
                int[] nArray = ags;
                int n = ags.length;
                int n2 = 0;
                while (n2 < n) {
                    int ag = nArray[n2];
                    String text = null;
                    switch (ag) {
                        case 5: {
                            text = TEXTS.get((String)"ComposerFieldAggregationAvg", (String[])new String[]{this.m_attribute.getText()});
                            break;
                        }
                        case 1: {
                            if (this.m_attribute.getType() == 17) {
                                text = this.m_attribute.getText();
                                break;
                            }
                            text = TEXTS.get((String)"ComposerFieldAggregationCount", (String[])new String[]{this.m_attribute.getText()});
                            break;
                        }
                        case 4: {
                            text = TEXTS.get((String)"ComposerFieldAggregationMax", (String[])new String[]{this.m_attribute.getText()});
                            break;
                        }
                        case 6: {
                            text = TEXTS.get((String)"ComposerFieldAggregationMedian", (String[])new String[]{this.m_attribute.getText()});
                            break;
                        }
                        case 3: {
                            text = TEXTS.get((String)"ComposerFieldAggregationMin", (String[])new String[]{this.m_attribute.getText()});
                            break;
                        }
                        case 2: {
                            text = TEXTS.get((String)"ComposerFieldAggregationSum", (String[])new String[]{this.m_attribute.getText()});
                        }
                    }
                    result.add((ILookupRow<Integer>)new LookupRow((Object)ag, text));
                    ++n2;
                }
            }
        }
        this.m_lookupRows = result;
    }

    public List<ILookupRow<Integer>> getLookupRows() {
        return this.m_lookupRows;
    }

    protected List<ILookupRow<Integer>> execCreateLookupRows() {
        if (this.m_lookupRows != null) {
            return this.m_lookupRows;
        }
        return CollectionUtility.emptyArrayList();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.m_attribute == null ? 0 : this.m_attribute.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DataModelAggregationLookupCall other = (DataModelAggregationLookupCall)((Object)obj);
        return !(this.m_attribute == null ? other.m_attribute != null : !this.m_attribute.equals(other.m_attribute));
    }
}

