/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttributeOp;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

@ClassId(value="5692346e-a059-45ff-a287-781319c00d6a")
public class DataModelOperatorLookupCall
extends LocalLookupCall<IDataModelAttributeOp> {
    private static final long serialVersionUID = 1L;
    private IDataModelAttribute m_attribute;

    public void setAttribute(IDataModelAttribute attribute) {
        this.m_attribute = attribute;
    }

    public IDataModelAttribute getAttribute() {
        return this.m_attribute;
    }

    protected List<ILookupRow<IDataModelAttributeOp>> execCreateLookupRows() {
        ArrayList<ILookupRow<IDataModelAttributeOp>> result = new ArrayList<ILookupRow<IDataModelAttributeOp>>();
        List ops = null;
        if (this.m_attribute != null) {
            ops = this.m_attribute.getOperators();
        }
        if (ops != null) {
            for (IDataModelAttributeOp op : ops) {
                String text = op.getShortText();
                if (text != null && text.contains("{0}")) {
                    text = text.replace("{0}", "n");
                }
                if (text != null && text.contains("{1}")) {
                    text = text.replace("{1}", "m");
                }
                result.add((ILookupRow<IDataModelAttributeOp>)new LookupRow((Object)op, text));
            }
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.m_attribute == null ? 0 : this.m_attribute.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DataModelOperatorLookupCall other = (DataModelOperatorLookupCall)((Object)obj);
        return !(this.m_attribute == null ? other.m_attribute != null : !this.m_attribute.equals(other.m_attribute));
    }
}

