/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer.node;

import java.util.List;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.internal.ComposerAttributeForm;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AbstractComposerNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EntityNode;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttributeOp;

public class AttributeNode
extends AbstractComposerNode {
    private IDataModelAttribute m_attribute;
    private Integer m_aggregationType;
    private IDataModelAttributeOp m_op;
    private List<Object> m_values;
    private List<String> m_texts;

    public AttributeNode(IComposerField composerField, IDataModelAttribute attrbiute) {
        super(composerField, false);
        this.m_attribute = attrbiute;
        this.callInitializer();
    }

    @Override
    protected void execDecorateCell(Cell cell) {
        int dataType = 0;
        if (this.m_op != null) {
            dataType = this.m_op.getType();
        }
        if (dataType == -1 && this.m_attribute != null) {
            dataType = this.m_attribute.getType();
        }
        String prefix = "";
        if (this.getSiblingBefore() != null) {
            prefix = String.valueOf(TEXTS.get((String)"ExtendedSearchAnd")) + " ";
        }
        if (this.m_op != null && this.m_attribute != null) {
            if (this.m_attribute.getType() == 17) {
                cell.setText(String.valueOf(prefix) + this.m_op.createVerboseText(null, this.m_attribute.getText(), this.m_texts));
            } else {
                cell.setText(String.valueOf(prefix) + this.m_op.createVerboseText(this.getAggregationType(), this.m_attribute.getText(), this.m_texts));
            }
        } else if (this.m_attribute != null) {
            cell.setText(String.valueOf(prefix) + this.m_attribute.getText());
        }
    }

    public List<Object> getValues() {
        return CollectionUtility.arrayList(this.m_values);
    }

    public void setValues(List<?> values) {
        this.m_values = CollectionUtility.arrayList(values);
    }

    public List<String> getTexts() {
        return CollectionUtility.arrayList(this.m_texts);
    }

    public void setTexts(List<String> s) {
        this.m_texts = CollectionUtility.arrayListWithoutNullElements(s);
    }

    public IDataModelAttribute getAttribute() {
        return this.m_attribute;
    }

    public void setAttribute(IDataModelAttribute a) {
        this.m_attribute = a;
    }

    public IDataModelAttributeOp getOp() {
        return this.m_op;
    }

    public void setOp(IDataModelAttributeOp op) {
        this.m_op = op;
    }

    public Integer getAggregationType() {
        return this.m_aggregationType;
    }

    public void setAggregationType(Integer a) {
        if (a != null && a == 0) {
            a = null;
        }
        this.m_aggregationType = a;
    }

    @Order(value=3.0)
    @ClassId(value="24139c45-1e06-4967-a27f-7d4c457d9b30")
    public class DeleteAttributeMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return TEXTS.get((String)"ExtendedSearchRemoveAttributeMenu");
        }

        @Override
        protected String getConfiguredKeyStroke() {
            return "delete";
        }

        @Override
        protected void execAction() {
            AttributeNode.this.getTree().selectPreviousParentNode();
            AttributeNode.this.getTree().removeNode(AttributeNode.this);
        }
    }

    @Order(value=1.0)
    @ClassId(value="fb5120e5-26be-426d-a589-7e88a5c577f0")
    public class EditAttributeMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return TEXTS.get((String)"ExtendedSearchEditAttributeMenu");
        }

        @Override
        protected void execAction() {
            ComposerAttributeForm form = new ComposerAttributeForm();
            ITreeNode parentEntity = AttributeNode.this.findParentNode(EntityNode.class);
            if (parentEntity != null) {
                form.setAvailableAttributes(((EntityNode)parentEntity).getEntity().getAttributes());
            } else {
                form.setAvailableAttributes(AttributeNode.this.getComposerField().getAttributes());
            }
            form.setSelectedAttribute(AttributeNode.this.getAttribute());
            form.setSelectedOp(AttributeNode.this.getOp());
            form.setSelectedValues(AttributeNode.this.getValues());
            form.setSelectedDisplayValues(AttributeNode.this.getTexts());
            form.startModify();
            form.waitFor();
            if (form.isFormStored()) {
                AttributeNode.this.setAttribute(form.getSelectedAttribute());
                AttributeNode.this.setOp(form.getSelectedOp());
                AttributeNode.this.setValues(form.getSelectedValues());
                AttributeNode.this.setTexts(form.getSelectedDisplayValues());
                if (!AttributeNode.this.isStatusInserted()) {
                    AttributeNode.this.setStatusInternal(2);
                }
                AttributeNode.this.update();
            }
        }
    }
}

