/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenuSeparator;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AbstractAddAttributeMenu;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AbstractComposerNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EitherOrNode;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;

public class EntityNode
extends AbstractComposerNode {
    private IDataModelEntity m_entity;
    private boolean m_negated = false;
    private List<Object> m_values;
    private List<String> m_texts;

    public EntityNode(IComposerField composerField, IDataModelEntity entity) {
        super(composerField, false);
        this.m_entity = entity;
        this.callInitializer();
    }

    @Override
    protected void execInitTreeNode() {
        ArrayList<IMenu> menus = new ArrayList<IMenu>();
        for (IMenu m : this.getMenus()) {
            if (m.getClass() == AddEntityPlaceholderOnEntityMenu.class) {
                this.attachAddEntityMenus(menus);
                continue;
            }
            menus.add(m);
        }
        if (!menus.isEmpty() && ((IMenu)menus.get(menus.size() - 1)).getClass() == Separator2Menu.class) {
            menus.remove(menus.size() - 1);
        }
        this.setMenus(menus);
    }

    @Override
    protected void execDecorateCell(Cell cell) {
        StringBuilder label = new StringBuilder();
        if (this.getSiblingBefore() != null) {
            label.append(TEXTS.get((String)"ExtendedSearchAnd")).append(" ");
        }
        if (this.isNegative()) {
            label.append(TEXTS.get((String)"ExtendedSearchNot")).append(" ");
        }
        label.append(this.m_entity.getText());
        if (this.getChildNodeCount() > 0) {
            label.append(" ").append(TEXTS.get((String)"ExtendedSearchEntitySuffix"));
        }
        cell.setText(label.toString());
    }

    public IDataModelEntity getEntity() {
        return this.m_entity;
    }

    public void setEntity(IDataModelEntity e) {
        this.m_entity = e;
    }

    public boolean isNegative() {
        return this.m_negated;
    }

    public void setNegative(boolean b) {
        this.m_negated = b;
    }

    public List<Object> getValues() {
        return CollectionUtility.arrayList(this.m_values);
    }

    public void setValues(List<?> values) {
        this.m_values = CollectionUtility.arrayListWithoutNullElements(values);
    }

    public List<String> getTexts() {
        return CollectionUtility.arrayList(this.m_texts);
    }

    public void setTexts(List<String> texts) {
        this.m_texts = CollectionUtility.arrayListWithoutNullElements(texts);
    }

    @Order(value=10.0)
    @ClassId(value="8d03343b-7dd8-4d88-8686-9b835fe4dd6d")
    public class AddAttributeOnEntityMenu
    extends AbstractAddAttributeMenu {
        public AddAttributeOnEntityMenu() {
            super(EntityNode.this.getComposerField(), EntityNode.this);
        }
    }

    @Order(value=20.0)
    @ClassId(value="75ef4b93-4c3b-463f-b221-a786eb6cbdf8")
    public class AddEitherOrOnEntityMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return TEXTS.get((String)"ExtendedSearchAddEitherOrMenu");
        }

        @Override
        protected void execInitAction() {
            List atts = EntityNode.this.m_entity.getAttributes();
            List ents = EntityNode.this.m_entity.getEntities();
            this.setVisible(CollectionUtility.hasElements((Collection)atts) || CollectionUtility.hasElements((Collection)ents));
        }

        @Override
        protected void execAction() {
            EitherOrNode node = EntityNode.this.getComposerField().addEitherNode(EntityNode.this, false);
            EntityNode.this.getComposerField().addAdditionalOrNode(node, false);
        }
    }

    @Order(value=70.0)
    @ClassId(value="ebef316f-f872-4143-bacf-68b47139e536")
    public class AddEntityPlaceholderOnEntityMenu
    extends AbstractMenuSeparator {
    }

    @Order(value=50.0)
    @ClassId(value="f9fc783d-341a-48de-a3a9-9ee7ab1a51ba")
    public class DeleteEntityMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return TEXTS.get((String)"ExtendedSearchRemoveMenu");
        }

        @Override
        protected String getConfiguredKeyStroke() {
            return "delete";
        }

        @Override
        protected void execAction() {
            EntityNode.this.getTree().selectPreviousParentNode();
            EntityNode.this.getTree().removeNode(EntityNode.this);
        }
    }

    @Order(value=40.0)
    @ClassId(value="fa6a5b03-6110-4026-a9c0-8e453c39ba2a")
    public class NegateEntityMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return TEXTS.get((String)"ExtendedSearchNegateMenu");
        }

        @Override
        protected void execAction() {
            EntityNode.this.setNegative(!EntityNode.this.isNegative());
            if (!EntityNode.this.isStatusInserted()) {
                EntityNode.this.setStatusInternal(2);
            }
            EntityNode.this.update();
        }
    }

    @Order(value=60.0)
    @ClassId(value="be9f8629-b3ce-46c7-af9b-ebfe83fc903a")
    public class Separator2Menu
    extends AbstractMenuSeparator {
    }
}

