/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.datefield;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.form.fields.datefield.IDateFieldExtension;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.ParsingFailedStatus;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateFieldUIFacade;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.IProcessingStatus;
import org.eclipse.scout.rt.platform.exception.ProcessingStatus;
import org.eclipse.scout.rt.platform.exception.VetoException;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.date.DateFormatProvider;
import org.eclipse.scout.rt.platform.util.date.DateUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="f73eed8c-1e70-4903-a23f-4a29d884e5ea")
public abstract class AbstractDateField
extends AbstractValueField<Date>
implements IDateField {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDateField.class);
    private IDateFieldUIFacade m_uiFacade;

    public AbstractDateField() {
        this(true);
    }

    public AbstractDateField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="STRING")
    @Order(value=230.0)
    protected String getConfiguredFormat() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=231.0)
    protected String getConfiguredDateFormatPattern() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=232.0)
    protected String getConfiguredTimeFormatPattern() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=240.0)
    protected boolean getConfiguredHasDate() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=241.0)
    protected boolean getConfiguredHasTime() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=242.0)
    protected int getConfiguredTimePickerResolution() {
        return 30;
    }

    @Order(value=270.0)
    protected Date getConfiguredAutoDate() {
        return null;
    }

    @Override
    protected Date execParseValue(String text) {
        return (Date)super.execParseValue(text);
    }

    @Override
    protected String execFormatValue(Date value) {
        return super.execFormatValue(value);
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        super.initConfig();
        this.setHasDate(this.getConfiguredHasDate());
        this.setHasTime(this.getConfiguredHasTime());
        this.setTimePickerResolution(this.getConfiguredTimePickerResolution());
        this.setAutoDate(this.getConfiguredAutoDate());
        this.setDateFormatPattern(this.getConfiguredDateFormatPattern());
        this.setTimeFormatPattern(this.getConfiguredTimeFormatPattern());
        this.setFormat(this.getConfiguredFormat());
        this.setAllowedDates(Collections.emptyList());
    }

    @Override
    public void setFormat(String format) {
        String supportedFormat = this.checkFormatPatternSupported(format);
        if (supportedFormat == null) {
            return;
        }
        String dateFormatPattern = null;
        String timeFormatPattern = null;
        int h = supportedFormat.toLowerCase().indexOf(104);
        if (h >= 0) {
            dateFormatPattern = supportedFormat.substring(0, h).trim();
            timeFormatPattern = supportedFormat.substring(h).trim();
        } else if (this.isHasDate()) {
            dateFormatPattern = supportedFormat;
            timeFormatPattern = null;
            if (this.isHasTime()) {
                LOG.warn("Could not extract time part from pattern '{}', using default pattern.", (Object)supportedFormat);
            }
        } else {
            dateFormatPattern = null;
            timeFormatPattern = this.isHasTime() ? supportedFormat : null;
        }
        this.setDateFormatPattern(dateFormatPattern);
        this.setTimeFormatPattern(timeFormatPattern);
    }

    @Override
    public String getFormat() {
        String s = "";
        if (this.isHasDate()) {
            s = StringUtility.join((String)" ", (Object[])new Object[]{s, this.getDateFormatPattern()});
        }
        if (this.isHasTime()) {
            s = StringUtility.join((String)" ", (Object[])new Object[]{s, this.getTimeFormatPattern()});
        }
        return s;
    }

    @Override
    public void setDateFormatPattern(String dateFormatPattern) {
        if ((dateFormatPattern = this.checkFormatPatternSupported(dateFormatPattern)) == null) {
            dateFormatPattern = ((DateFormatProvider)BEANS.get(DateFormatProvider.class)).getDateFormatPattern(1, NlsLocale.get());
        }
        this.propertySupport.setPropertyString("dateFormatPattern", dateFormatPattern);
        this.refreshDisplayText();
    }

    @Override
    public String getDateFormatPattern() {
        return this.propertySupport.getPropertyString("dateFormatPattern");
    }

    @Override
    public void setTimeFormatPattern(String timeFormatPattern) {
        if ((timeFormatPattern = this.checkFormatPatternSupported(timeFormatPattern)) == null) {
            timeFormatPattern = ((DateFormatProvider)BEANS.get(DateFormatProvider.class)).getDateFormatPattern(2, NlsLocale.get());
        }
        this.propertySupport.setPropertyString("timeFormatPattern", timeFormatPattern);
        this.refreshDisplayText();
    }

    @Override
    public String getTimeFormatPattern() {
        return this.propertySupport.getPropertyString("timeFormatPattern");
    }

    protected String checkFormatPatternSupported(String formatPattern) {
        return formatPattern;
    }

    @Override
    public boolean isHasTime() {
        return this.propertySupport.getPropertyBool("hasTime");
    }

    @Override
    public void setHasTime(boolean b) {
        this.propertySupport.setPropertyBool("hasTime", b);
        if (this.isInitConfigDone()) {
            this.setValue((Date)this.getValue());
        }
    }

    @Override
    public void setTimePickerResolution(int resolution) {
        this.propertySupport.setPropertyInt("timePickerResolution", resolution);
    }

    @Override
    public int getTimePickerResolution() {
        return this.propertySupport.getPropertyInt("timePickerResolution");
    }

    @Override
    public boolean isHasDate() {
        return this.propertySupport.getPropertyBool("hasDate");
    }

    @Override
    public void setHasDate(boolean b) {
        this.propertySupport.setPropertyBool("hasDate", b);
        if (this.isInitConfigDone()) {
            this.setValue((Date)this.getValue());
        }
    }

    @Override
    public void setAutoDate(Date autoDate) {
        this.propertySupport.setProperty("autoDate", (Object)autoDate);
    }

    @Override
    public Date getAutoDate() {
        return (Date)this.propertySupport.getProperty("autoDate");
    }

    @Override
    public IDateFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    protected String formatValueInternal(Date validValue) {
        DateFormat dateFormat;
        if (validValue == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (this.isHasDate()) {
            dateFormat = this.getIsolatedDateFormat();
            sb.append(dateFormat == null ? "" : dateFormat.format(validValue));
            if (this.isHasTime()) {
                sb.append("\n");
            }
        }
        if (this.isHasTime()) {
            dateFormat = this.getIsolatedTimeFormat();
            sb.append(dateFormat == null ? "" : dateFormat.format(validValue));
        }
        return sb.length() == 1 && sb.charAt(0) == '\n' ? "" : sb.toString();
    }

    @Override
    protected Date validateValueInternal(Date rawValue) {
        if ((rawValue = super.validateValueInternal(rawValue)) == null) {
            return null;
        }
        if (!this.getAllowedDates().isEmpty()) {
            Date truncDate = DateUtility.truncDate((Date)rawValue);
            boolean found = false;
            for (Date allowedDate : this.getAllowedDates()) {
                if (allowedDate.compareTo(truncDate) != 0) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new VetoException((IProcessingStatus)new ProcessingStatus(TEXTS.get((String)"DateIsNotAllowed"), 0x1000000));
            }
        }
        return rawValue;
    }

    @Override
    public Double getTimeValue() {
        return DateUtility.convertDateToDoubleTime((Date)((Date)this.getValue()));
    }

    @Override
    public void setTimeValue(Double d) {
        this.setValue(DateUtility.convertDoubleTimeToDate((Number)d));
    }

    protected Date applyAutoDate(Date d) {
        if (d != null) {
            return d;
        }
        d = this.getAutoDate();
        if (d == null) {
            d = new Date();
        }
        return d;
    }

    @Override
    public DateFormat getDateFormat() {
        String format = this.getFormat();
        if (format != null) {
            return new SimpleDateFormat(format, NlsLocale.get());
        }
        return null;
    }

    @Override
    public DateFormat getIsolatedDateFormat() {
        String pat;
        int h;
        DateFormat f = this.getDateFormat();
        if (f instanceof SimpleDateFormat && (h = (pat = ((SimpleDateFormat)f).toPattern()).toLowerCase().indexOf(104)) >= 0) {
            try {
                return new SimpleDateFormat(pat.substring(0, h).trim(), NlsLocale.get());
            }
            catch (Exception e) {
                LOG.error("could not isolate date pattern from '{}'", (Object)pat, (Object)e);
            }
        }
        return f;
    }

    @Override
    public DateFormat getIsolatedTimeFormat() {
        String pat;
        int h;
        DateFormat f = this.getDateFormat();
        if (f instanceof SimpleDateFormat && (h = (pat = ((SimpleDateFormat)f).toPattern()).toLowerCase().indexOf(104)) >= 0) {
            try {
                return new SimpleDateFormat(pat.substring(h).trim(), NlsLocale.get());
            }
            catch (Exception e) {
                LOG.error("could not isolate time pattern from '{}'", (Object)pat, (Object)e);
            }
        }
        return null;
    }

    @Override
    public void setAllowedDates(List<Date> allowedDates) {
        if (allowedDates == null) {
            allowedDates = Collections.emptyList();
        } else {
            ArrayList<Date> sortedTruncatedDates = new ArrayList<Date>(allowedDates.size());
            for (Date date : allowedDates) {
                sortedTruncatedDates.add(DateUtility.truncDate((Date)date));
            }
            Collections.sort(sortedTruncatedDates);
            allowedDates = sortedTruncatedDates;
        }
        this.propertySupport.setProperty("allowedDates", allowedDates);
    }

    @Override
    public List<Date> getAllowedDates() {
        return new ArrayList<Date>((Collection)this.propertySupport.getProperty("allowedDates"));
    }

    @Override
    protected IDateFieldExtension<? extends AbstractDateField> createLocalExtension() {
        return new LocalDateFieldExtension<AbstractDateField>(this);
    }

    protected static class LocalDateFieldExtension<OWNER extends AbstractDateField>
    extends AbstractValueField.LocalValueFieldExtension<Date, OWNER>
    implements IDateFieldExtension<OWNER> {
        public LocalDateFieldExtension(OWNER owner) {
            super(owner);
        }
    }

    protected class P_UIFacade
    implements IDateFieldUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void setValueFromUI(Date date) {
            if (!AbstractDateField.this.isEnabledIncludingParents() || !AbstractDateField.this.isVisibleIncludingParents()) {
                return;
            }
            AbstractDateField.this.setValue(date);
        }

        @Override
        public void setDisplayTextFromUI(String text) {
            if (!AbstractDateField.this.isEnabledIncludingParents() || !AbstractDateField.this.isVisibleIncludingParents()) {
                return;
            }
            AbstractDateField.this.setDisplayText(text);
        }

        @Override
        public void setErrorStatusFromUI(IStatus errorStatus) {
            AbstractDateField.this.removeErrorStatus(ParsingFailedStatus.class);
            if (errorStatus != null) {
                AbstractDateField.this.addErrorStatus(errorStatus);
            }
        }
    }
}

