/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.radiobuttongroup.IRadioButtonGroupExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.radiobuttongroup.RadioButtonGroupChains;
import org.eclipse.scout.rt.client.services.lookup.FormFieldProvisioningContext;
import org.eclipse.scout.rt.client.services.lookup.ILookupCallProvisioningService;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.CompositeFieldUtility;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeFieldGrid;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.LogicalGridLayoutConfig;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractRadioButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.IRadioButton;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.IRadioButtonGroup;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.internal.RadioButtonGroupGrid;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.TriState;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="20dd4412-e677-4996-afcc-13c43b9dcae8")
public abstract class AbstractRadioButtonGroup<T>
extends AbstractValueField<T>
implements IRadioButtonGroup<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRadioButtonGroup.class);
    private boolean m_valueAndSelectionMediatorActive;
    private ILookupCall<T> m_lookupCall;
    private Class<? extends ICodeType<?, T>> m_codeTypeClass;
    private ICompositeFieldGrid<ICompositeField> m_grid;
    private List<IFormField> m_fields;
    private P_FieldPropertyChangeListenerEx m_fieldPropertyChangeListener;
    private List<IRadioButton<T>> m_radioButtons;
    private Map<Class<? extends IFormField>, IFormField> m_movedFormFieldsByClass;

    public AbstractRadioButtonGroup() {
        this(true);
    }

    public AbstractRadioButtonGroup(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="LOOKUP_CALL")
    @Order(value=240.0)
    protected Class<? extends ILookupCall<T>> getConfiguredLookupCall() {
        return null;
    }

    @ConfigProperty(value="CODE_TYPE")
    @Order(value=250.0)
    protected Class<? extends ICodeType<?, T>> getConfiguredCodeType() {
        return null;
    }

    @Override
    @Order(value=210.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredAutoAddDefaultMenus() {
        return false;
    }

    @Order(value=255.0)
    @ConfigProperty(value="INTEGER")
    protected int getConfiguredGridColumnCount() {
        return -1;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=260.0)
    protected LogicalGridLayoutConfig getConfiguredLayoutConfig() {
        return new LogicalGridLayoutConfig();
    }

    @Override
    protected final String getConfiguredClearable() {
        return "never";
    }

    @ConfigOperation
    @Order(value=260.0)
    protected void execPrepareLookup(ILookupCall<T> call) {
    }

    @ConfigOperation
    @Order(value=270.0)
    protected void execFilterLookupResult(ILookupCall<T> call, List<ILookupRow<T>> result) {
    }

    @Override
    protected void initConfig() {
        Class<ILookupCall<T>> lookupCallClass;
        this.m_fields = CollectionUtility.emptyArrayList();
        this.m_movedFormFieldsByClass = new HashMap<Class<? extends IFormField>, IFormField>();
        this.m_fieldPropertyChangeListener = new P_FieldPropertyChangeListenerEx();
        this.m_grid = this.createGrid();
        super.initConfig();
        if (this.getConfiguredCodeType() != null) {
            this.setCodeTypeClass(this.getConfiguredCodeType());
        }
        if ((lookupCallClass = this.getConfiguredLookupCall()) != null) {
            ILookupCall call = (ILookupCall)BEANS.get(lookupCallClass);
            this.setLookupCall(call);
        }
        List<Class<IFormField>> configuredFields = this.getConfiguredFields();
        List contributedFields = this.m_contributionHolder.getContributionsByClass(IFormField.class);
        OrderedCollection fields = new OrderedCollection();
        for (Class<IFormField> fieldClazz : configuredFields) {
            fields.addOrdered((IOrdered)((IFormField)ConfigurationUtility.newInnerInstance((Object)this, fieldClazz)));
        }
        fields.addAllOrdered((Collection)contributedFields);
        this.injectFieldsInternal((OrderedCollection<IFormField>)fields);
        for (IFormField f : fields) {
            CompositeFieldUtility.connectFields(f, this);
        }
        this.m_fields = fields.getOrderedList();
        for (IFormField f : this.m_fields) {
            f.addPropertyChangeListener(this.m_fieldPropertyChangeListener);
        }
        ArrayList<IRadioButton<T>> buttonList = new ArrayList<IRadioButton<T>>();
        for (IFormField iFormField : this.m_fields) {
            IRadioButton<T> b = this.findFirstButtonInFieldTree(iFormField);
            if (b == null) continue;
            buttonList.add(b);
        }
        this.m_radioButtons = buttonList;
        for (IRadioButton iRadioButton : this.m_radioButtons) {
            iRadioButton.addPropertyChangeListener(new P_ButtonPropertyChangeListener());
        }
        this.setGridColumnCount(this.getConfiguredGridColumnCount());
        this.setLayoutConfig(this.getConfiguredLayoutConfig());
        this.handleFieldVisibilityChanged();
    }

    private IRadioButton<T> findFirstButtonInFieldTree(IFormField f) {
        if (f instanceof IRadioButton) {
            return (IRadioButton)f;
        }
        if (f instanceof ICompositeField) {
            for (IFormField sub : ((ICompositeField)f).getFields()) {
                IRadioButton<T> b = this.findFirstButtonInFieldTree(sub);
                if (b == null) continue;
                return b;
            }
        }
        return null;
    }

    protected void injectFieldsInternal(OrderedCollection<IFormField> fields) {
        if (this.getLookupCall() == null) {
            return;
        }
        List<ILookupRow<T>> lookupRows = this.getLookupRows();
        for (ILookupRow<T> row : lookupRows) {
            if (!row.isActive()) continue;
            IRadioButton<T> radioButton = this.createEmptyRadioButtonForLookupRow();
            radioButton.setEnabled(row.isEnabled());
            radioButton.setLabel(row.getText());
            radioButton.setRadioValue(row.getKey());
            radioButton.setTooltipText(row.getTooltipText());
            radioButton.setBackgroundColor(row.getBackgroundColor());
            radioButton.setForegroundColor(row.getForegroundColor());
            radioButton.setFont(row.getFont());
            radioButton.setCssClass(row.getCssClass());
            radioButton.setIconId(row.getIconId());
            fields.addLast(radioButton);
        }
    }

    protected IRadioButton<T> createEmptyRadioButtonForLookupRow() {
        return new RadioButton();
    }

    protected ICompositeFieldGrid<ICompositeField> createGrid() {
        return new RadioButtonGroupGrid();
    }

    @Override
    public void addField(IFormField f) {
        CompositeFieldUtility.addField(f, this, this.m_fields);
        f.addPropertyChangeListener(this.m_fieldPropertyChangeListener);
        this.handleFieldsChanged();
    }

    @Override
    public void removeField(IFormField f) {
        CompositeFieldUtility.removeField(f, this, this.m_fields);
        f.removePropertyChangeListener(this.m_fieldPropertyChangeListener);
        this.handleFieldsChanged();
    }

    @Override
    public void moveFieldTo(IFormField f, ICompositeField newContainer) {
        CompositeFieldUtility.moveFieldTo(f, this, newContainer, this.m_movedFormFieldsByClass);
    }

    @Override
    public Map<Class<? extends IFormField>, IFormField> getMovedFields() {
        return Collections.unmodifiableMap(this.m_movedFormFieldsByClass);
    }

    protected void handleFieldsChanged() {
        this.handleFieldVisibilityChanged();
        this.checkSaveNeeded();
        this.checkEmpty();
    }

    public ILookupCall<T> getLookupCall() {
        return this.m_lookupCall;
    }

    @Override
    public void setMandatory(boolean b, boolean recursive) {
        super.setMandatory(b, false);
    }

    public void setLookupCall(ILookupCall<T> call) {
        this.m_lookupCall = call;
    }

    public Class<? extends ICodeType<?, T>> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    public void setCodeTypeClass(Class<? extends ICodeType<?, T>> codeTypeClass) {
        this.m_codeTypeClass = codeTypeClass;
        this.m_lookupCall = null;
        if (this.m_codeTypeClass != null) {
            this.m_lookupCall = CodeLookupCall.newInstanceByService(this.m_codeTypeClass);
        }
        if (this.getConfiguredLabel() == null) {
            this.setLabel(((ICodeType)BEANS.get(codeTypeClass)).getText());
        }
    }

    @Override
    public boolean setGridColumnCount(int c) {
        boolean changed = this.propertySupport.setPropertyInt("gridColumnCount", c);
        if (changed && this.isInitConfigDone()) {
            this.rebuildFieldGrid();
        }
        return changed;
    }

    @Override
    public int getGridColumnCount() {
        return this.propertySupport.getPropertyInt("gridColumnCount");
    }

    @Override
    public LogicalGridLayoutConfig getLayoutConfig() {
        return (LogicalGridLayoutConfig)this.propertySupport.getProperty("layoutConfig");
    }

    @Override
    public void setLayoutConfig(LogicalGridLayoutConfig layoutConfig) {
        this.propertySupport.setProperty("layoutConfig", (Object)layoutConfig);
    }

    protected List<Class<? extends IFormField>> getConfiguredFields() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List fca = ConfigurationUtility.filterClasses((Class[])dca, IFormField.class);
        return ConfigurationUtility.removeReplacedClasses((List)fca);
    }

    @Override
    protected void initFieldInternal() {
        IRadioButton<Object> b = this.getButtonFor(null);
        if (b != null) {
            this.syncValueToButtons();
        }
        super.initFieldInternal();
    }

    protected List<ILookupRow<T>> getLookupRows() {
        ArrayList data;
        ILookupCall<T> call = this.getLookupCall();
        if (call != null) {
            call = ((ILookupCallProvisioningService)BEANS.get(ILookupCallProvisioningService.class)).newClonedInstance(call, new FormFieldProvisioningContext(this));
            this.prepareLookupCall(call);
            data = CollectionUtility.arrayList((Collection)call.getDataByAll());
        } else {
            data = CollectionUtility.emptyArrayList();
        }
        this.filterLookup(call, data);
        return data;
    }

    protected void prepareLookupCall(ILookupCall<T> call) {
        this.prepareLookupCallInternal(call);
        this.interceptPrepareLookup(call);
    }

    private void prepareLookupCallInternal(ILookupCall<T> call) {
        call.setActive(TriState.UNDEFINED);
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
    }

    protected void filterLookup(ILookupCall<T> call, List<ILookupRow<T>> result) {
        this.interceptFilterLookupResult(call, result);
        Iterator<ILookupRow<T>> resultIt = result.iterator();
        while (resultIt.hasNext()) {
            ILookupRow<T> row = resultIt.next();
            if (row == null) {
                resultIt.remove();
                continue;
            }
            if (row.getKey() != null) continue;
            LOG.warn("The key of a lookup row may not be null. Row has been removed for radio button group '{}'.", (Object)this.getClass().getName());
            resultIt.remove();
        }
    }

    @Override
    public void rebuildFieldGrid() {
        if (this.m_grid != null) {
            this.m_grid.validate(this);
            if (this.isInitConfigDone()) {
                if (this.getParentField() != null) {
                    this.getParentField().rebuildFieldGrid();
                }
                if (this.getForm() != null) {
                    this.getForm().structureChanged(this);
                }
            }
        }
    }

    public ICompositeFieldGrid<ICompositeField> getFieldGrid() {
        return this.m_grid;
    }

    protected void handleFieldVisibilityChanged() {
        if (this.isInitConfigDone()) {
            this.rebuildFieldGrid();
        }
    }

    @Override
    protected void valueChangedInternal() {
        super.valueChangedInternal();
        this.syncValueToButtons();
    }

    @Override
    protected T validateValueInternal(T rawValue) {
        T validValue;
        if (rawValue == null) {
            validValue = null;
        } else {
            IRadioButton<T> b = this.getButtonFor(rawValue);
            if (b != null) {
                validValue = rawValue;
            } else {
                throw new ProcessingException("Illegal radio value: " + rawValue, new Object[0]);
            }
        }
        return validValue;
    }

    @Override
    protected double getConfiguredGridWeightY() {
        return 0.0;
    }

    @Override
    public T getSelectedKey() {
        return (T)this.getValue();
    }

    @Override
    public IRadioButton<T> getButtonFor(T value) {
        for (IRadioButton<T> b : this.getButtons()) {
            T radioValue = b.getRadioValue();
            if (!ObjectUtility.equals(radioValue, value)) continue;
            return b;
        }
        return null;
    }

    @Override
    public IRadioButton<T> getSelectedButton() {
        return this.getButtonFor(this.getSelectedKey());
    }

    @Override
    public void selectKey(T key) {
        this.setValue(key);
    }

    @Override
    protected String formatValueInternal(T validValue) {
        if (validValue == null || this.getButtonFor(validValue) == null) {
            return "";
        }
        return this.getButtonFor(validValue).getLabel();
    }

    @Override
    public void selectButton(IRadioButton button) {
        for (IRadioButton<T> b : this.getButtons()) {
            if (b != button) continue;
            button.setSelected(true);
            break;
        }
    }

    public <F extends IFormField> F getFieldByClass(Class<F> widgetClassToFind) {
        return (F)((IFormField)this.getWidgetByClass(widgetClassToFind));
    }

    @Override
    public IFormField getFieldById(String id) {
        return CompositeFieldUtility.getFieldById(this, id);
    }

    public <X extends IFormField> X getFieldById(String id, Class<X> type) {
        return CompositeFieldUtility.getFieldById(this, id, type);
    }

    @Override
    public int getFieldCount() {
        return this.m_fields.size();
    }

    @Override
    public int getFieldIndex(IFormField f) {
        return this.m_fields.indexOf(f);
    }

    @Override
    public void setFields(List<IFormField> fields) {
        this.m_fields = CollectionUtility.arrayList(fields);
    }

    @Override
    public List<IFormField> getFields() {
        return CollectionUtility.arrayList(this.m_fields);
    }

    @Override
    public List<IRadioButton<T>> getButtons() {
        if (this.m_radioButtons == null) {
            return CollectionUtility.emptyArrayList();
        }
        return CollectionUtility.arrayList(this.m_radioButtons);
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), this.m_fields});
    }

    private void syncValueToButtons() {
        if (this.m_valueAndSelectionMediatorActive) {
            return;
        }
        try {
            this.m_valueAndSelectionMediatorActive = true;
            T selectedKey = this.getSelectedKey();
            IRadioButton<T> selectedButton = this.getButtonFor(selectedKey);
            for (IRadioButton<T> b : this.getButtons()) {
                b.setSelected(b == selectedButton);
            }
        }
        finally {
            this.m_valueAndSelectionMediatorActive = false;
        }
    }

    private void syncButtonsToValue(IRadioButton<T> selectedButton) {
        if (this.m_valueAndSelectionMediatorActive) {
            return;
        }
        try {
            this.m_valueAndSelectionMediatorActive = true;
            for (IRadioButton<T> b : this.getButtons()) {
                b.setSelected(b == selectedButton);
            }
            this.selectKey(selectedButton.getRadioValue());
        }
        finally {
            this.m_valueAndSelectionMediatorActive = false;
        }
    }

    protected final void interceptPrepareLookup(ILookupCall<T> call) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        RadioButtonGroupChains.RadioButtonGroupPrepareLookupChain<T> chain = new RadioButtonGroupChains.RadioButtonGroupPrepareLookupChain<T>(extensions);
        chain.execPrepareLookup(call);
    }

    protected final void interceptFilterLookupResult(ILookupCall<T> call, List<ILookupRow<T>> result) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        RadioButtonGroupChains.RadioButtonGroupFilterLookupResultChain<T> chain = new RadioButtonGroupChains.RadioButtonGroupFilterLookupResultChain<T>(extensions);
        chain.execFilterLookupResult(call, result);
    }

    @Override
    protected IRadioButtonGroupExtension<T, ? extends AbstractRadioButtonGroup<T>> createLocalExtension() {
        return new LocalRadioButtonGroupExtension(this);
    }

    protected static class LocalRadioButtonGroupExtension<T, OWNER extends AbstractRadioButtonGroup<T>>
    extends AbstractValueField.LocalValueFieldExtension<T, OWNER>
    implements IRadioButtonGroupExtension<T, OWNER> {
        public LocalRadioButtonGroupExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execPrepareLookup(RadioButtonGroupChains.RadioButtonGroupPrepareLookupChain<T> chain, ILookupCall<T> call) {
            ((AbstractRadioButtonGroup)this.getOwner()).execPrepareLookup(call);
        }

        @Override
        public void execFilterLookupResult(RadioButtonGroupChains.RadioButtonGroupFilterLookupResultChain<T> chain, ILookupCall<T> call, List<ILookupRow<T>> result) {
            ((AbstractRadioButtonGroup)this.getOwner()).execFilterLookupResult(call, result);
        }
    }

    private class P_ButtonPropertyChangeListener
    implements PropertyChangeListener {
        private P_ButtonPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            IRadioButton radioButton;
            if (e.getPropertyName().equals("selected") && (radioButton = (IRadioButton)e.getSource()).isSelected()) {
                AbstractRadioButtonGroup.this.syncButtonsToValue(radioButton);
            }
        }
    }

    private class P_FieldPropertyChangeListenerEx
    implements PropertyChangeListener {
        private P_FieldPropertyChangeListenerEx() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("visible")) {
                AbstractRadioButtonGroup.this.handleFieldVisibilityChanged();
            } else if (e.getPropertyName().equals("saveNeeded")) {
                AbstractRadioButtonGroup.this.checkSaveNeeded();
            } else if (e.getPropertyName().equals("empty")) {
                AbstractRadioButtonGroup.this.checkEmpty();
            }
        }
    }

    @ClassId(value="7fb44a3d-b3e5-4cae-bb93-0fa435802466")
    private final class RadioButton
    extends AbstractRadioButton<T> {
        private RadioButton() {
        }
    }
}

