/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.sequencebox;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.sequencebox.ISequenceBoxExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.sequencebox.SequenceBoxChains;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractCompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.LogicalGridLayoutConfig;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.InvalidSequenceStatus;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.internal.SequenceBoxGrid;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.concurrent.OptimisticLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="e71e8b93-1168-4f5e-8781-4774f01eee26")
public abstract class AbstractSequenceBox
extends AbstractCompositeField
implements ISequenceBox {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSequenceBox.class);
    private static final String LABEL_VISIBLE_SEQUENCE = "LABEL_VISIBLE_SEQUENCE";
    private boolean m_autoCheckFromTo;
    private OptimisticLock m_labelCompositionLock;
    private SequenceBoxGrid m_grid;
    private String m_labelBase;
    private String m_labelSuffix;

    public AbstractSequenceBox() {
        this(true);
    }

    public AbstractSequenceBox(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=200.0)
    protected boolean getConfiguredAutoCheckFromTo() {
        return true;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=220.0)
    protected LogicalGridLayoutConfig getConfiguredLayoutConfig() {
        return new LogicalGridLayoutConfig();
    }

    @ConfigOperation
    @Order(value=200.0)
    protected <T extends Comparable<T>> void execCheckFromTo(IValueField<T>[] valueFields, int changedIndex) {
        ArrayList<IValueField<T>> nonEmptyFields = new ArrayList<IValueField<T>>();
        int nonEmptyIndex = -1;
        int i = 0;
        while (i < valueFields.length) {
            if (valueFields[i].getValue() != null) {
                nonEmptyFields.add(valueFields[i]);
                if (i == changedIndex) {
                    nonEmptyIndex = nonEmptyFields.size() - 1;
                }
            }
            ++i;
        }
        if (nonEmptyIndex < 0 || !this.equalTypes(nonEmptyFields)) {
            this.clearSequenceErrors(Arrays.asList(valueFields));
        } else {
            this.checkNonEmptyFromTo(nonEmptyFields, nonEmptyIndex);
        }
    }

    private <T extends Comparable<T>> void checkNonEmptyFromTo(List<IValueField<T>> nonEmptyFields, int nonEmptyIndex) {
        IValueField<T> v;
        IValueField<T> left = nonEmptyIndex - 1 >= 0 ? nonEmptyFields.get(nonEmptyIndex - 1) : null;
        IStatus leftError = this.checkFromTo(left, v = nonEmptyFields.get(nonEmptyIndex), false);
        if (leftError != null) {
            v.addErrorStatus(leftError);
        } else {
            IValueField<T> right = nonEmptyIndex + 1 < nonEmptyFields.size() ? nonEmptyFields.get(nonEmptyIndex + 1) : null;
            IStatus rightError = this.checkFromTo(v, right, true);
            if (rightError != null) {
                v.addErrorStatus(rightError);
            } else {
                this.clearSequenceErrors(nonEmptyFields);
            }
        }
    }

    private <T extends Comparable<T>> IStatus checkFromTo(IValueField<T> from, IValueField<T> to, boolean lessMessage) {
        if (from != null && to != null && ObjectUtility.compareTo((Comparable)((Comparable)from.getValue()), (Comparable)((Comparable)to.getValue())) > 0) {
            if (lessMessage) {
                return new InvalidSequenceStatus(TEXTS.get((String)"XMustBeLessThanOrEqualY", (String[])new String[]{from.getLabel(), to.getLabel()}));
            }
            return new InvalidSequenceStatus(TEXTS.get((String)"XMustBeGreaterThanOrEqualY", (String[])new String[]{to.getLabel(), from.getLabel()}));
        }
        return null;
    }

    private <T extends Comparable<T>> boolean equalTypes(List<IValueField<T>> nonEmptyFields) {
        HashSet beanTypes = new HashSet();
        for (IValueField<T> f : nonEmptyFields) {
            beanTypes.add(((Comparable)f.getValue()).getClass());
        }
        return beanTypes.size() == 1;
    }

    private <T extends Comparable<T>> void clearSequenceErrors(List<IValueField<T>> valueFields) {
        for (IValueField<T> v : valueFields) {
            v.removeErrorStatus(InvalidSequenceStatus.class);
        }
        this.removeErrorStatus(InvalidSequenceStatus.class);
    }

    @Override
    protected void initConfig() {
        this.m_labelCompositionLock = new OptimisticLock();
        this.m_grid = new SequenceBoxGrid();
        super.initConfig();
        this.setAutoCheckFromTo(this.getConfiguredAutoCheckFromTo());
        this.setLayoutConfig(this.getConfiguredLayoutConfig());
        this.propertySupport.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("labelVisible") || e.getPropertyName().equals("label") || e.getPropertyName().equals("visible")) {
                this.updateLabelComposition();
            }
        });
        for (IFormField field : this.getFields()) {
            field.addPropertyChangeListener(e -> {
                if (e.getPropertyName().equals("labelVisible") || e.getPropertyName().equals("label") || e.getPropertyName().equals("visible")) {
                    this.updateLabelComposition();
                }
            });
        }
        this.updateLabelComposition();
        this.hideFieldStatusOfChildren();
    }

    @Override
    protected void initConfigInternal() {
        super.initConfigInternal();
        this.attachCheckFromToListeners();
    }

    private void attachCheckFromToListeners() {
        ArrayList<IValueField> valueFieldList = this.getComparableValueFields();
        if (valueFieldList.size() >= 2) {
            IValueField[] valueFields = valueFieldList.toArray(new IValueField[0]);
            int i = 0;
            while (i < valueFields.length) {
                int index = i++;
                valueFields[index].addPropertyChangeListener("value", e -> {
                    if (this.getForm() != null && this.isAutoCheckFromTo()) {
                        this.checkFromTo(valueFields, index);
                    }
                });
            }
        }
    }

    private ArrayList<IValueField> getComparableValueFields() {
        ArrayList<IValueField> valueFieldList = new ArrayList<IValueField>();
        Class sharedType = null;
        for (IFormField f : this.getFields()) {
            IValueField v;
            Class valueType;
            if (!(f instanceof IValueField) || !Comparable.class.isAssignableFrom(valueType = (v = (IValueField)f).getHolderType()) || sharedType != null && valueType != sharedType) continue;
            sharedType = valueType;
            valueFieldList.add(v);
        }
        return valueFieldList;
    }

    @Override
    public LogicalGridLayoutConfig getLayoutConfig() {
        return (LogicalGridLayoutConfig)this.propertySupport.getProperty("layoutConfig");
    }

    @Override
    public void setLayoutConfig(LogicalGridLayoutConfig layoutConfig) {
        this.propertySupport.setProperty("layoutConfig", (Object)layoutConfig);
    }

    @Override
    public void rebuildFieldGrid() {
        this.m_grid.validate(this);
        if (this.isInitConfigDone() && this.getForm() != null) {
            this.getForm().structureChanged(this);
        }
    }

    public SequenceBoxGrid getFieldGrid() {
        return this.m_grid;
    }

    @Override
    protected void handleChildFieldVisibilityChanged() {
        super.handleChildFieldVisibilityChanged();
        if (this.isInitConfigDone()) {
            this.rebuildFieldGrid();
        }
    }

    @Override
    public boolean isAutoCheckFromTo() {
        return this.m_autoCheckFromTo;
    }

    @Override
    public void setAutoCheckFromTo(boolean b) {
        this.m_autoCheckFromTo = b;
    }

    private void checkFromTo(IValueField[] valueFields, int changedIndex) {
        try {
            this.interceptCheckFromTo(valueFields, changedIndex);
        }
        catch (ProcessingException e) {
            LOG.debug("Sequence Error", (Throwable)e);
            valueFields[changedIndex].addErrorStatus((IStatus)e.getStatus());
        }
    }

    protected void hideFieldStatusOfChildren() {
        List<IFormField> fields = this.getFields();
        for (IFormField field : fields) {
            field.setStatusVisible(false);
        }
    }

    private void updateLabelComposition() {
        if (!this.isLabelVisible()) {
            return;
        }
        try {
            if (this.m_labelCompositionLock.acquire()) {
                this.m_labelSuffix = this.interceptCreateLabelSuffix();
                this.computeCompoundLabel();
            }
        }
        finally {
            this.m_labelCompositionLock.release();
        }
    }

    @Order(value=210.0)
    @ConfigOperation
    protected String execCreateLabelSuffix() {
        List<IFormField> fields = this.getFields();
        for (IFormField f : fields) {
            f.setLabelVisible(true, LABEL_VISIBLE_SEQUENCE);
        }
        for (IFormField formField : fields) {
            if (!this.interceptIsLabelSuffixCandidate(formField)) continue;
            formField.setLabelVisible(false, LABEL_VISIBLE_SEQUENCE);
            return formField.getLabel();
        }
        return null;
    }

    @ConfigOperation
    @Order(value=211.0)
    protected boolean execIsLabelSuffixCandidate(IFormField formField) {
        if (!formField.isVisible()) {
            return false;
        }
        if (!formField.isLabelVisible()) {
            return false;
        }
        if (formField.getLabelPosition() == 2) {
            return false;
        }
        if (formField.getLabelPosition() == 4) {
            return false;
        }
        if (formField instanceof IBooleanField) {
            return false;
        }
        return !(formField instanceof IButton);
    }

    @Override
    public void setLabel(String name) {
        this.m_labelBase = name;
        this.computeCompoundLabel();
    }

    private void computeCompoundLabel() {
        if (StringUtility.hasText((CharSequence)this.m_labelBase) && StringUtility.hasText((CharSequence)this.m_labelSuffix)) {
            super.setLabel(String.valueOf(this.m_labelBase) + " " + this.m_labelSuffix);
        } else {
            super.setLabel(String.valueOf(StringUtility.emptyIfNull((Object)this.m_labelBase)) + StringUtility.emptyIfNull((Object)this.m_labelSuffix));
        }
    }

    @Override
    public String getFullyQualifiedLabel(String separator) {
        String s;
        StringBuilder b = new StringBuilder();
        ICompositeField p = this.getParentField();
        if (p != null && (s = p.getFullyQualifiedLabel(separator)) != null) {
            b.append(s);
        }
        if ((s = this.m_labelBase) != null) {
            if (b.length() > 0) {
                b.append(separator);
            }
            b.append(s);
        }
        return b.toString();
    }

    protected final boolean interceptIsLabelSuffixCandidate(IFormField formField) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        SequenceBoxChains.SequenceBoxIsLabelSuffixCandidateChain chain = new SequenceBoxChains.SequenceBoxIsLabelSuffixCandidateChain(extensions);
        return chain.execIsLabelSuffixCandidate(formField);
    }

    protected final <T extends Comparable<T>> void interceptCheckFromTo(IValueField<T>[] valueFields, int changedIndex) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        SequenceBoxChains.SequenceBoxCheckFromToChain chain = new SequenceBoxChains.SequenceBoxCheckFromToChain(extensions);
        chain.execCheckFromTo(valueFields, changedIndex);
    }

    protected final String interceptCreateLabelSuffix() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        SequenceBoxChains.SequenceBoxCreateLabelSuffixChain chain = new SequenceBoxChains.SequenceBoxCreateLabelSuffixChain(extensions);
        return chain.execCreateLabelSuffix();
    }

    @Override
    protected ISequenceBoxExtension<? extends AbstractSequenceBox> createLocalExtension() {
        return new LocalSequenceBoxExtension<AbstractSequenceBox>(this);
    }

    protected static class LocalSequenceBoxExtension<OWNER extends AbstractSequenceBox>
    extends AbstractCompositeField.LocalCompositeFieldExtension<OWNER>
    implements ISequenceBoxExtension<OWNER> {
        public LocalSequenceBoxExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public boolean execIsLabelSuffixCandidate(SequenceBoxChains.SequenceBoxIsLabelSuffixCandidateChain chain, IFormField formField) {
            return ((AbstractSequenceBox)this.getOwner()).execIsLabelSuffixCandidate(formField);
        }

        @Override
        public <T extends Comparable<T>> void execCheckFromTo(SequenceBoxChains.SequenceBoxCheckFromToChain chain, IValueField<T>[] valueFields, int changedIndex) {
            ((AbstractSequenceBox)this.getOwner()).execCheckFromTo(valueFields, changedIndex);
        }

        @Override
        public String execCreateLabelSuffix(SequenceBoxChains.SequenceBoxCreateLabelSuffixChain chain) {
            return ((AbstractSequenceBox)this.getOwner()).execCreateLabelSuffix();
        }
    }
}

