/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.smartfield;

import java.util.List;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ILookupRowProvider;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class LookupRowHelper {
    private static final Logger LOG = LoggerFactory.getLogger(LookupRowHelper.class);

    public <T> List<ILookupRow<T>> lookup(ILookupRowProvider<T> provider, ILookupCall<T> lookupCall) {
        if (lookupCall == null) {
            return CollectionUtility.emptyArrayList();
        }
        this.beforeProvide(provider, lookupCall);
        List<ILookupRow<T>> result = provider.provide(lookupCall);
        return this.afterProvide(provider, lookupCall, result);
    }

    public <T> IFuture<List<ILookupRow<T>>> scheduleLookup(ILookupRowProvider<T> provider, ILookupCall<T> lookupCall) {
        Assertions.assertNotNull(provider);
        return Jobs.schedule(() -> {
            LOG.debug("Fetching data");
            if (lookupCall == null) {
                LOG.warn("Fetching data for empty lookup call");
                return CollectionUtility.emptyArrayList();
            }
            this.beforeProvide(provider, lookupCall);
            List lookupRes = provider.provide(lookupCall);
            LOG.debug("Result received {}", lookupRes);
            return this.afterProvide(provider, lookupCall, lookupRes);
        }, (JobInput)Jobs.newInput().withRunContext((RunContext)ClientRunContexts.copyCurrent()).withName("Lookup [lookupCall={}, provider={}]", new Object[]{lookupCall != null ? lookupCall.getClass().getName() : "null", provider}).withExceptionHandling(null, false));
    }

    private <T> void beforeProvide(ILookupRowProvider<T> provider, ILookupCall<T> lookupCall) {
        this.runInModelJob(() -> provider.beforeProvide(lookupCall));
    }

    private <T> List<ILookupRow<T>> afterProvide(ILookupRowProvider<T> provider, ILookupCall<T> lookupCall, List<ILookupRow<T>> result) {
        this.runInModelJob(() -> provider.afterProvide(lookupCall, result));
        return result;
    }

    private <T> void runInModelJob(Runnable runnable) {
        if (ModelJobs.isModelThread()) {
            runnable.run();
        } else {
            ModelJobs.schedule(runnable::run, ModelJobs.newInput(ClientRunContexts.copyCurrent()).withExceptionHandling(null, false)).awaitDone();
        }
    }
}

