/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.tablefield;

import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IValidateContentDescriptor;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField;
import org.eclipse.scout.rt.platform.status.IStatus;

public class ValidateTableFieldDescriptor
implements IValidateContentDescriptor {
    private final ITableField<?> m_tableField;
    private final ITableRow m_row;
    private final IColumn<?> m_col;
    private String m_displayText;

    public ValidateTableFieldDescriptor(ITableField<?> tableField, ITableRow row, IColumn<?> col) {
        this.m_tableField = tableField;
        this.m_row = row;
        this.m_col = col;
    }

    @Override
    public String getDisplayText() {
        return this.m_displayText;
    }

    public void setDisplayText(String displayText) {
        this.m_displayText = displayText;
    }

    @Override
    public IStatus getErrorStatus() {
        return null;
    }

    @Override
    public void activateProblemLocation() {
        IGroupBox g = this.m_tableField.getParentGroupBox();
        while (g != null) {
            ITabBox t;
            if (g.getParentField() instanceof ITabBox && (t = (ITabBox)g.getParentField()).getSelectedTab() != g) {
                t.setSelectedTab(g);
            }
            g = g.getParentGroupBox();
        }
        if (this.m_row != null && this.m_col != null) {
            ((ITable)this.m_tableField.getTable()).requestFocusInCell(this.m_col, this.m_row);
        }
    }
}

