/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.internal;

import java.util.function.Function;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;

public class FindFieldBySimpleClassNameVisitor
implements Function<IFormField, TreeVisitResult> {
    private final String m_simpleName;
    private IFormField m_found;

    public FindFieldBySimpleClassNameVisitor(String simpleName) {
        this.m_simpleName = simpleName;
    }

    @Override
    public TreeVisitResult apply(IFormField field) {
        if (field.getClass().getSimpleName().equalsIgnoreCase(this.m_simpleName)) {
            this.m_found = field;
            return TreeVisitResult.TERMINATE;
        }
        return TreeVisitResult.CONTINUE;
    }

    public IFormField getField() {
        return this.m_found;
    }
}

