/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.label;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.label.ILabelExtension;
import org.eclipse.scout.rt.client.extension.ui.label.LabelChains;
import org.eclipse.scout.rt.client.res.AttachmentSupport;
import org.eclipse.scout.rt.client.ui.AbstractWidget;
import org.eclipse.scout.rt.client.ui.label.ILabel;
import org.eclipse.scout.rt.client.ui.label.ILabelUIFacade;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;

@ClassId(value="2a476704-dc92-435f-8d7f-32aafcae7840")
public abstract class AbstractLabel
extends AbstractWidget
implements ILabel {
    private final ObjectExtensions<AbstractLabel, ILabelExtension<? extends AbstractLabel>> m_objectExtensions = new ObjectExtensions((Object)this, false);
    private ILabelUIFacade m_uiFacade;
    private AttachmentSupport m_attachmentSupport = (AttachmentSupport)BEANS.get(AttachmentSupport.class);

    public AbstractLabel() {
        this(true);
    }

    public AbstractLabel(boolean callInitializer) {
        super(false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        super.initConfig();
        this.setHtmlEnabled(this.getConfiguredHtmlEnabled());
        this.setScrollable(this.getConfiguredScrollable());
        this.setValue(this.getConfiguredValue());
    }

    @Override
    protected void initConfigInternal() {
        this.m_objectExtensions.initConfigAndBackupExtensionContext(this.createLocalExtension(), this::initConfig);
    }

    @Override
    public String getValue() {
        return this.propertySupport.getPropertyString("value");
    }

    @Override
    public void setValue(String value) {
        this.propertySupport.setPropertyString("value", value);
    }

    @ConfigProperty(value="STRING")
    @Order(value=10.0)
    protected String getConfiguredValue() {
        return null;
    }

    @Override
    public boolean isHtmlEnabled() {
        return this.propertySupport.getPropertyBool("htmlEnabled");
    }

    @Override
    public void setHtmlEnabled(boolean enabled) {
        this.propertySupport.setPropertyBool("htmlEnabled", enabled);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=20.0)
    protected boolean getConfiguredHtmlEnabled() {
        return false;
    }

    @Override
    public void setScrollable(boolean scrollable) {
        this.propertySupport.setPropertyBool("scrollable", scrollable);
    }

    @Override
    public boolean isScrollable() {
        return this.propertySupport.getPropertyBool("scrollable");
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=30.0)
    protected boolean getConfiguredScrollable() {
        return false;
    }

    @Override
    public Set<BinaryResource> getAttachments() {
        return this.m_attachmentSupport.getAttachments();
    }

    @Override
    public BinaryResource getAttachment(String filename) {
        return this.m_attachmentSupport.getAttachment(filename);
    }

    @Override
    public void setAttachments(Collection<? extends BinaryResource> attachments) {
        this.m_attachmentSupport.setAttachments(attachments);
    }

    @Override
    public void doAppLinkAction(String ref) {
        this.interceptAppLinkAction(ref);
    }

    @ConfigOperation
    @Order(value=230.0)
    protected void execAppLinkAction(String ref) {
    }

    protected final void interceptAppLinkAction(String ref) {
        List<? extends ILabelExtension<? extends AbstractLabel>> extensions = this.getAllExtensions();
        LabelChains.LabelAppLinkActionChain chain = new LabelChains.LabelAppLinkActionChain(extensions);
        chain.execAppLinkAction(ref);
    }

    protected ILabelExtension<? extends AbstractLabel> createLocalExtension() {
        return new LocalLabelExtension<AbstractLabel>(this);
    }

    public final List<? extends ILabelExtension<? extends AbstractLabel>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    @Override
    public ILabelUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    protected ILabelUIFacade createUIFacade() {
        return new P_UIFacade();
    }

    protected static class LocalLabelExtension<OWNER extends AbstractLabel>
    extends AbstractExtension<OWNER>
    implements ILabelExtension<OWNER> {
        public LocalLabelExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execAppLinkAction(LabelChains.LabelAppLinkActionChain chain, String ref) {
            ((AbstractLabel)this.getOwner()).execAppLinkAction(ref);
        }
    }

    protected class P_UIFacade
    implements ILabelUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void fireAppLinkActionFromUI(String ref) {
            AbstractLabel.this.doAppLinkAction(ref);
        }
    }
}

