/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.dataobject.AbstractDataObjectVisitor;
import org.eclipse.scout.rt.dataobject.DoCollection;
import org.eclipse.scout.rt.dataobject.DoList;
import org.eclipse.scout.rt.dataobject.DoNode;
import org.eclipse.scout.rt.dataobject.DoSet;
import org.eclipse.scout.rt.dataobject.IDoEntityContribution;

public abstract class AbstractReplacingDataObjectVisitor
extends AbstractDataObjectVisitor {
    @Override
    protected void caseCollection(Collection<?> collection) {
        if (collection instanceof List) {
            this.updateList((List)collection);
        } else {
            this.updateCollection(collection);
        }
    }

    @Override
    protected void caseMap(Map<?, ?> map) {
        this.updateMap(map);
    }

    @Override
    protected void caseDoEntityNode(DoNode<?> node) {
        this.updateDoNode(node);
    }

    @Override
    protected void caseDoEntityContributions(Collection<IDoEntityContribution> contributions) {
        this.updateCollection(contributions);
    }

    @Override
    protected void caseDoList(DoList<?> doList) {
        this.updateList((List)doList.get());
    }

    @Override
    protected void caseDoSet(DoSet<?> doSet) {
        this.updateSet((Set)doSet.get());
    }

    @Override
    protected void caseDoCollection(DoCollection<?> doCollection) {
        this.updateCollection((Collection)doCollection.get());
    }

    protected <LT> void updateList(List<LT> list) {
        ListIterator<LT> it = list.listIterator();
        while (it.hasNext()) {
            LT newValue;
            LT value = it.next();
            if (value == (newValue = this.replaceOrVisit(value))) continue;
            it.remove();
            it.add(newValue);
        }
    }

    protected <CT> void updateCollection(Collection<CT> collection) {
        ArrayList<CT> newValues = null;
        Iterator<CT> it = collection.iterator();
        while (it.hasNext()) {
            CT newValue;
            CT value = it.next();
            if (value == (newValue = this.replaceOrVisit(value))) continue;
            it.remove();
            if (newValues == null) {
                newValues = new ArrayList<CT>();
            }
            newValues.add(newValue);
        }
        if (newValues != null) {
            collection.addAll(newValues);
        }
    }

    protected <SET> void updateSet(Set<SET> set) {
        LinkedHashSet<SET> newValues = null;
        Iterator<SET> it = set.iterator();
        while (it.hasNext()) {
            SET newValue;
            SET value = it.next();
            if (value == (newValue = this.replaceOrVisit(value))) continue;
            it.remove();
            if (newValues == null) {
                newValues = new LinkedHashSet<SET>();
            }
            newValues.add(newValue);
        }
        if (newValues != null) {
            set.addAll(newValues);
        }
    }

    protected <K, V> void updateMap(Map<K, V> map) {
        HashMap<K, V> newEntries = null;
        Iterator<Map.Entry<K, V>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, V> entry = it.next();
            K key = entry.getKey();
            K newKey = this.replaceOrVisit(key);
            V value = entry.getValue();
            V newValue = this.replaceOrVisit(value);
            if (newKey == key && newValue == value) continue;
            it.remove();
            if (newEntries == null) {
                newEntries = new HashMap<K, V>();
            }
            newEntries.put(newKey, newValue);
        }
        if (newEntries != null) {
            map.putAll(newEntries);
        }
    }

    protected <NT> void updateDoNode(DoNode<NT> node) {
        node.set(this.replaceOrVisit(node.get()));
    }

    protected <OT> OT replaceOrVisit(OT o) {
        this.visit(o);
        return o;
    }
}

