/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.enumeration;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.scout.rt.dataobject.enumeration.IEnum;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.PlatformExceptionTranslator;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class EnumResolver {
    private static final Logger LOG = LoggerFactory.getLogger(EnumResolver.class);
    private final Method m_sentinelMethod;
    private final ConcurrentMap<Class<? extends IEnum>, Map<String, IEnum>> m_enumCache = new ConcurrentHashMap<Class<? extends IEnum>, Map<String, IEnum>>();
    private final ConcurrentMap<Class<? extends IEnum>, Method> m_resolveMethodsByEnumType = new ConcurrentHashMap<Class<? extends IEnum>, Method>();

    public EnumResolver() {
        Method m = null;
        try {
            m = EnumResolver.class.getDeclaredMethod("sentinelMethod", new Class[0]);
        }
        catch (Exception exception) {
            LOG.warn("Cannot find sentinelMethod. Enum resolver will run with reduced performance.");
        }
        this.m_sentinelMethod = m;
    }

    public <ENUM extends IEnum> ENUM resolve(Class<ENUM> enumClass, String value) {
        Assertions.assertNotNull(enumClass, (String)"enumClass is required", (Object[])new Object[0]);
        Assertions.assertTrue((boolean)enumClass.isEnum(), (String)"enumClass is required to be an enum", (Object[])new Object[0]);
        try {
            Method resolveMethod = this.m_resolveMethodsByEnumType.computeIfAbsent(enumClass, this::findResolveMethodInternal);
            if (ObjectUtility.notEquals((Object)resolveMethod, (Object)this.m_sentinelMethod)) {
                return (ENUM)((IEnum)enumClass.cast(resolveMethod.invoke(null, value)));
            }
            return this.resolveByReflection(enumClass, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e);
        }
    }

    protected Method findResolveMethodInternal(Class<? extends IEnum> enumClass) {
        Method m = this.findResolveMethod(enumClass);
        return m == null ? this.m_sentinelMethod : m;
    }

    protected Method findResolveMethod(Class<? extends IEnum> enumClass) {
        try {
            Method m = enumClass.getMethod("resolve", String.class);
            Assertions.assertTrue((boolean)Modifier.isStatic(m.getModifiers()), (String)"resolve method is expected to be static [method={}]", (Object[])new Object[]{m});
            return m;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected <ENUM extends IEnum> ENUM resolveByReflection(Class<ENUM> enumClass, String value) {
        if (value == null) {
            return null;
        }
        Map values = this.m_enumCache.computeIfAbsent(enumClass, c -> {
            IEnum[] enumConstants = (IEnum[])enumClass.getEnumConstants();
            HashMap<String, IEnum> mappings = new HashMap<String, IEnum>(enumConstants.length);
            IEnum[] iEnumArray = enumConstants;
            int n = enumConstants.length;
            int n2 = 0;
            while (n2 < n) {
                IEnum e = iEnumArray[n2];
                mappings.put(e.stringValue(), e);
                ++n2;
            }
            return Collections.unmodifiableMap(mappings);
        });
        IEnum result = (IEnum)enumClass.cast(values.get(value));
        if (result == null) {
            throw new Assertions.AssertionException("unknown string value '{}' [enum={}]", new Object[]{value, enumClass.getName()});
        }
        return (ENUM)result;
    }

    private static void sentinelMethod() {
    }
}

