/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.id;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.scout.rt.dataobject.id.IId;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.exception.PlatformExceptionTranslator;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;

@ApplicationScoped
public class IdFactory {
    protected final ConcurrentMap<Class<? extends IId<?>>, Method> m_ofMethodsByIdType = new ConcurrentHashMap();
    protected final ConcurrentMap<Class<? extends IId<?>>, Method> m_ofMethodsByString = new ConcurrentHashMap();

    public <ID extends IId<?>> ID createInternal(Class<ID> idClass, Object value) {
        try {
            Method createMethod = this.m_ofMethodsByIdType.computeIfAbsent(idClass, this::findOfByTypeMethod);
            return (ID)((IId)idClass.cast(createMethod.invoke(null, value)));
        }
        catch (Exception e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e).withContextInfo("idClass", (Object)idClass.getName(), new Object[0]).withContextInfo("value", value, new Object[0]);
        }
    }

    public <ID extends IId<?>> ID createFromString(Class<ID> idClass, String string) {
        try {
            Method createMethod = this.m_ofMethodsByString.computeIfAbsent(idClass, this::findOfByStringMethod);
            return (ID)((IId)idClass.cast(createMethod.invoke(null, string)));
        }
        catch (Exception e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e).withContextInfo("idClass", (Object)idClass.getName(), new Object[0]).withContextInfo("string", (Object)string, new Object[0]);
        }
    }

    protected Method findOfByTypeMethod(Class<? extends IId<?>> idClass) {
        Class parameterType = TypeCastUtility.getGenericsParameterClass(idClass, IId.class);
        return this.findOfMethod(idClass, parameterType);
    }

    protected Method findOfByStringMethod(Class<? extends IId<?>> idClass) {
        return this.findOfMethod(idClass, String.class);
    }

    protected Method findOfMethod(Class<? extends IId<?>> idClass, Class<?> parameterType) {
        try {
            Method m = idClass.getMethod("of", parameterType);
            Assertions.assertTrue((boolean)Modifier.isStatic(m.getModifiers()), (String)"method 'of({})' is expected to be static [method={}]", (Object[])new Object[]{parameterType.getName(), m});
            return m;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new PlatformException("Cannot find a static method 'of({})' on id class {}.", new Object[]{parameterType.getName(), idClass.getName()});
        }
    }
}

