/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.migration;

import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.dataobject.ITypeVersion;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationContext;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationHelper;
import org.eclipse.scout.rt.dataobject.migration.IDoStructureMigrationHandler;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.namespace.NamespaceVersion;

public abstract class AbstractDoStructureMigrationHandler
implements IDoStructureMigrationHandler {
    private final NamespaceVersion m_toTypeVersion = ((ITypeVersion)BEANS.get(this.toTypeVersionClass())).getVersion();

    protected AbstractDoStructureMigrationHandler() {
    }

    @Override
    public NamespaceVersion toTypeVersion() {
        return this.m_toTypeVersion;
    }

    public abstract Class<? extends ITypeVersion> toTypeVersionClass();

    @Override
    public boolean applyMigration(DoStructureMigrationContext ctx, IDoEntity doEntity) {
        boolean changed = false;
        changed |= this.migrate(ctx, doEntity);
        return changed |= this.updateTypeVersion(doEntity);
    }

    protected abstract boolean migrate(DoStructureMigrationContext var1, IDoEntity var2);

    protected boolean updateTypeVersion(IDoEntity doEntity) {
        return ((DoStructureMigrationHelper)BEANS.get(DoStructureMigrationHelper.class)).updateTypeVersion(doEntity, this.toTypeVersion());
    }
}

