/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.migration;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.dataobject.DataObjectInventory;
import org.eclipse.scout.rt.dataobject.DataObjectVisitors;
import org.eclipse.scout.rt.dataobject.DoNode;
import org.eclipse.scout.rt.dataobject.IDataObject;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.namespace.NamespaceVersion;
import org.eclipse.scout.rt.platform.namespace.Namespaces;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

@ApplicationScoped
public class DoStructureMigrationHelper {
    public static final String TYPE_ATTRIBUTE_NAME = "_type";
    public static final String TYPE_VERSION_ATTRIBUTE_NAME = "_typeVersion";

    public String getType(IDoEntity doEntity) {
        Assertions.assertNotNull((Object)doEntity, (String)"doEntity is required", (Object[])new Object[0]);
        return doEntity.getString(TYPE_ATTRIBUTE_NAME);
    }

    public void setType(IDoEntity doEntity, String typeName) {
        Assertions.assertNotNull((Object)doEntity, (String)"doEntity is required", (Object[])new Object[0]);
        doEntity.put(TYPE_ATTRIBUTE_NAME, typeName);
    }

    public NamespaceVersion getTypeVersion(IDoEntity doEntity) {
        Assertions.assertNotNull((Object)doEntity, (String)"doEntity is required", (Object[])new Object[0]);
        return NamespaceVersion.of((String)doEntity.getString(TYPE_VERSION_ATTRIBUTE_NAME));
    }

    public void setTypeVersion(IDoEntity doEntity, NamespaceVersion version) {
        Assertions.assertNotNull((Object)doEntity, (String)"doEntity is required", (Object[])new Object[0]);
        doEntity.put(TYPE_VERSION_ATTRIBUTE_NAME, version == null ? null : version.unwrap());
    }

    public boolean updateTypeVersion(IDoEntity doEntity, NamespaceVersion newVersion) {
        Assertions.assertNotNull((Object)doEntity, (String)"doEntity is required", (Object[])new Object[0]);
        NamespaceVersion currentVersion = this.getTypeVersion(doEntity);
        if (ObjectUtility.equals((Object)currentVersion, (Object)newVersion)) {
            return false;
        }
        this.setTypeVersion(doEntity, newVersion);
        return true;
    }

    public Map<String, NamespaceVersion> collectRawDataObjectTypeVersions(IDataObject rawDataObject) {
        HashMap<String, NamespaceVersion> typeVersionByTypeName = new HashMap<String, NamespaceVersion>();
        DataObjectVisitors.forEachRec(rawDataObject, IDoEntity.class, doEntity -> {
            NamespaceVersion typeVersion = this.getTypeVersion((IDoEntity)doEntity);
            String typeName = this.getType((IDoEntity)doEntity);
            if (typeName != null) {
                typeVersionByTypeName.put(typeName, typeVersion);
            }
        });
        return typeVersionByTypeName;
    }

    public boolean isMigrationApplicable(IDoEntity doEntity, NamespaceVersion version) {
        if (this.getType(doEntity) == null) {
            return false;
        }
        NamespaceVersion doEntityTypeVersionValue = this.getTypeVersion(doEntity);
        if (doEntityTypeVersionValue == null) {
            return true;
        }
        if (!doEntityTypeVersionValue.namespaceEquals(version)) {
            return false;
        }
        int compare = NamespaceVersion.compareVersion((NamespaceVersion)doEntityTypeVersionValue, (NamespaceVersion)version);
        return compare < 0;
    }

    public boolean isAnyMigrationRequired(Map<String, String> typeVersionsByTypeName) {
        if (CollectionUtility.isEmpty(typeVersionsByTypeName)) {
            return false;
        }
        for (Map.Entry<String, String> entry : typeVersionsByTypeName.entrySet()) {
            String typeVersion;
            NamespaceVersion typeVersionValue;
            String typeName = entry.getKey();
            if (!this.isMigrationRequired(typeName, typeVersionValue = NamespaceVersion.of((String)(typeVersion = entry.getValue())))) continue;
            return true;
        }
        return false;
    }

    protected boolean isMigrationRequired(String typeName, NamespaceVersion typeVersion) {
        if (typeVersion == null) {
            return true;
        }
        if (Namespaces.get().byId(typeVersion.getNamespace()) == null) {
            return false;
        }
        DataObjectInventory inventory = (DataObjectInventory)BEANS.get(DataObjectInventory.class);
        Class<? extends IDoEntity> doEntityClass = inventory.fromTypeName(typeName);
        if (doEntityClass == null) {
            return true;
        }
        NamespaceVersion currentTypeVersion = inventory.getTypeVersion(doEntityClass);
        if (!typeVersion.namespaceEquals(currentTypeVersion)) {
            return true;
        }
        int compare = NamespaceVersion.compareVersion((NamespaceVersion)typeVersion, (NamespaceVersion)currentTypeVersion);
        return compare < 0;
    }

    public boolean renameTypeName(IDoEntity doEntity, String newTypeName) {
        if (ObjectUtility.equals((Object)this.getType(doEntity), (Object)newTypeName)) {
            return false;
        }
        this.setType(doEntity, newTypeName);
        return true;
    }

    public boolean renameAttribute(IDoEntity doEntity, String attributeName, String newAttributeName) {
        if (!doEntity.has(attributeName)) {
            return false;
        }
        DoNode<?> node = doEntity.getNode(attributeName);
        doEntity.remove(attributeName);
        doEntity.putNode(newAttributeName, node);
        return true;
    }
}

