/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.migration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.eclipse.scout.rt.dataobject.DataObjectInventory;
import org.eclipse.scout.rt.dataobject.DoEntity;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.dataobject.ITypeVersion;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationContextDataTarget;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationHelper;
import org.eclipse.scout.rt.dataobject.migration.DoValueMigrationId;
import org.eclipse.scout.rt.dataobject.migration.IDoStructureMigrationHandler;
import org.eclipse.scout.rt.dataobject.migration.IDoStructureMigrationTargetContextData;
import org.eclipse.scout.rt.dataobject.migration.IDoValueMigrationHandler;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.inventory.ClassInventory;
import org.eclipse.scout.rt.platform.inventory.IClassInfo;
import org.eclipse.scout.rt.platform.inventory.IClassInventory;
import org.eclipse.scout.rt.platform.namespace.INamespace;
import org.eclipse.scout.rt.platform.namespace.INamespaceVersioned;
import org.eclipse.scout.rt.platform.namespace.NamespaceVersion;
import org.eclipse.scout.rt.platform.namespace.NamespaceVersionedModel;
import org.eclipse.scout.rt.platform.namespace.Namespaces;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ImmutablePair;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.Pair;

@ApplicationScoped
public class DoStructureMigrationInventory {
    protected final LinkedHashSet<String> m_namespaces = new LinkedHashSet();
    protected final LinkedHashSet<NamespaceVersion> m_orderedVersions = new LinkedHashSet();
    protected ByNamespaceVersionComparator m_comparator = null;
    protected final Map<NamespaceVersion, Map<String, IDoStructureMigrationHandler>> m_structureMigrationHandlers = new HashMap<NamespaceVersion, Map<String, IDoStructureMigrationHandler>>();
    protected final Map<String, Set<Class<? extends IDoStructureMigrationTargetContextData>>> m_doContextDataClassByTypeName = new HashMap<String, Set<Class<? extends IDoStructureMigrationTargetContextData>>>();
    protected final Map<Class<? extends IDoEntity>, Set<Class<? extends IDoStructureMigrationTargetContextData>>> m_doContextDataClassByDoEntityClass = new HashMap<Class<? extends IDoEntity>, Set<Class<? extends IDoStructureMigrationTargetContextData>>>();
    protected final Map<String, List<NamespaceVersion>> m_typeNameVersions = new HashMap<String, List<NamespaceVersion>>();
    protected final Map<String, NamespaceVersion> m_typeNameToCurrentTypeVersion = new HashMap<String, NamespaceVersion>();
    protected final LinkedHashMap<DoValueMigrationId, IDoValueMigrationHandler<?>> m_valueMigrationHandlers = new LinkedHashMap();

    protected List<INamespace> getAllNamespaces() {
        return Namespaces.get().all();
    }

    protected Collection<ITypeVersion> getAllTypeVersions() {
        return BEANS.all(ITypeVersion.class);
    }

    protected Collection<Class<? extends IDoStructureMigrationTargetContextData>> getAllContextDataClasses() {
        return ClassInventory.get().getKnownAnnotatedTypes(DoStructureMigrationContextDataTarget.class).stream().filter(IClassInfo::isInstanciable).map(IClassInfo::resolveClass).filter(IDoStructureMigrationTargetContextData.class::isAssignableFrom).map(clazz -> clazz).collect(Collectors.toList());
    }

    protected List<IDoStructureMigrationHandler> getAllStructureMigrationHandlers() {
        return BEANS.all(IDoStructureMigrationHandler.class);
    }

    protected List<IDoValueMigrationHandler<?>> getAllValueMigrationHandlers() {
        return BEANS.all(IDoValueMigrationHandler.class).stream().map(handler -> handler).collect(Collectors.toList());
    }

    @PostConstruct
    protected void init() {
        this.getAllNamespaces().stream().map(INamespace::getId).forEach(this.m_namespaces::add);
        NamespaceVersionedModel<ITypeVersion> model = this.createDefaultModel();
        NamespaceVersionedModel.VersionedItems items = model.getItems();
        Assertions.assertTrue((boolean)items.isValid(), (String)"Type version model is not valid", (Object[])new Object[0]);
        items.getItems().stream().map(INamespaceVersioned::getVersion).forEach(this.m_orderedVersions::add);
        this.m_comparator = new ByNamespaceVersionComparator(new ArrayList<NamespaceVersion>(this.m_orderedVersions));
        DataObjectInventory dataObjectInventory = (DataObjectInventory)BEANS.get(DataObjectInventory.class);
        for (Map.Entry<String, Class<? extends IDoEntity>> entry : dataObjectInventory.getTypeNameToClassMap().entrySet()) {
            String typeName = entry.getKey();
            NamespaceVersion namespaceVersion = dataObjectInventory.getTypeVersion(entry.getValue());
            if (namespaceVersion == null) continue;
            this.m_typeNameToCurrentTypeVersion.put(typeName, namespaceVersion);
        }
        IClassInventory classInventory = ClassInventory.get();
        for (Class clazz2 : this.getAllContextDataClasses()) {
            int n;
            int n2;
            Object object;
            DoStructureMigrationContextDataTarget doStructureMigrationContextDataTarget = clazz2.getAnnotation(DoStructureMigrationContextDataTarget.class);
            Assertions.assertNotNull((Object)doStructureMigrationContextDataTarget, (String)"Annotation @{} is missing on {}", (Object[])new Object[]{DoStructureMigrationContextDataTarget.class.getSimpleName(), clazz2});
            if (doStructureMigrationContextDataTarget.typeNames() != null) {
                object = doStructureMigrationContextDataTarget.typeNames();
                n2 = ((String[])object).length;
                n = 0;
                while (n < n2) {
                    Object typeName = object[n];
                    Set contextDataClasses2 = this.m_doContextDataClassByTypeName.computeIfAbsent((String)typeName, k -> new HashSet());
                    contextDataClasses2.add(clazz2);
                    ++n;
                }
            }
            if (doStructureMigrationContextDataTarget.doEntityClasses() == null) continue;
            object = doStructureMigrationContextDataTarget.doEntityClasses();
            n2 = ((Class<? extends IDoEntity>[])object).length;
            n = 0;
            while (n < n2) {
                Object doEntityClass = object[n];
                Assertions.assertFalse((doEntityClass == IDoEntity.class || doEntityClass == DoEntity.class ? 1 : 0) != 0, (String)"{}: {} and {} are invalid do entity classes for the annotation {}", (Object[])new Object[]{clazz2, IDoEntity.class.getSimpleName(), DoEntity.class.getSimpleName(), DoStructureMigrationContextDataTarget.class.getSimpleName()});
                this.m_doContextDataClassByDoEntityClass.computeIfAbsent((Class<? extends IDoEntity>)doEntityClass, k -> new HashSet()).add(clazz2);
                classInventory.getAllKnownSubClasses((Class)doEntityClass).stream().map(IClassInfo::resolveClass).map(clazz -> clazz).map(clazz -> this.m_doContextDataClassByDoEntityClass.computeIfAbsent((Class<? extends IDoEntity>)clazz, k -> new HashSet())).forEach(contextDataClasses -> {
                    boolean bl = contextDataClasses.add(contextValueClass);
                });
                ++n;
            }
        }
        HashMap<NamespaceVersion, Map<String, List<IDoStructureMigrationHandler>>> hashMap = new HashMap<NamespaceVersion, Map<String, List<IDoStructureMigrationHandler>>>();
        HashMap<String, Set> unorderedTypeNameVersions = new HashMap<String, Set>();
        for (IDoStructureMigrationHandler iDoStructureMigrationHandler : this.getAllStructureMigrationHandlers()) {
            this.validateStructureMigrationHandler(iDoStructureMigrationHandler);
            Map migrationHandlersPerTypeName2 = hashMap.computeIfAbsent(iDoStructureMigrationHandler.toTypeVersion(), k -> new HashMap());
            for (String typeName : iDoStructureMigrationHandler.getTypeNames()) {
                List migrationHandlers = migrationHandlersPerTypeName2.computeIfAbsent(typeName, k -> new ArrayList());
                migrationHandlers.add(iDoStructureMigrationHandler);
                Set versions = unorderedTypeNameVersions.computeIfAbsent(typeName, k -> new HashSet());
                versions.add(iDoStructureMigrationHandler.toTypeVersion());
            }
        }
        this.validateStructureMigrationHandlerUniqueness(hashMap);
        hashMap.forEach((version, migrationHandlersPerTypeName) -> {
            HashMap migrationHandlerPerTypeName = new HashMap();
            migrationHandlersPerTypeName.forEach((typeName, migrationHandlers) -> {
                IDoStructureMigrationHandler iDoStructureMigrationHandler = migrationHandlerPerTypeName.put(typeName, (IDoStructureMigrationHandler)CollectionUtility.firstElement((List)migrationHandlers));
            });
            this.m_structureMigrationHandlers.put((NamespaceVersion)version, migrationHandlerPerTypeName);
        });
        for (Map.Entry entry : unorderedTypeNameVersions.entrySet()) {
            ArrayList<NamespaceVersion> versions = new ArrayList<NamespaceVersion>((Collection)entry.getValue());
            versions.sort(this.m_comparator);
            this.m_typeNameVersions.put((String)entry.getKey(), versions);
        }
        List<IDoValueMigrationHandler<?>> list = this.getAllValueMigrationHandlers();
        HashMap validatedValueMigrationHandlers = new HashMap();
        list.forEach(handler -> this.validateValueMigrationHandler((IDoValueMigrationHandler)handler, validatedValueMigrationHandlers));
        list.stream().sorted(Comparator.comparing(IDoValueMigrationHandler::typeVersion, this.m_comparator)).forEach(handler -> {
            IDoValueMigrationHandler iDoValueMigrationHandler = this.m_valueMigrationHandlers.put(handler.id(), (IDoValueMigrationHandler<?>)handler);
        });
    }

    protected void validateStructureMigrationHandlerUniqueness(Map<NamespaceVersion, Map<String, List<IDoStructureMigrationHandler>>> migrationHandlersPerVersionAndTypeName) {
        StringBuilder duplicateBuilder = new StringBuilder();
        for (Map.Entry<NamespaceVersion, Map<String, List<IDoStructureMigrationHandler>>> versionEntry : migrationHandlersPerVersionAndTypeName.entrySet()) {
            NamespaceVersion version = versionEntry.getKey();
            for (Map.Entry<String, List<IDoStructureMigrationHandler>> migrationHandlerEntry : versionEntry.getValue().entrySet()) {
                if (migrationHandlerEntry.getValue().size() <= 1) continue;
                if (duplicateBuilder.length() > 0) {
                    duplicateBuilder.append("\n");
                }
                duplicateBuilder.append(migrationHandlerEntry.getKey());
                duplicateBuilder.append("@");
                duplicateBuilder.append(version.unwrap());
                duplicateBuilder.append(": ");
                duplicateBuilder.append(migrationHandlerEntry.getValue().stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(", ")));
            }
        }
        if (duplicateBuilder.length() > 0) {
            throw new PlatformException("Found multiple migration handlers for the same type version/type name:\n{}", new Object[]{duplicateBuilder.toString()});
        }
    }

    protected NamespaceVersionedModel<ITypeVersion> createDefaultModel() {
        return NamespaceVersionedModel.newBuilder().withNames(this.getAllNamespaces().stream().map(INamespace::getId).collect(Collectors.toList())).withItems(this.getAllTypeVersions()).build();
    }

    protected <T extends IDoStructureMigrationHandler> T validateStructureMigrationHandler(T migrationHandler) {
        if (CollectionUtility.isEmpty(migrationHandler.getTypeNames())) {
            throw new PlatformException("Migration handler {} doesn't have any type names", new Object[]{migrationHandler});
        }
        if (CollectionUtility.containsAny(migrationHandler.getTypeNames(), (Object[])new String[]{null, ""})) {
            throw new PlatformException("Migration handler {} has invalid type names (empty, null)", new Object[]{migrationHandler});
        }
        NamespaceVersion toTypeVersion = migrationHandler.toTypeVersion();
        if (!this.m_orderedVersions.contains(toTypeVersion)) {
            throw new PlatformException("Unknown toTypeVersion value {}. Make sure that the type version value is registered within a {}", new Object[]{toTypeVersion, ITypeVersion.class.getSimpleName()});
        }
        this.validateDataObjectTypeVersion(migrationHandler);
        return migrationHandler;
    }

    protected void validateDataObjectTypeVersion(IDoStructureMigrationHandler migrationHandler) {
        NamespaceVersion typeVersionToUpdate = migrationHandler.toTypeVersion();
        DataObjectInventory inventory = (DataObjectInventory)BEANS.get(DataObjectInventory.class);
        for (String typeName : migrationHandler.getTypeNames()) {
            Class<? extends IDoEntity> doEntityClass = inventory.fromTypeName(typeName);
            if (doEntityClass == null) continue;
            NamespaceVersion doEntityVersion = inventory.getTypeVersion(doEntityClass);
            if (doEntityVersion == null) {
                throw new PlatformException("Missing a type version (at least {}) for {} specified as type name in {}", new Object[]{typeVersionToUpdate, typeName, migrationHandler});
            }
            if (!doEntityVersion.namespaceEquals(typeVersionToUpdate) || NamespaceVersion.compareVersion((NamespaceVersion)doEntityVersion, (NamespaceVersion)typeVersionToUpdate) >= 0) continue;
            throw new PlatformException("Entity do '{}' has specified a lower version than the migration handler '{}'. [entityDoVersion={}, migrationHandlerVersion={}]", new Object[]{typeName, migrationHandler.getClass().getSimpleName(), doEntityVersion, typeVersionToUpdate});
        }
    }

    protected void validateValueMigrationHandler(IDoValueMigrationHandler valueMigrationHandler, Map<DoValueMigrationId, IDoValueMigrationHandler<?>> validatedValueMigrationHandlers) {
        IDoValueMigrationHandler existingHandler = validatedValueMigrationHandlers.put(valueMigrationHandler.id(), valueMigrationHandler);
        if (existingHandler != null) {
            throw new PlatformException("Multiple value migration handlers with identical ID detected. Value migration handler IDs must be unique.\nID: {}, value migration handlers: {}, {}", new Object[]{valueMigrationHandler.id(), existingHandler.getClass().getSimpleName(), valueMigrationHandler.getClass().getSimpleName()});
        }
        NamespaceVersion typeVersion = valueMigrationHandler.typeVersion();
        if (!this.m_orderedVersions.contains(typeVersion)) {
            throw new PlatformException("Unknown type version {}. Make sure that the type version value is registered within a {}", new Object[]{typeVersion, ITypeVersion.class.getSimpleName()});
        }
    }

    public List<IDoValueMigrationHandler<?>> getValueMigrationHandlers() {
        return this.m_valueMigrationHandlers.values().stream().collect(Collectors.toUnmodifiableList());
    }

    public IDoValueMigrationHandler<?> getValueMigrationHandler(DoValueMigrationId valueMigrationId) {
        return this.m_valueMigrationHandlers.get(valueMigrationId);
    }

    public List<NamespaceVersion> getAllVersionsOrdered() {
        return Collections.unmodifiableList(new ArrayList<NamespaceVersion>(this.m_orderedVersions));
    }

    public List<NamespaceVersion> getVersions(Map<String, NamespaceVersion> typeNames, NamespaceVersion toVersion) {
        Assertions.assertTrue((toVersion == null || this.m_orderedVersions.contains(toVersion) ? 1 : 0) != 0, (String)"toVersion '{}' is unknown", (Object[])new Object[]{toVersion});
        NamespaceVersion lowestNextVersion = null;
        for (Map.Entry<String, NamespaceVersion> entry : typeNames.entrySet()) {
            Pair<FindNextMigrationHandlerVersionStatus, NamespaceVersion> nextVersionPair = this.findNextMigrationHandlerVersion(entry.getKey(), entry.getValue());
            NamespaceVersion nextVersion = (NamespaceVersion)nextVersionPair.getRight();
            if (nextVersion == null || lowestNextVersion != null && this.m_comparator.compare(lowestNextVersion, nextVersion) <= 0) continue;
            lowestNextVersion = nextVersion;
        }
        if (lowestNextVersion == null) {
            return Collections.emptyList();
        }
        List<Object> versions = new ArrayList<NamespaceVersion>(this.m_orderedVersions);
        int lowerIndex = versions.indexOf(lowestNextVersion);
        versions = versions.subList(lowerIndex, versions.size());
        if (toVersion != null) {
            int upperIndex = versions.indexOf(toVersion);
            if (upperIndex < 0) {
                return Collections.emptyList();
            }
            versions = versions.subList(0, upperIndex + 1);
        }
        versions.removeIf(version -> !this.m_structureMigrationHandlers.containsKey(version));
        return new ArrayList<Object>(versions);
    }

    public boolean isUpToDateOrMigrationAvailable(String typeName, NamespaceVersion version) {
        Pair<FindNextMigrationHandlerVersionStatus, NamespaceVersion> result = this.findNextMigrationHandlerVersion(typeName, version);
        return ObjectUtility.isOneOf((Object)result.getLeft(), (Object)((Object)FindNextMigrationHandlerVersionStatus.UP_TO_DATE), (Object[])new Object[]{FindNextMigrationHandlerVersionStatus.NO_TYPE_VERSION_YET, FindNextMigrationHandlerVersionStatus.MIGRATION_HANDLER_FOUND});
    }

    protected Pair<FindNextMigrationHandlerVersionStatus, NamespaceVersion> findNextMigrationHandlerVersion(String typeName, NamespaceVersion version) {
        NamespaceVersion typeVersion = this.m_typeNameToCurrentTypeVersion.get(typeName);
        if (typeVersion != null && typeVersion.equals((Object)version)) {
            return ImmutablePair.of((Object)((Object)FindNextMigrationHandlerVersionStatus.UP_TO_DATE), null);
        }
        List<NamespaceVersion> versions = this.m_typeNameVersions.get(typeName);
        if (versions == null) {
            return ImmutablePair.of((Object)((Object)FindNextMigrationHandlerVersionStatus.NO_MIGRATION_HANDLERS), null);
        }
        if (version == null) {
            NamespaceVersion firstVersion = (NamespaceVersion)CollectionUtility.firstElement(versions);
            return ImmutablePair.of((Object)((Object)FindNextMigrationHandlerVersionStatus.NO_TYPE_VERSION_YET), (Object)firstVersion);
        }
        if (!this.m_orderedVersions.contains(version)) {
            return ImmutablePair.of((Object)((Object)FindNextMigrationHandlerVersionStatus.UNKNOWN_TYPE_VERSION), null);
        }
        int retVal = Collections.binarySearch(versions, version, this.m_comparator);
        if (retVal >= 0) {
            if (retVal + 1 == versions.size()) {
                return ImmutablePair.of((Object)((Object)FindNextMigrationHandlerVersionStatus.INVALID_TYPE_NAME_VERSION_PAIR), null);
            }
            return ImmutablePair.of((Object)((Object)FindNextMigrationHandlerVersionStatus.MIGRATION_HANDLER_FOUND), (Object)versions.get(retVal + 1));
        }
        int insertionPoint = -retVal - 1;
        if (insertionPoint == versions.size()) {
            ArrayList<NamespaceVersion> orderedVersions = new ArrayList<NamespaceVersion>(this.m_orderedVersions);
            int index = orderedVersions.indexOf(version);
            if (index + 1 < orderedVersions.size()) {
                return ImmutablePair.of((Object)((Object)FindNextMigrationHandlerVersionStatus.MIGRATION_HANDLER_FOUND), (Object)((NamespaceVersion)orderedVersions.get(index + 1)));
            }
            return ImmutablePair.of((Object)((Object)FindNextMigrationHandlerVersionStatus.INVALID_TYPE_NAME_VERSION_PAIR), null);
        }
        return ImmutablePair.of((Object)((Object)FindNextMigrationHandlerVersionStatus.MIGRATION_HANDLER_FOUND), (Object)versions.get(insertionPoint));
    }

    public Map<String, IDoStructureMigrationHandler> getMigrationHandlers(NamespaceVersion version) {
        Assertions.assertNotNull((Object)version, (String)"version is required", (Object[])new Object[0]);
        Assertions.assertTrue((boolean)this.m_orderedVersions.contains(version), (String)"version is unknown", (Object[])new Object[0]);
        return this.m_structureMigrationHandlers.computeIfAbsent(version, k -> Collections.emptyMap());
    }

    public Set<Class<? extends IDoStructureMigrationTargetContextData>> getDoMigrationContextValues(IDoEntity doEntity) {
        Assertions.assertNotNull((Object)doEntity, (String)"doEntity is required", (Object[])new Object[0]);
        String typeName = ((DoStructureMigrationHelper)BEANS.get(DoStructureMigrationHelper.class)).getType(doEntity);
        if (typeName != null) {
            return this.m_doContextDataClassByTypeName.getOrDefault(typeName, Collections.emptySet());
        }
        return this.m_doContextDataClassByDoEntityClass.getOrDefault(doEntity.getClass(), Collections.emptySet());
    }

    protected static class ByNamespaceVersionComparator
    implements Comparator<NamespaceVersion>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<NamespaceVersion, Integer> m_ordering;

        public ByNamespaceVersionComparator(List<NamespaceVersion> versions) {
            this.m_ordering = ByNamespaceVersionComparator.createOrdering(versions);
        }

        protected static Map<NamespaceVersion, Integer> createOrdering(List<NamespaceVersion> versions) {
            HashMap<NamespaceVersion, Integer> nameOrder = new HashMap<NamespaceVersion, Integer>();
            int i = 0;
            while (i < versions.size()) {
                nameOrder.put((NamespaceVersion)Assertions.assertNotNull((Object)versions.get(i)), i);
                ++i;
            }
            return nameOrder;
        }

        @Override
        public int compare(NamespaceVersion o1, NamespaceVersion o2) {
            Integer s1 = (Integer)Assertions.assertNotNull((Object)this.m_ordering.get(o1), (String)"order for o1 ({}) is missing", (Object[])new Object[]{o1.unwrap()});
            Integer s2 = (Integer)Assertions.assertNotNull((Object)this.m_ordering.get(o2), (String)"order for o2 ({}) is missing", (Object[])new Object[]{o2.unwrap()});
            return s1.compareTo(s2);
        }
    }

    protected static enum FindNextMigrationHandlerVersionStatus {
        UP_TO_DATE,
        NO_MIGRATION_HANDLERS,
        NO_TYPE_VERSION_YET,
        UNKNOWN_TYPE_VERSION,
        INVALID_TYPE_NAME_VERSION_PAIR,
        MIGRATION_HANDLER_FOUND;

    }
}

