/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.migration;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.scout.rt.dataobject.migration.IDoStructureMigrationGlobalContextData;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class DoStructureMigrationStatsContextData
implements IDoStructureMigrationGlobalContextData {
    private static final Logger LOG = LoggerFactory.getLogger(DoStructureMigrationStatsContextData.class);
    protected final AtomicLong m_startNanos = new AtomicLong();
    protected final LongAdder m_dataObjectsProcessed = new LongAdder();
    protected final LongAdder m_dataObjectsChanged = new LongAdder();
    protected final LongAdder m_accumulatedMigrationDurationNano = new LongAdder();

    public void start() {
        this.m_startNanos.compareAndSet(0L, System.nanoTime());
    }

    protected void incrementDataObjectsProcessed() {
        this.m_dataObjectsProcessed.increment();
    }

    public long getOverallMigrationDurationNano() {
        return System.nanoTime() - this.m_startNanos.get();
    }

    public long getDataObjectsProcessedCount() {
        return this.m_dataObjectsProcessed.sum();
    }

    protected void incrementDataObjectsChanged() {
        this.m_dataObjectsChanged.increment();
    }

    public long getDataObjectsChangedCount() {
        return this.m_dataObjectsChanged.sum();
    }

    protected void addMigrationDuration(long startNano) {
        this.m_accumulatedMigrationDurationNano.add(System.nanoTime() - startNano);
    }

    public long getAccumulatedMigrationDurationNano() {
        return this.m_accumulatedMigrationDurationNano.sum();
    }

    public void printStats(String name, Integer entityCount) {
        LOG.info("Data object migration of {}{} entities finished in {} ms (accumulated raw data object migration took {} ms). Changed {} of {} processed data objects.", new Object[]{entityCount == null ? "" : entityCount + " ", name, this.m_startNanos.get() == 0L ? "?" : StringUtility.formatNanos((long)this.getOverallMigrationDurationNano()), StringUtility.formatNanos((long)this.getAccumulatedMigrationDurationNano()), this.getDataObjectsChangedCount(), this.getDataObjectsProcessedCount()});
    }
}

