/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.dataobject.migration;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.dataobject.IDataObject;
import org.eclipse.scout.rt.dataobject.IDataObjectMapper;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationContext;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationDataObjectVisitor;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationHelper;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationInventory;
import org.eclipse.scout.rt.dataobject.migration.DoStructureMigrationStatsContextData;
import org.eclipse.scout.rt.dataobject.migration.DoValueMigrationDataObjectVisitor;
import org.eclipse.scout.rt.dataobject.migration.DoValueMigrationIdsContextData;
import org.eclipse.scout.rt.dataobject.migration.IDoStructureMigrationLocalContextData;
import org.eclipse.scout.rt.dataobject.migration.IDoStructureMigrationLogger;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.namespace.NamespaceVersion;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@ApplicationScoped
public class DoStructureMigrator {
    public <T extends IDataObject> DoStructureMigratorResult<T> migrateDataObject(DoStructureMigrationContext ctx, String json, Class<T> valueType) {
        Assertions.assertNotNull((Object)json, (String)"json is required", (Object[])new Object[0]);
        return this.migrateDataObject(ctx, new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)), valueType);
    }

    public <T extends IDataObject> DoStructureMigratorResult<T> migrateDataObject(DoStructureMigrationContext ctx, InputStream inputStream, Class<T> valueType) {
        Assertions.assertNotNull((Object)inputStream, (String)"inputStream is required", (Object[])new Object[0]);
        IDataObjectMapper dataObjectMapper = (IDataObjectMapper)BEANS.get(IDataObjectMapper.class);
        IDataObject dataObject = dataObjectMapper.readValueRaw(inputStream);
        return this.migrateDataObject(ctx, dataObject, valueType);
    }

    public <T extends IDataObject> DoStructureMigratorResult<T> migrateDataObject(DoStructureMigrationContext ctx, IDataObject dataObject, Class<T> valueType) {
        Assertions.assertNotNull(valueType, (String)"valueType is required", (Object[])new Object[0]);
        return this.migrateDataObject(ctx, dataObject, valueType, null);
    }

    public <T extends IDataObject> DoStructureMigratorResult<T> migrateDataObject(DoStructureMigrationContext ctx, IDataObject dataObject, Class<T> valueType, IDoStructureMigrationLocalContextData ... initialLocalContextData) {
        return this.migrateDataObject(ctx, dataObject, valueType, (NamespaceVersion)null, initialLocalContextData);
    }

    public <T extends IDataObject> DoStructureMigratorResult<T> migrateDataObject(DoStructureMigrationContext ctx, IDataObject dataObject, Class<T> valueType, NamespaceVersion toVersion, IDoStructureMigrationLocalContextData ... initialLocalContextData) {
        boolean objectChanged;
        Assertions.assertNotNull((Object)ctx, (String)"ctx is required", (Object[])new Object[0]);
        Assertions.assertNotNull((Object)dataObject, (String)"dataObject is required", (Object[])new Object[0]);
        DoStructureMigrationContext ctxCopy = ctx.copy().withInitialLocalContext(initialLocalContextData);
        DoStructureMigrationStatsContextData stats = ctxCopy.getStats();
        IDoStructureMigrationLogger logger = ctxCopy.getLogger();
        long start = System.nanoTime();
        stats.incrementDataObjectsProcessed();
        logger.trace("Data object before migration: {}", dataObject);
        boolean structureChanged = this.applyStructureMigration(ctxCopy, dataObject, toVersion);
        if (structureChanged) {
            ctx.getLogger().trace("Data object after structure migration: {}", dataObject);
        }
        IDataObjectMapper dataObjectMapper = (IDataObjectMapper)BEANS.get(IDataObjectMapper.class);
        String migratedJson = dataObjectMapper.writeValue(dataObject);
        IDataObject typedDataObject = (IDataObject)dataObjectMapper.readValue(migratedJson, valueType);
        DoStructureMigratorResult<IDataObject> result = this.applyValueMigration(ctxCopy, typedDataObject);
        boolean valueChanged = result.isChanged();
        IDataObject migratedDataObject = result.getDataObject();
        if (valueChanged) {
            logger.trace("Data object after value migration: {}", migratedDataObject);
        }
        boolean bl = objectChanged = structureChanged || valueChanged;
        if (objectChanged) {
            stats.incrementDataObjectsChanged();
        }
        stats.addMigrationDuration(start);
        return new DoStructureMigratorResult<IDataObject>(migratedDataObject, objectChanged);
    }

    protected boolean applyStructureMigration(DoStructureMigrationContext ctx, IDataObject dataObject, NamespaceVersion toVersion) {
        Map<String, NamespaceVersion> typeVersions = ((DoStructureMigrationHelper)BEANS.get(DoStructureMigrationHelper.class)).collectRawDataObjectTypeVersions(dataObject);
        if (typeVersions.isEmpty()) {
            ctx.getLogger().debug("No data object entities with a type name found within {}", dataObject);
            return false;
        }
        List<NamespaceVersion> versions = ((DoStructureMigrationInventory)BEANS.get(DoStructureMigrationInventory.class)).getVersions(typeVersions, toVersion);
        if (versions.isEmpty()) {
            return false;
        }
        boolean structureChanged = false;
        for (NamespaceVersion version : versions) {
            DoStructureMigrationDataObjectVisitor visitor = this.createStructureMigrationVisitor(ctx, version);
            visitor.migrate(dataObject);
            structureChanged |= visitor.isChanged();
        }
        ctx.getLogger().debug("Applied structure migrations [{} -> {}] on {}", CollectionUtility.firstElement(versions), CollectionUtility.lastElement(versions), dataObject);
        return structureChanged;
    }

    protected DoStructureMigrationDataObjectVisitor createStructureMigrationVisitor(DoStructureMigrationContext ctx, NamespaceVersion version) {
        return new DoStructureMigrationDataObjectVisitor(ctx, version);
    }

    protected <T extends IDataObject> DoStructureMigratorResult<T> applyValueMigration(DoStructureMigrationContext ctx, T dataObject) {
        if (ctx.getGlobal(DoValueMigrationIdsContextData.class).getAppliedValueMigrationIds() == null) {
            return new DoStructureMigratorResult<T>(dataObject, false);
        }
        DoValueMigrationDataObjectVisitor valueMigrationVisitor = this.createValueMigrationVisitor(ctx);
        T migratedDataObject = valueMigrationVisitor.migrate(dataObject);
        return new DoStructureMigratorResult<T>(migratedDataObject, valueMigrationVisitor.isChanged());
    }

    protected DoValueMigrationDataObjectVisitor createValueMigrationVisitor(DoStructureMigrationContext ctx) {
        return new DoValueMigrationDataObjectVisitor(ctx);
    }

    @Deprecated
    public boolean migrateDataObject(DoStructureMigrationContext ctx, IDataObject dataObject) {
        return this.migrateDataObject(ctx, dataObject, (NamespaceVersion)null, new IDoStructureMigrationLocalContextData[0]);
    }

    @Deprecated
    public boolean migrateDataObject(DoStructureMigrationContext ctx, IDataObject dataObject, IDoStructureMigrationLocalContextData ... initialLocalContextData) {
        return this.migrateDataObject(ctx, dataObject, (NamespaceVersion)null, initialLocalContextData);
    }

    @Deprecated
    public boolean migrateDataObject(DoStructureMigrationContext ctx, IDataObject dataObject, NamespaceVersion toVersion, IDoStructureMigrationLocalContextData ... initialLocalContextData) {
        DoStructureMigrationContext ctxCopy = ctx.copy().withInitialLocalContext(initialLocalContextData);
        return this.applyStructureMigration(ctxCopy, dataObject, toVersion);
    }

    public static class DoStructureMigratorResult<T extends IDataObject> {
        private T m_dataObject;
        private boolean m_changed;

        public DoStructureMigratorResult(T dataObject, boolean changed) {
            this.m_dataObject = dataObject;
            this.m_changed = changed;
        }

        public T getDataObject() {
            return this.m_dataObject;
        }

        public boolean isChanged() {
            return this.m_changed;
        }
    }
}

