/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.mom.api;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.mom.api.IBiDestination;
import org.eclipse.scout.rt.mom.api.IDestination;
import org.eclipse.scout.rt.mom.api.IMessageListener;
import org.eclipse.scout.rt.mom.api.IMomImplementor;
import org.eclipse.scout.rt.mom.api.IMomTransport;
import org.eclipse.scout.rt.mom.api.IRequestListener;
import org.eclipse.scout.rt.mom.api.ISubscription;
import org.eclipse.scout.rt.mom.api.NullMomImplementor;
import org.eclipse.scout.rt.mom.api.PublishInput;
import org.eclipse.scout.rt.mom.api.SubscribeInput;
import org.eclipse.scout.rt.mom.api.marshaller.IMarshaller;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.FinalValue;
import org.eclipse.scout.rt.platform.util.IRegistrationHandle;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMomTransport
implements IMomTransport {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMomTransport.class);
    protected final FinalValue<IMomImplementor> m_delegate = new FinalValue();

    protected abstract Class<? extends IMomImplementor> getConfiguredImplementor();

    protected abstract Map<String, String> getConfiguredEnvironment();

    protected IMarshaller getConfiguredDefaultMarshaller() {
        return null;
    }

    public boolean isNullTransport() {
        Class<? extends IMomImplementor> implementorClass = this.getConfiguredImplementor();
        return implementorClass == null || NullMomImplementor.class.isAssignableFrom(implementorClass);
    }

    protected IMomImplementor initDelegate() throws Exception {
        Class implementorClass = (Class)ObjectUtility.nvl(this.getConfiguredImplementor(), NullMomImplementor.class);
        IMomImplementor implementor = (IMomImplementor)BEANS.get((Class)implementorClass);
        if (NullMomImplementor.class.isAssignableFrom(implementorClass)) {
            LOG.info("+++ Using '{}' for transport '{}'. No messages are published and received.", (Object)implementorClass.getSimpleName(), (Object)this.getClass().getSimpleName());
        } else {
            implementor.init(this.lookupEnvironment());
        }
        return implementor;
    }

    protected Map<Object, Object> lookupEnvironment() {
        IMarshaller defaultMarshaller;
        Map configuredEnv = (Map)Assertions.assertNotNull(this.getConfiguredEnvironment(), (String)"Environment for {} not specified", (Object[])new Object[]{this.getClass().getSimpleName()});
        HashMap<Object, Object> env = new HashMap<Object, Object>(configuredEnv);
        if (!env.containsKey("scout.mom.name")) {
            env.put("scout.mom.name", this.getClass().getSimpleName());
        }
        if (!env.containsKey("scout.mom.marshaller") && (defaultMarshaller = this.getConfiguredDefaultMarshaller()) != null) {
            env.put("scout.mom.marshaller", defaultMarshaller);
        }
        return env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IMomImplementor getDelegate() {
        if (!this.m_delegate.isSet()) {
            FinalValue<IMomImplementor> finalValue = this.m_delegate;
            synchronized (finalValue) {
                this.m_delegate.setIfAbsent(this::initDelegate);
            }
        }
        return (IMomImplementor)this.m_delegate.get();
    }

    public IMomImplementor getImplementor() {
        return (IMomImplementor)this.m_delegate.get();
    }

    @Override
    public <DTO> void publish(IDestination<DTO> destination, DTO transferObject, PublishInput input) {
        this.getDelegate().publish(destination, transferObject, input);
    }

    @Override
    public <DTO> ISubscription subscribe(IDestination<DTO> destination, IMessageListener<DTO> listener, SubscribeInput input) {
        return this.getDelegate().subscribe(destination, listener, input);
    }

    @Override
    public <REQUEST, REPLY> REPLY request(IBiDestination<REQUEST, REPLY> destination, REQUEST requestObject, PublishInput input) {
        return this.getDelegate().request(destination, requestObject, input);
    }

    @Override
    public <REQUEST, REPLY> ISubscription reply(IBiDestination<REQUEST, REPLY> destination, IRequestListener<REQUEST, REPLY> listener, SubscribeInput input) {
        return this.getDelegate().reply(destination, listener, input);
    }

    @Override
    public void cancelDurableSubscription(String durableSubscriptionName) {
        this.getDelegate().cancelDurableSubscription(durableSubscriptionName);
    }

    @Override
    public IRegistrationHandle registerMarshaller(IDestination<?> destination, IMarshaller marshaller) {
        return this.getDelegate().registerMarshaller(destination, marshaller);
    }

    @Override
    public void destroy() {
        if (!this.m_delegate.isSet()) {
            return;
        }
        this.getDelegate().destroy();
    }
}

