/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.mom.api;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.mom.api.IDestination;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class DestinationConfigPropertyParser {
    private static final Logger LOG = LoggerFactory.getLogger(DestinationConfigPropertyParser.class);
    protected boolean m_parsed = false;
    protected String m_rawValue;
    protected IDestination.IResolveMethod m_resolveMethod;
    protected String m_destinationName;
    protected Map<String, String> m_parameters;

    public DestinationConfigPropertyParser parse(String value) {
        Assertions.assertFalse((boolean)this.m_parsed, (String)"Already parsed", (Object[])new Object[0]);
        this.m_rawValue = value;
        if (StringUtility.hasText((CharSequence)value)) {
            URI uri = this.getAsUri(value);
            this.extractResolveMethod(uri);
            this.extractDestinationName(uri);
            this.extractParameters(uri);
        }
        this.m_parsed = true;
        return this;
    }

    protected URI getAsUri(String value) {
        try {
            return new URI(value);
        }
        catch (URISyntaxException e) {
            LOG.warn("Cannot parse value as URI: {}", (Object)value, (Object)e);
            throw new Assertions.AssertionException("Cannot parse value '{}'", new Object[]{value});
        }
    }

    protected String urlDecode(String s) {
        if (StringUtility.hasText((CharSequence)s)) {
            try {
                return URLDecoder.decode(s, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn("Unsupported encoding", (Throwable)e);
            }
        }
        return s;
    }

    protected void extractResolveMethod(URI uri) {
        String rawMethod = uri.getScheme();
        Assertions.assertNotNullOrEmpty((String)rawMethod, (String)"Resolve method not specified, please use format [resolve-method]:///[destination-name] [{}]", (Object[])new Object[]{this.m_rawValue});
        this.m_resolveMethod = (IDestination.IResolveMethod)Assertions.assertNotNull((Object)IDestination.ResolveMethod.parse(rawMethod), (String)"Unknown resolve method: '{}' [{}]", (Object[])new Object[]{rawMethod, this.m_rawValue});
    }

    protected void extractDestinationName(URI uri) {
        String name;
        if (uri.isOpaque()) {
            name = uri.getSchemeSpecificPart();
        } else {
            name = StringUtility.join((String)"", (Object[])new Object[]{uri.getHost(), uri.getPath()});
            if (StringUtility.startsWith((String)name, (String)"/")) {
                name = name.substring(1);
            }
        }
        this.m_destinationName = Assertions.assertNotNullOrEmpty((String)name, (String)"Missing destination name [{}]", (Object[])new Object[]{this.m_rawValue});
    }

    protected void extractParameters(URI uri) {
        this.m_parameters = new HashMap<String, String>();
        String[] stringArray = StringUtility.split((String)uri.getRawQuery(), (String)"&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] kv;
            String param = stringArray[n2];
            if (StringUtility.hasText((CharSequence)param) && (kv = StringUtility.split((String)param, (String)"=", (int)2)).length == 2) {
                String k = StringUtility.emptyIfNull((Object)this.urlDecode(kv[0]));
                String v = StringUtility.emptyIfNull((Object)this.urlDecode(kv[1]));
                this.m_parameters.put(k, v);
            }
            ++n2;
        }
    }

    public String getDestinationName() {
        Assertions.assertTrue((boolean)this.m_parsed, (String)"Not parsed yet", (Object[])new Object[0]);
        return this.m_destinationName;
    }

    public IDestination.IResolveMethod getResolveMethod() {
        Assertions.assertTrue((boolean)this.m_parsed, (String)"Not parsed yet", (Object[])new Object[0]);
        return this.m_resolveMethod;
    }

    public Map<String, String> getParameters() {
        Assertions.assertTrue((boolean)this.m_parsed, (String)"Not parsed yet", (Object[])new Object[0]);
        return this.m_parameters;
    }
}

