/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.mom.api.marshaller;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.eclipse.scout.rt.mom.api.marshaller.TextMarshaller;
import org.eclipse.scout.rt.platform.Bean;

@Bean
public class TextAsBytesMarshaller
extends TextMarshaller {
    @Override
    public Object marshall(Object transferObject, Map<String, String> context) {
        String plainText = (String)super.marshall(transferObject, context);
        if (plainText == null) {
            return null;
        }
        return plainText.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Object unmarshall(Object data, Map<String, String> context) {
        byte[] plainBytes = (byte[])data;
        if (plainBytes == null) {
            return null;
        }
        String plainText = new String(plainBytes, StandardCharsets.UTF_8);
        return super.unmarshall(plainText, context);
    }

    @Override
    public int getMessageType() {
        return 2;
    }
}

